<?php if ($data['is_first_active'] == 0): ?>
    <form class="coop-form" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="POST">
        <input type="hidden" name="action" value="handle_post_permission_startup" />
        <input type="hidden" name="nds_add_meta_nonce_update_banner"
            value="<?php echo esc_attr($nds_add_meta_nonce_update_banner); ?>" />
        <input type="hidden" name="action_permission" value="<?php echo esc_attr($nds_action_permission); ?>" />
        <!-- Tab choose language -->
        <div data-step="1" class="coop-group__col-2 start__display">
            <!-- Heading -->
            <div>
                <h2>
                    <?php echo esc_html__('Languages', 'cookie-opt'); ?>
                </h2>
            </div>

            <!-- Group language -->
            <div class="coop-form__group">
                <div class="coop-form__group coop-form__group--inline">
                    <div class="coop-form__group coop-form__group--inline coop-w-fit">
                        <input class="coop-form__radio" type="radio" name="coop-start__language" id="ja" value="ja" checked>
                        <label class="coop-item__pointer" for="ja"><?php echo esc_html__('Japan', 'cookie-opt'); ?></label>
                    </div>
                    <div class="coop-form__group coop-form__group--inline coop-w-fit">
                        <input class="coop-form__radio" type="radio" name="coop-start__language" value="en" id="en">
                        <label class="coop-item__pointer"
                            for="en"><?php echo esc_html__('English', 'cookie-opt'); ?></label>
                    </div>
                </div>
                <div class="coop-form__group coop-item__left">
                    <p>
                        <?php echo esc_html__('Select the language you want to display in the banner.', 'cookie-opt'); ?>
                    </p>
                </div>
            </div>
            <!-- end of Group language -->
        </div>

        <!-- Tab choose regulation -->
        <div data-step="2" class="coop-form__group coop-item__left start__display">
            <!-- Heading -->
            <div>
                <h2>
                    <?php echo esc_html__('Please select a compliant cookie regulation.', 'cookie-opt'); ?>
                </h2>
            </div>


            <!-- Group regulation -->
            <div class="coop-item__group">
                <!-- Item regulation ja -->
                <div class="coop-item coop-item--checked">
                    <input hidden="true" type="radio" id="startup_regulation-ja" name="coop-start__regulation" value="ja"
                        <?php $this->propChecked($data['regulationIndex'], 'ja') ?>>
                    <label class="coop-item__pointer" for="startup_regulation-ja">
                        <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/TBA.png'); ?>">
                        <span><?php echo esc_html__('Telecommunications Business Act', 'cookie-opt'); ?> (JP)</span>
                    </label>
                </div>


                <!-- Item regulation eu -->
                <div class="coop-item">
                    <input hidden="true" type="radio" id="startup_regulation-eu" name="coop-start__regulation" value="eu"
                        <?php $this->propChecked($data['regulationIndex'], 'eu') ?>>
                    <label class="coop-item__pointer" for="startup_regulation-eu">
                        <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/GDPR.png'); ?>">
                        <span>GDPR (EU)</span>
                    </label>
                </div>


                <!-- Item regulation us -->
                <div class="coop-item">
                    <input hidden="true" type="radio" id="startup_regulation-us" name="coop-start__regulation" value="us"
                        <?php $this->propChecked($data['regulationIndex'], 'us') ?>>
                    <label class="coop-item__pointer" for="startup_regulation-us">
                        <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/CCPA.png'); ?>">
                        <span>CCPA (US)</span>
                    </label>
                </div>

            </div>
            <!-- end Group regulation       -->
        </div>

        <!-- Tab Scan Cookie -->
        <div data-step="3" class="coop-form__group coop-item__left start__display">

            <!-- Group heading -->
            <div>
                <h2>
                    <?php echo esc_html__('Scan Cookie', 'cookie-opt'); ?>
                    <p><?php echo esc_html__('Scans cookies on a domain and configures the cookie list.', 'cookie-opt') ?>
                    </p>

                </h2>
            </div>


            <!-- Group Nav process scan -->
            <div class="coop-w--full">
                <!-- Scan button -->
                <button id="start__scan-cookie-btn" type="button"
                    class="coop-button coop-button__primary"><?php echo esc_html__('Scan', 'cookie-opt'); ?></button>


                <!-- Progress bar -->
                <div class="coop-ngprogress" data-process="0" style="margin-top: 8px;"></div>

            </div>


            <!-- Group list info cookies -->
            <div class="coop-form__group coop-list-cookie__group">
                <!-- Group heading title -->
                <div class="coop-title__group" id="start__scan-cookie-title">
                    <div>
                        <!-- <span>Successful! </span> -->
                        <span class="title">
                            <?php echo esc_html__('Found', 'cookie-opt'); ?>
                        </span>
                        <span id="start_scan-count-cookie">
                            <?php echo esc_attr('...'); ?>
                        </span>
                        <span>
                            <?php echo esc_html__('cookies on domain.', 'cookie-opt'); ?>
                        </span>
                    </div>
                    <i class="coop-icon--down"></i>
                </div>


                <!-- List cookie -->
                <div id="start__scan-cookie-list" class="coop-table__group" style="display: none;">
                </div>

            </div>

        </div>

        <!-- Tab Position -->
        <div data-step="4" class="start__display">

            <!-- Banner Preview -->
            <div class="coop-group__col-2">
                <!-- Heading -->
                <div>
                    <h2>
                        <?php echo esc_html__('Banner Preview', 'cookie-opt'); ?>
                    </h2>
                </div>


                <!-- Toggle -->
                <div class="coop-item__center">
                    <div class="coop-toggle__switch">
                        <input class="coop-toggle__input coop-banner-preview" id="start__toggle" type="checkbox"
                            data-page-preview="start">
                        <label class="coop-toggle__label" for="start__toggle"></label>
                    </div>
                </div>

            </div>


            <!-- Choose Position -->
            <div class="coop-group__col-2">
                <!-- Heading -->
                <div>
                    <h2>
                        <?php echo esc_html__('Banner Layout', 'cookie-opt'); ?>
                    </h2>
                </div>


                <!-- Position List -->
                <div>
                    <div class="coop-position__group">
                        <div class="coop-position__row">
                            <!-- Position Box Bottom Left -->
                            <div class="coop-position__item coop-position__item--checked">
                                <input type="radio" id="coop-start__box-bt-left" name="coop-start__position"
                                    value="box-bottom-left" checked>
                                <label class="coop-item__pointer" for="coop-start__box-bt-left">
                                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-box-bottom-left.png'); ?>"
                                        alt="">
                                </label>
                            </div>


                            <!-- Position Box Bottom Right -->
                            <div class="coop-position__item">
                                <input type="radio" id="coop-start__box-bt-right" name="coop-start__position"
                                    value="box-bottom-right">
                                <label class="coop-item__pointer" for="coop-start__box-bt-right">
                                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-box-bottom-right.png'); ?>"
                                        alt="">
                                </label>
                            </div>


                            <!-- Position Box Top Left -->
                            <div class="coop-position__item">
                                <input type="radio" id="coop-start__box-top-left" name="coop-start__position"
                                    value="box-top-left">
                                <label class="coop-item__pointer" for="coop-start__box-top-left">
                                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-box-top-left.png'); ?>"
                                        alt="">
                                </label>
                            </div>


                            <!-- Position Box Top Right -->
                            <div class="coop-position__item">
                                <input type="radio" id="coop-start__box-top-right" name="coop-start__position"
                                    value="box-top-right">
                                <label class="coop-item__pointer" for="coop-start__box-top-right">
                                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-box-top-right.png'); ?>"
                                        alt="">
                                </label>
                            </div>

                        </div>

                        <div class="coop-position__row">
                            <!-- Position Classic Bottom -->
                            <div class="coop-position__item">
                                <input type="radio" id="coop-start__classic-bt" name="coop-start__position"
                                    value="classic-bottom">
                                <label class="coop-item__pointer" for="coop-start__classic-bt">
                                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-classic-bottom.png'); ?>"
                                        alt="">
                                </label>
                            </div>


                            <!-- Position Classic Top -->
                            <div class="coop-position__item">
                                <input type="radio" id="coop-start__classic-top" name="coop-start__position"
                                    value="classic-top">
                                <label class="coop-item__pointer" for="coop-start__classic-top">
                                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-classic-top.png'); ?>"
                                        alt="">
                                </label>
                            </div>


                            <!-- Position Banner Bottom -->
                            <div class="coop-position__item">
                                <input type="radio" id="coop-start__banner-bt" name="coop-start__position"
                                    value="banner-bottom">
                                <label class="coop-item__pointer" for="coop-start__banner-bt">
                                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-banner-bottom.png'); ?>"
                                        alt="">
                                </label>
                            </div>


                            <!-- Position Banner Top -->
                            <div class="coop-position__item">
                                <input type="radio" id="coop-start__banner-top" name="coop-start__position">
                                <label class="coop-item__pointer" for="coop-start__banner-top" value="banner-top">
                                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-banner-top.png'); ?>"
                                        alt="">
                                </label>
                            </div>

                        </div>
                        <div class="coop-position__row">
                            <!-- Position Popup -->
                            <div class="coop-position__item">
                                <input type="radio" id="coop-start__popup" name="coop-start__position" value="popup">
                                <label class="coop-item__pointer" for="coop-start__popup">
                                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-popup.png'); ?>"
                                        alt="">
                                </label>
                            </div>

                        </div>
                    </div>
                    <div>
                        <?php $this->messageError('position') ?>
                    </div>
                </div>

            </div>


            <!-- Animation -->
            <div class="coop-group__col-2">
                <!-- Heading -->
                <div>
                    <h2>
                        <?php echo esc_html__('Animation', 'cookie-opt'); ?>
                    </h2>
                </div>


                <!-- Group Animation -->
                <div>
                    <div class="coop-form__group coop-form__group--inline">
                        <!-- Animation none -->
                        <div class="coop-form__group coop-form__group--inline">
                            <input type="radio" id="coop-start__animation--none" name="coop-start__animation" value="none"
                                checked>
                            <label class="coop-item__pointer"
                                for="coop-start__animation--none"><?php echo esc_html__('None', 'cookie-opt'); ?></label>
                        </div>



                        <!-- Animation fade -->
                        <div class="coop-form__group coop-form__group--inline">
                            <input type="radio" id="coop-start__animation--fade" name="coop-start__animation" value="fade">
                            <label class="coop-item__pointer"
                                for="coop-start__animation--fade"><?php echo esc_html__('Fade', 'cookie-opt'); ?></label>
                        </div>



                        <div class="coop-form__group coop-form__group--inline">
                            <input type="radio" id="coop-start__animation--slide" name="coop-start__animation"
                                value="slide">
                            <label class="coop-item__pointer"
                                for="coop-start__animation--slide"><?php echo esc_html__('Slide', 'cookie-opt'); ?></label>
                            <select name="coop-start__animation__slide" class="coop-form__select">
                                <option class="animation-slide" value="slide-right-to-left">
                                    <?php echo esc_html__('Right To Left', 'cookie-opt'); ?>
                                </option>
                                <option class="animation-slide" value="slide-left-to-right">
                                    <?php echo esc_html__('Left To Right', 'cookie-opt'); ?>
                                </option>
                                <option class="animation-slide" value="slide-top-to-bottom">
                                    <?php echo esc_html__('Top To Bottom', 'cookie-opt'); ?>
                                </option>
                                <option class="animation-slide" value="slide-bottom-to-top">
                                    <?php echo esc_html__('Bottom To Top', 'cookie-opt'); ?>
                                </option>
                            </select>
                        </div>

                    </div>
                    <div>
                        <?php $this->messageError('animation') ?>
                    </div>
                </div>
            </div>


            <!-- Color Picker -->
            <div class="coop-group__col-2">
                <!-- Heading -->
                <div>
                    <h2>
                        <?php echo esc_html__('Colors', 'cookie-opt'); ?>
                    </h2>
                </div>


                <!-- Color bar -->
                <div>
                    <!-- Text color -->
                    <div class="coop-group__col-2">
                        <label>
                            <?php echo esc_html__('Text color', 'cookie-opt'); ?>
                        </label>
                        <input class="cn_color text-color" type="text" name="coop-start__text-color" value="#333" />
                        <div>
                            <?php $this->messageError('text_color') ?>
                        </div>
                    </div>


                    <!-- Button color -->
                    <div class="coop-group__col-2">
                        <label>
                            <?php echo esc_html__('Button color', 'cookie-opt'); ?>
                        </label>
                        <input class="cn_color text-color" type="text" name="coop-start__btn-color" value="#dbdbdb">
                        <div>
                            <?php $this->messageError('btn_color') ?>
                        </div>
                    </div>


                    <!-- Bar color -->
                    <div id="cn_colors" class="coop-group__col-2">
                        <label>
                            <?php echo esc_html__('Bar color', 'cookie-opt'); ?>
                        </label>
                        <input class="cn_color btn-color" type="text" name="coop-start__bar-color" value="#fff" />
                        <div>
                            <?php $this->messageError('bar_color') ?>
                        </div>
                    </div>


                    <!-- Bar opacity -->
                    <div id="cn_colors" class="coop-group__col-2">
                        <label>
                            <?php echo esc_html__('Background Transparency', 'cookie-opt'); ?>
                        </label>
                        <div>
                            <input class="cn_range start__opacity-range" type="range" min="50" max="100" step="1"
                                value="100" />
                            <input class="small-text start__opacity-number" name="coop-start__bar-opacity" type="number"
                                min="50" max="100" value="100" />
                            <div>
                                <?php $this->messageError('bar_opacity') ?>
                            </div>
                        </div>
                    </div>

                </div>

            </div>

        </div>

        <!-- Group buttons -->
        <div class="coop-form__group coop-form__group--inline coop-item__left">
            <button type="button" id="previous-button" data-btn="previous"
                class="coop-button coop-button__secondary start__button"><?php echo esc_html__('Back', 'cookie-opt'); ?><button />
                <button type="button" id="next-button" data-btn="next"
                    class="coop-button coop-button__primary start__button"><?php echo esc_html__('Next', 'cookie-opt'); ?></button>
                <button type="submit" id="success-button" data-btn="submit"
                    class="coop-button coop-button__primary start__button"><?php echo esc_html__('Save', 'cookie-opt'); ?></button>
        </div>

    </form>
<?php else: ?>
    <form class="coop-form" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="POST">
        <input type="hidden" name="action" value="handle_post_reset_data_startup" />
        <input type="hidden" name="nds_add_meta_nonce_reset_data_startup"
            value="<?php echo esc_attr($nds_add_meta_nonce_reset_data_startup); ?>" />
        <input type="hidden" name="action_permission" value="<?php echo esc_attr($nds_action_permission); ?>" />
        <div class="coop-form__group">
            <h4><?php echo esc_html__('Startup settings completed', 'cookie-opt') ?></h4>
            <button type="submit" id="reset-button" data-btn="reset" class="coop-button coop-button__primary">
                <?php echo esc_html__('Reconfigure', 'cookie-opt'); ?>
            </button>
        </div>
    </form>
<?php endif; ?>