<form class="coop-form" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="POST">

    <input type="hidden" name="action" value="handle_post_permission_setting" />
    <input type="hidden" name="nds_add_meta_nonce_update_banner"
        value="<?php echo esc_attr($nds_add_meta_nonce_update_banner); ?>" />
    <input type="hidden" name="action_permission" value="<?php echo esc_attr($nds_action_permission); ?>" />
    <input type="hidden" name="setting_regulation-default"
        value="<?php echo esc_attr($data['regulationIndex']); ?>" disabled>

    <!-- Banner Active -->
    <div class="coop-group__col-2">
        <!-- Heading -->
        <div>
            <h2>
                <?php echo esc_html__('Banner Display', 'cookie-opt'); ?>
            </h2>
        </div>

        <!-- Toggle -->
        <div class="coop-item__center coop-item__gap--sm">
            <div class="coop-toggle__switch <?php $this->propClass($data['is_active_key'], -1, 'coop-item__opacity--half') ?>">
                <input class="coop-toggle__input" id="setting__banner-active" type="checkbox" name="coop-setting__banner-active" <?php $this->propChecked($data['is_active_key'], 1) ?> <?php $this->propDisabled($data['is_active_key'], -1) ?>>
                <label class="coop-toggle__label" for="setting__banner-active"></label>
            </div>

            <?php if ($data['is_active_key'] == -1): ?>
                <p><?php echo esc_html__('⚠️After registering the cookieOpt key in the public settings, you can change the setting to ON.', 'cookie-opt') ?></p>
            <?php endif; ?>
        </div>

    </div>

    <!-- Banner Preview -->
    <div class="coop-group__col-2">
        <!-- Heading -->
        <div>
            <h2>
                <?php echo esc_html__('Banner Preview', 'cookie-opt'); ?>
            </h2>
        </div>

        <!-- Toggle -->
        <div class="coop-item__center">
            <div class="coop-toggle__switch">
                <input class="coop-toggle__input coop-banner-preview" id="setting__toggle" type="checkbox"
                    data-page-preview="setting">
                <label class="coop-toggle__label" for="setting__toggle"></label>
            </div>
        </div>
    </div>

    <!-- Choose Regulation -->
    <div class="coop-group__col-2">
        <!-- Heading -->
        <div>
            <h2>
                <?php echo esc_html__('Compliant Cookie Regulation', 'cookie-opt'); ?>
            </h2>
        </div>

        <!-- Group regulation -->
        <div class="coop-item__group">
            <!-- Item regulation ja -->
            <div class="coop-item">
                <input hidden="true" type="radio" id="setting__regulation-ja" name="coop-setting__regulation"
                    value="ja" <?php $this->propChecked($data['regulationIndex'], 'ja') ?>>
                <label class="coop-item__pointer" for="setting__regulation-ja">
                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/TBA.png'); ?>">
                    <span><?php echo esc_html__('Telecommunications Business Act', 'cookie-opt'); ?> (JP)</span>
                </label>
            </div>

            <!-- Item regulation eu -->
            <div class="coop-item">
                <input hidden="true" type="radio" id="setting__regulation-eu" name="coop-setting__regulation"
                    value="eu" <?php $this->propChecked($data['regulationIndex'], 'eu') ?>>
                <label class="coop-item__pointer" for="setting__regulation-eu">
                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/GDPR.png'); ?>">
                    <span>GDPR (EU)</span>
                </label>
            </div>

            <!-- Item regulation us -->
            <div class="coop-item">
                <input hidden="true" type="radio" id="setting__regulation-us" name="coop-setting__regulation"
                    value="us" <?php $this->propChecked($data['regulationIndex'],'us') ?>>
                <label class="coop-item__pointer" for="setting__regulation-us">
                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/CCPA.png'); ?>">
                    <span>CCPA (US)</span>
                </label>
            </div>
        </div>
    </div>

    <!-- Group setting data -->
    <div id="coop-setting__group-setting-data">
        <?php include 'partials/cookie_opt_setting_data_setup.php'; ?>
    </div>

    <!-- Group Button control -->
    <div class="coop-form__group coop-form__group--inline">
        <button class="coop-button coop-button__primary" type="submit">
            <?php echo esc_html__('Save', 'cookie-opt'); ?>
        </button>
        <button id="reset-button" type="reset" class="coop-button coop-button__secondary reset">
            <?php echo esc_html__('Reset', 'cookie-opt'); ?>
        </button>
    </div>
</form>