<?php
use App\Services\ViewHelper\CookiePermissionView;
?>
<form class="" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="POST">
    <input type="hidden" name="action" value="handle_post_permission_banner_layout" />
    <input type="hidden" name="nds_add_meta_nonce_update_banner"
        value="<?php echo esc_attr($nds_add_meta_nonce_update_banner); ?>" />
    <input type="hidden" name="action_permission" value="<?php echo esc_attr($nds_action_permission); ?>" />

    <input type="hidden" class="regulation-banner" name="regulation-banner-layout" value="">

    <!-- Banner Preview -->
    <div class="coop-group__col-2">
        <!-- Heading -->
        <div>
            <h2>
                <?php echo esc_html__('Banner Preview', 'cookie-opt'); ?>
            </h2>
        </div>
        

        <!-- Toggle -->
        <div class="coop-item__center">
            <div class="coop-toggle__switch">
                <input class="coop-toggle__input coop-banner-preview" id="layout__toggle" type="checkbox" data-page-preview="layout">
                <label class="coop-toggle__label" for="layout__toggle"></label>
            </div>
        </div>
        
    </div>
    

    <!-- Choose Regulation -->
    <div class="coop-group__col-2">
        <!-- Heading -->
        <div>
            <h2>
                <?php echo esc_html__('Compliant Cookie Regulation', 'cookie-opt'); ?>
            </h2>
        </div>
        

        <!-- Group regulation -->
        <div class="coop-item__group">
            <!-- Item regulation ja -->
            <div class="coop-item">
                <input hidden="true" type="radio" id="layout__regulation-ja" name="coop-layout__regulation" value="ja">
                <label class="coop-item__pointer" for="layout__regulation-ja">
                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/TBA.png'); ?>">
                    <span><?php echo esc_html__('Telecommunications Business Act', 'cookie-opt'); ?> (JP)</span>
                </label>
            </div>
            

            <!-- Item regulation eu -->
            <div class="coop-item">
                <input hidden="true" type="radio" id="layout__regulation-eu" name="coop-layout__regulation" value="eu">
                <label class="coop-item__pointer" for="layout__regulation-eu">
                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/GDPR.png'); ?>">
                    <span>GDPR (EU)</span>
                </label>
            </div>
            

            <!-- Item regulation us -->
            <div class="coop-item">
                <input hidden="true" type="radio" id="layout__regulation-us" name="coop-layout__regulation" value="us">
                <label class="coop-item__pointer" for="layout__regulation-us">
                    <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/CCPA.png'); ?>">
                    <span>CCPA (US)</span>
                </label>
            </div>
            
        </div>
        <!-- end Group regulation -->
    </div>
    

    <!-- Choose Position -->
    <div class="coop-group__col-2">
        <!-- Heading -->
        <div>
            <h2>
                <?php echo esc_html__('Banner Layout', 'cookie-opt'); ?>
            </h2>
        </div>
        

        <!-- Position List -->
        <div>
            <div class="coop-position__group">
                <div class="coop-position__row">
                    <!-- Position Box Bottom Left -->
                    <div class="coop-position__item">
                        <input type="radio" id="layout__box-bt-left" name="coop-layout__position"
                            value="box-bottom-left" <?php echo esc_attr($data['layout']['position']['box-bottom-left']) ?>>
                        <label class="coop-item__pointer" for="layout__box-bt-left">
                            <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-box-bottom-left.png'); ?>"
                                alt="">
                        </label>
                    </div>
                    

                    <!-- Position Box Bottom Right -->
                    <div class="coop-position__item">
                        <input type="radio" id="coop-layout__box-bt-right" name="coop-layout__position"
                            value="box-bottom-right" <?php echo esc_attr($data['layout']['position']['box-bottom-right']) ?>>
                        <label class="coop-item__pointer" for="coop-layout__box-bt-right">
                            <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-box-bottom-right.png'); ?>"
                                alt="">
                        </label>
                    </div>
                    

                    <!-- Position Box Top Left -->
                    <div class="coop-position__item">
                        <input type="radio" id="coop-layout__box-top-left" name="coop-layout__position"
                            value="box-top-left" <?php echo esc_attr($data['layout']['position']['box-top-left']) ?>>
                        <label class="coop-item__pointer" for="coop-layout__box-top-left">
                            <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-box-top-left.png'); ?>"
                                alt="">
                        </label>
                    </div>
                    

                    <!-- Position Box Top Right -->
                    <div class="coop-position__item">
                        <input type="radio" id="coop-layout__box-top-right" name="coop-layout__position"
                            value="box-top-right" <?php echo esc_attr($data['layout']['position']['box-top-right']) ?>>
                        <label class="coop-item__pointer" for="coop-layout__box-top-right">
                            <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-box-top-right.png'); ?>"
                                alt="">
                        </label>
                    </div>
                    
                </div>

                <div class="coop-position__row">
                    <!-- Position Classic Bottom -->
                    <div class="coop-position__item">
                        <input type="radio" id="coop-layout__classic-bt" name="coop-layout__position"
                            value="classic-bottom" <?php echo esc_attr($data['layout']['position']['classic-bottom']) ?>>
                        <label class="coop-item__pointer" for="coop-layout__classic-bt">
                            <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-classic-bottom.png'); ?>"
                                alt="">
                        </label>
                    </div>
                    

                    <!-- Position Classic Top -->
                    <div class="coop-position__item">
                        <input type="radio" id="coop-layout__classic-top" name="coop-layout__position"
                            value="classic-top" <?php echo esc_attr($data['layout']['position']['classic-top']) ?>>
                        <label class="coop-item__pointer" for="coop-layout__classic-top">
                            <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-classic-top.png'); ?>"
                                alt="">
                        </label>
                    </div>
                    

                    <!-- Position Banner Bottom -->
                    <div class="coop-position__item">
                        <input type="radio" id="coop-layout__banner-bt" name="coop-layout__position"
                            value="banner-bottom" <?php echo esc_attr($data['layout']['position']['banner-bottom']) ?>>
                        <label class="coop-item__pointer" for="coop-layout__banner-bt">
                            <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-banner-bottom.png'); ?>"
                                alt="">
                        </label>
                    </div>
                    

                    <!-- Position Banner Top -->
                    <div class="coop-position__item">
                        <input type="radio" id="coop-layout__banner-top" name="coop-layout__position" value="banner-top"
                            <?php echo esc_attr($data['layout']['position']['banner-top']) ?>>
                        <label class="coop-item__pointer" for="coop-layout__banner-top">
                            <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-banner-top.png'); ?>"
                                alt="">
                        </label>
                    </div>
                    
                </div>
                <div class="coop-position__row">
                    <!-- Position Popup -->
                    <div class="coop-position__item">
                        <input type="radio" id="coop-layout__popup" name="coop-layout__position" value="popup" <?php echo esc_attr($data['layout']['position']['popup']) ?>>
                        <label class="coop-item__pointer" for="coop-layout__popup">
                            <img src="<?php echo esc_attr(COOKIE_OPT_URL . '/public/assets/images/cookie-popup.png'); ?>"
                                alt="">
                        </label>
                    </div>
                    
                </div>
            </div>
            <div>
                <?php $this->messageError('position') ?>
            </div>
        </div>
        
    </div>
    

    <!-- Animation -->
    <div class="coop-group__col-2">
        <!-- Heading -->
        <div>
            <h2>
                <?php echo esc_html__('Animation', 'cookie-opt'); ?>
            </h2>
        </div>

        <!-- Group Animation -->
        <div>
            <div class="coop-form__group coop-form__group--inline">
                <!-- Animation none -->
                <div class="coop-form__group coop-form__group--inline">
                    <input type="radio" id="layout__animation--none" name="coop-layout__animation" value="none" <?php echo esc_attr($data['layout']['animation']['none']) ?>>
                    <label class="coop-item__pointer"
                        for="layout__animation--none"><?php echo esc_html__('None', 'cookie-opt'); ?></label>
                </div>

                <!-- Animation fade -->
                <div class="coop-form__group coop-form__group--inline">
                    <input type="radio" id="layout__animation--fade" name="coop-layout__animation" value="fade" <?php echo esc_attr($data['layout']['animation']['fade']) ?>>
                    <label class="coop-item__pointer"
                        for="layout__animation--fade"><?php echo esc_html__('Fade', 'cookie-opt'); ?></label>
                </div>
                
                <!-- Fade list -->
                <div class="coop-form__group coop-form__group--inline">
                    <input type="radio" id="layout__animation--slide" name="coop-layout__animation" value="slide" <?php echo esc_attr($data['layout']['animation']['slide']) ?>>
                    <label class="coop-item__pointer"
                        for="layout__animation--slide"><?php echo esc_html__('Slide', 'cookie-opt'); ?></label>
                    <select name="coop-layout__animation__slide" class="coop-form__select">
                        <option class="animation-slide" value="slide-right-to-left" <?php echo esc_attr($data['layout']['slide']['slide-right-to-left']) ?>>
                            <?php echo esc_html__('Right To Left', 'cookie-opt'); ?>
                        </option>
                        <option class="animation-slide" value="slide-left-to-right" <?php echo esc_attr($data['layout']['slide']['slide-left-to-right']) ?>>
                            <?php echo esc_html__('Left To Right', 'cookie-opt'); ?>
                        </option>
                        <option class="animation-slide" value="slide-top-to-bottom" <?php echo esc_attr($data['layout']['slide']['slide-top-to-bottom']) ?>>
                            <?php echo esc_html__('Top To Bottom', 'cookie-opt'); ?>
                        </option>
                        <option class="animation-slide" value="slide-bottom-to-top" <?php echo esc_attr($data['layout']['slide']['slide-bottom-to-top']) ?>>
                            <?php echo esc_html__('Bottom To Top', 'cookie-opt'); ?>
                        </option>
                    </select>
                </div>
            </div>
            <div>
                <?php $this->messageError('animation') ?>
            </div>
        </div>
        
    </div>
    
    <!-- Color Picker -->
    <div class="coop-group__col-2">
        <!-- Heading -->
        <div>
            <h2>
                <?php echo esc_html__('Colors', 'cookie-opt'); ?>
            </h2>
        </div>
        
        <!-- Color bar -->  
        <div>
            <!-- Text color -->
            <div class="coop-group__col-2">
                <label>
                    <?php echo esc_html__('Text color', 'cookie-opt'); ?>
                </label>
                <input class="cn_color text-color" type="text" name="coop-layout__text-color"
                    value="<?php echo esc_attr($data['layout']['text_color']) ?>" />
                <div>
                    <?php $this->messageError('text_color') ?>
                </div>
            </div>
            
            <!-- Button color -->
            <div class="coop-group__col-2">
                <label>
                    <?php echo esc_html__('Button color', 'cookie-opt'); ?>
                </label>
                <input class="cn_color" type="text" name="coop-layout__btn-color"
                    value="<?php echo esc_attr($data['layout']['button_color']) ?>" />
                <div>
                    <?php $this->messageError('btn_color') ?>
                </div>
            </div>
            
            <!-- Bar color -->
            <div class="coop-group__col-2">
                <label>
                    <?php echo esc_html__('Bar color', 'cookie-opt'); ?>
                </label>
                <input class="cn_color btn-color" type="text" name="coop-layout__bar-color"
                    value="<?php echo esc_attr($data['layout']['bar_color']) ?>" />
                <div>
                    <?php $this->messageError('bar_color') ?>
                </div>
            </div>
            
            <!-- Bar opacity -->
            <div class="coop-group__col-2">
                <label>
                    <?php echo esc_html__('Background Transparency', 'cookie-opt'); ?>
                </label>
                <div>
                    <input class="cn_range layout__opacity-range" type="range" min="50" max="100" step="1"
                        value="<?php echo esc_attr($data['layout']['bar_opacity']) ?>" />
                    <input class="small-text layout__opacity-number" name="coop-layout__bar-opacity" type="number"
                        min="50" max="100" value="<?php echo esc_attr($data['layout']['bar_opacity']) ?>" />
                </div>
                <div>
                    <?php $this->messageError('bar_opacity') ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Button control -->
    <div class="coop-form__group coop-form__group--inline">
        <button class="coop-button coop-button__primary" type="submit">
            <?php echo esc_html__('Save Changes', 'cookie-opt'); ?>
        </button>
    </div>
</form>