<?php
$nds_add_meta_nonce_update_banner = wp_create_nonce('nds_add_meta_nonce_update_banner');
$nds_action_permission = wp_create_nonce('action_permission');
$nonce_ajax_scan = wp_create_nonce('ajax_scan');
$nds_add_meta_nonce_reset_data_startup = wp_create_nonce('nds_add_meta_nonce_reset_data_startup')
?>
<div class="coop-section">
    <div class="coop-startup">
        <!-- Heading -->
        <h1 class="coop-heading">
            <?php echo esc_html__('Startup Settings', 'cookie-opt'); ?>
        </h1>

        <hr class="wp-header-end">
        <!-- Content -->
        <div id="cookie-opt-permission">
            <input type="hidden" name="ajax_scan" value="<?php echo esc_attr($nonce_ajax_scan); ?>">
            <input type="hidden" id="coop-key--is-active" value="<?php echo esc_attr($data['is_active_key']); ?>">
            <!-- Tab link -->
            <div class="coop-tab coop-bg-white">
                <button
                    class="coop-tab__link <?php echo esc_attr((!isset($_GET['index']) || sanitize_text_field(wp_unslash($_GET['index'])) == 'startup') ? 'active' : '') //phpcs:ignore WordPress.Security?>"
                    data-tab="start">
                    <?php echo esc_html__('Startups', 'cookie-opt') ?>
                </button>
                <button
                    class="coop-tab__link <?php echo esc_attr((isset($_GET['index']) && sanitize_text_field(wp_unslash($_GET['index'])) == 'setting') ? 'active' : '') //phpcs:ignore WordPress.Security?>"
                    data-tab="setting">
                    <?php echo esc_html__('Setting', 'cookie-opt'); ?>
                </button>
                <button
                    class="coop-tab__link <?php echo esc_attr((isset($_GET['index']) && sanitize_text_field(wp_unslash($_GET['index'])) == 'banner_layout') ? 'active' : '') //phpcs:ignore WordPress.Security?>"
                    data-tab="layout">
                    <?php echo esc_html__('Banner Layout', 'cookie-opt'); ?>
                </button>
            </div>

            <!-- Tab content -->
            <div class="coop-tab__content">
                <!-- Content of Startup Tab -->
                <div class="coop-tab__panel" id="start">
                    <?php include 'cookie_permission_startup.php'; ?>
                </div>

                <!-- Content of Setting Tab -->
                <div class="coop-tab__panel" id="setting">
                    <?php include 'cookie_permission_setting.php'; ?>
                </div>

                <!-- Content of Position Tab -->
                <div class="coop-tab__panel" id="layout">
                    <?php include 'cookie_permission_banner_layout.php'; ?>
                </div>

            </div>

        </div>

    </div>

    <!-- Modal Banner -->
    <div class="modal" id="modal"></div>

</div>