<?php
$button_handles = [
    'reject' => 'reject_button',
    'accept' => 'accept_button'
];
$regulation_customs = ['eu', 'us'];
$none = wp_create_nonce('nds_view_banner');
$none2 = wp_create_nonce('none_handle_banner');

// dd($data['display'] == 0 ? 'true' : 'false');
?>

<div class="modal <?php $this->propClass($data['hidden'], true, 'coop-display--none') ?>">
    <input id="none_view" type="hidden" name="none" value="<?php echo esc_attr($none); ?>">
    <input id="display_banner" hidden value="<?php echo $data['hidden'] == true ? 'hide' : 'show' ?>">

    <div data-banner="banner-main" class="coop-banner <?php echo esc_attr($data['position'] . ' ' . $data['animation']) ?>"
        style="<?php echo esc_attr($data['style_banner']) ?>">
        <!-- Title -->
        <div class="coop-title__group" style="color: #0a0a0a;">
            <span class="coop-title__heading coop-change-value" data-change-value="banner-title">
                <?php echo esc_html($data['title']) ?>
            </span>
            <i data-icon="banner-main" class="coop-icon--close">&times;</i>
        </div>

        <!-- Description -->
        <div class="coop-banner__content coop-change-value" data-change-value="banner-description"
            style="color: #0a0a0a;">
            <p>
                <?php echo esc_html($data['description']) ?>
            </p>
        </div>

        <!-- Group Buttons -->
        <div class="coop-banner__buttons">
            <?php foreach ($data['buttons'] as $key => $value): ?>
                <a target="<?php echo esc_attr($data['target']) ?>" <?php echo esc_attr($data['buttons_link'][$key]) ?>
                    class="coop-banner__button coop-change-value <?php echo esc_attr(in_array($key, $button_handles) ? 'handle-cookie' : ''); ?>"
                    data-type="<?php echo esc_attr($key == $button_handles['reject'] ? 3 : ($key == $button_handles['accept'] ? 1 : '')); ?>"
                    data-button="<?php echo esc_attr($key) ?>" data-change-value="<?php echo esc_attr('banner-' . $key) ?>"
                    style="<?php echo esc_attr($data['style_button']) ?>">
                    <?php echo esc_html($value) ?>
                </a>
            <?php endforeach; ?>
        </div>
    </div>

    <?php if (in_array($data['regulation'], $regulation_customs)): ?>
        <form id="form-banner" class="">
            <input type="hidden" name="none" value="<?php echo esc_attr($none2); ?>">
            <input type="hidden" name="action" value="handle_banner">

            <!-- Group Customize Banner -->
            <div data-banner="banner-customize" class="coop-banner <?php echo esc_attr($data['position'] . ' ' . $data['animation']) ?>"
                style="<?php echo esc_attr($data['style_banner']) ?>; display:none;">
                <!-- Customize Title -->
                <div class="coop-title__group" style="color: #0a0a0a;">
                    <span class="coop-title__heading coop-change-value" data-change-value="banner-cus-title">
                        <?php echo esc_html($data['customize']['title']) ?>
                    </span>
                    <i data-icon="banner-customize" class="coop-icon--close coop-item__pointer">x</i>
                </div>

                <!-- Customize Description -->
                <div class="coop-banner__content" style="color: #0a0a0a;">
                    <span data-change-value="banner-cus-des" class="coop-change-value">
                        <?php
                        str_replace($data['customize']['here'], '<a id="banner__policy-link" class="coop-change-value" date-change-value="banner-here-link" href="' . $data['buttons_link']['privacy_policy_button'] . '">' . $data['customize']['here'] . '</a>', $data['customize']['description']); //phpcs:ignore WordPress.Security
                        // ?>
                        <?php //echo (($data['customize']['description']))  ?>
                    </span>
                </div>

                <!-- Group Toggle Accept Cookie -->
                <div class="coop-form__group" style="color: #0a0a0a;">
                    <!-- Necessary Cookie -->
                    <div class="coop-form__group coop-form__group--inline coop-item__between">
                        <span class="coop-change-value" data-change-value="banner-cus__necessary-cookies">
                            <?php echo esc_html($data['category_list']['necessary_cookies']) ?>
                        </span>
                        <span id="alway_active" class="coop-change-value" data-change-value="banner-cus__always-active">
                            <?php echo esc_html($data['customize']['always_active']) ?>
                        </span>
                    </div>

                    <!-- Performance Cookie -->
                    <div class="coop-form__group coop-form__group--inline coop-item__between">
                        <span class="coop-change-value" data-change-value="banner-cus__performance-cookies">
                            <?php echo esc_html($data['category_list']['performance_cookies']) ?>
                        </span>
                        <div>
                            <div class="coop-toggle__switch">
                                <input class="coop-toggle__input cookie-category-type"
                                    name="cookie_category[performance_cookies]" id="banner__performance-cookie"
                                    type="checkbox" checked>
                                <label class="coop-toggle__label" for="banner__performance-cookie"></label>
                            </div>
                        </div>
                    </div>

                    <!-- Functionality Cookie -->
                    <div class="coop-form__group coop-form__group--inline coop-item__between">
                        <span class="coop-change-value" data-change-value="banner-cus__functionality-cookies">
                            <?php echo esc_html($data['category_list']['functionality_cookies']) ?>
                        </span>
                        <div>
                            <div class="coop-toggle__switch">
                                <input class="coop-toggle__input cookie-category-type"
                                    name="cookie_category[functionality_cookies]" id="banner__functionality-cookie"
                                    type="checkbox" checked>
                                <label class="coop-toggle__label" for="banner__functionality-cookie"></label>
                            </div>
                        </div>
                    </div>

                    <!-- Social media Cookie -->
                    <div class="coop-form__group coop-form__group--inline coop-item__between">
                        <span class="coop-change-value" data-change-value="banner-cus__social-media-cookies">
                            <?php echo esc_html($data['category_list']['social_media_cookies']) ?>
                        </span>
                        <div>
                            <div class="coop-toggle__switch">
                                <input class="coop-toggle__input cookie-category-type"
                                    name="cookie_category[social_media_cookies]" id="banner__social-media-cookie"
                                    type="checkbox" checked>
                                <label class="coop-toggle__label" for="banner__social-media-cookie"></label>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Button Save -->
                <div class="coop-banner__buttons">
                    <button class="coop-banner__button coop-change-value handle-cookie" type="button"
                        data-button="button_save" data-change-value="banner-save_button" data-type="2"
                        style="<?php echo esc_attr($data['style_button']) ?>">
                        <?php echo esc_html($data['customize']['button_save']) ?>
                    </button>
                </div>
            </div>
        </form>
    <?php endif; ?>
</div>