<?php

class Table
{
	protected function __clone()
	{
	}

	protected function __construct()
	{
	}

	public function __wakeup()
	{
		throw new \Exception('Cannot unserialize a singleton.');
	}

	public static function getInstance()
	{
		static $instance = null;
		if (null === $instance) {
			$instance = new static();
		}
		return $instance;
	}

	public static function create_table_for_cookie_plugin()
	{
		$table = self::getInstance();
		$table->create_table_cookie_opt_cookie_category();
		$table->initial_data_cookie_opt_cookie_category();
		$table->create_table_cookie_opt_tag_info();
		$table->initial_data_cookie_opt_tag_info();
		$table->create_table_cookie_opt_tag_management();
		$table->create_table_cookie_opt_banner();
		$table->initial_data_cookie_opt_banner();
		$table->create_table_cookie_opt_cookie_list();
		$table->create_table_cookie_opt_cookie_info();
		$table->initial_data_cookie_opt_cookie_info();
		$table->initial_data_options();
		$table->create_table_cookie_opt_statistics();
		$table->add_option_cookie_opt_deactivation();

		//$table->create_table_cookie_opt_cookie_languages();
		// $table->initial_data_cookie_opt_cookie_languages();
	}

	public static function drop_table_for_cookie_plugin()
	{
		$table = self::getInstance();
		$table->drop_table('cookie_opt_statistics');
		$table->drop_data_wp_options();
		// $table->drop_table('cookie_opt_cookie_languages');
		$table->drop_table('cookie_opt_cookie_info');
		$table->drop_table('cookie_opt_tag_management');
		$table->drop_table('cookie_opt_tag_info');
		$table->drop_table('cookie_opt_cookie_category');
		$table->drop_table('cookie_opt_banner');
		$table->drop_table('cookie_opt_cookie_list');
	}

	public function add_option_cookie_opt_deactivation()
	{
		$option_value = get_option('cookie_opt_deactivation');
		if ($option_value === false) {
			add_option('cookie_opt_deactivation', '1', '', 'no');
		}
	}

	public function create_table_cookie_opt_cookie_category()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_cookie_category';
		$charset_collate = $wpdb->get_charset_collate();

		$table_result = $wpdb->get_var( // phpcs:ignore WordPress.DB
			$wpdb->prepare('SHOW TABLES LIKE %s', $table_name)
		);

		if ($table_result != $table_name) {
			$sql = "CREATE TABLE $table_name (
				id INT NOT NULL AUTO_INCREMENT,
				name VARCHAR(255) NOT NULL,
				description TEXT,
				PRIMARY KEY (id)
			  ) $charset_collate;";
			require_once ABSPATH . 'wp-admin/includes/upgrade.php';
			dbDelta($sql);
		}
		//do something with exist table
	}

	public function create_table_cookie_opt_tag_info()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_tag_info';
		$charset_collate = $wpdb->get_charset_collate();

		$table_result = $wpdb->get_var( // phpcs:ignore WordPress.DB
			$wpdb->prepare('SHOW TABLES LIKE %s', $table_name)
		);

		if ($table_result != $table_name) {
			$sql = "CREATE TABLE $table_name (
				tagid BIGINT NOT NULL AUTO_INCREMENT,
                name VARCHAR(255) NOT NULL,
                position INT NOT NULL DEFAULT 0,
                tagcategory INT DEFAULT 1,
                PRIMARY KEY (tagid)
			  ) $charset_collate;";
			require_once ABSPATH . 'wp-admin/includes/upgrade.php';
			dbDelta($sql);
		}
		//do something with exist table
	}

	public function create_table_cookie_opt_tag_management()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_tag_management';
		$charset_collate = $wpdb->get_charset_collate();

		$table_result = $wpdb->get_var( // phpcs:ignore WordPress.DB
			$wpdb->prepare('SHOW TABLES LIKE %s', $table_name)
		);

		if ($table_result != $table_name) {
			$sql = "CREATE TABLE $table_name (
                id BIGINT NOT NULL AUTO_INCREMENT,
                tagid BIGINT(20) NULL  DEFAULT NULL,
                name VARCHAR(255) NOT NULL,
                tag TEXT NOT NULL,
                position INT NOT NULL DEFAULT 0,
                installation_page LONGTEXT NOT NULL,
                active INT NOT NULL,
                created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (id)
            )$charset_collate;";
			require_once ABSPATH . 'wp-admin/includes/upgrade.php';
			dbDelta($sql);
		}
		//do something with exist table
	}

	public function create_table_cookie_opt_banner()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_banner';
		$charset_collate = $wpdb->get_charset_collate();

		$table_result = $wpdb->get_var( // phpcs:ignore WordPress.DB
			$wpdb->prepare('SHOW TABLES LIKE %s', $table_name)
		);

		if ($table_result != $table_name) {
			$sql = "CREATE TABLE $table_name (
                id BIGINT NOT NULL AUTO_INCREMENT,
                regulation VARCHAR(255) NOT NULL,
                setting LONGTEXT NOT NULL,
                status int NOT NULL,
                contents LONGTEXT NOT NULL,
                default_language VARCHAR(255) NOT NULL,
                created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
                updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (id)
            )$charset_collate;";
			require_once ABSPATH . 'wp-admin/includes/upgrade.php';
			dbDelta($sql);
		}
	}

	public function create_table_cookie_opt_cookie_list()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_cookie_list';
		$charset_collate = $wpdb->get_charset_collate();

		$table_result = $wpdb->get_var( // phpcs:ignore WordPress.DB
			$wpdb->prepare('SHOW TABLES LIKE %s', $table_name)
		);

		if ($table_result != $table_name) {
			$sql = "CREATE TABLE $table_name (
                id BIGINT NOT NULL AUTO_INCREMENT,
                name VARCHAR(255) NOT NULL,
                categoryID INT NOT NULL DEFAULT 0,
                description VARCHAR(255),
                publisher VARCHAR(255),
				type INT NOT NULL DEFAULT 0 COMMENT '0 is scan, 1 is add',
                PRIMARY KEY (id)
            )$charset_collate;";
			require_once ABSPATH . 'wp-admin/includes/upgrade.php';
			dbDelta($sql);
		}
	}

	public function create_table_cookie_opt_cookie_languages()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_cookie_languages';
		$charset_collate = $wpdb->get_charset_collate();

		$table_result = $wpdb->get_var( // phpcs:ignore WordPress.DB
			$wpdb->prepare('SHOW TABLES LIKE %s', $table_name)
		);

		if ($table_result != $table_name) {
			$sql = "CREATE TABLE $table_name (
				language BIGINT NOT NULL AUTO_INCREMENT,
                code VARCHAR(255) NOT NULL,
                name VARCHAR(255) NOT NULL,
                default_language INT NOT NULL DEFAULT 0,
                status INT NOT NULL DEFAULT 0,
                support INT NOT NULL DEFAULT 0,
                PRIMARY KEY (language)
			  ) $charset_collate;";
			require_once ABSPATH . 'wp-admin/includes/upgrade.php';
			dbDelta($sql);
		}
		//do something with exist table
	}

	public function initial_data_cookie_opt_cookie_category()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_cookie_category';

		$checkExit =
			$wpdb->get_var( // phpcs:ignore WordPress.DB
				$wpdb->prepare('SHOW TABLES LIKE %s', $table_name)
			) == $table_name;

		$check_not_exit_data = $wpdb->get_var("SELECT COUNT(id) FROM {$table_name}"); // phpcs:ignore WordPress.DB
		if ($checkExit && $check_not_exit_data == 0) {
			$data = [
				[
					'name' =>
						'{"en":"Strictly Necessary Cookies","ja":"不可欠なクッキー"}',
					'description' =>
						'{"en":"These cookies are essential to enable you to browse around our websites and use their features.","ja":"このカテゴリーのCookieは、お客様がこのウェブサイトを自由に閲覧し、その機能を利用する上で欠かせないものです。"}',
				],
				[
					'name' =>
						'{"en":"Performance Cookies","ja":"パフォーマンスクッキー"}',
					'description' =>
						'{"en":"These cookies collect information about how you use our websites — for instance, which pages you go to most. This data may be used to help optimize our websites and make them easier for you to navigate. These cookies are also used to let affiliates know if you came to one of our websites from an affiliate and if your visit resulted in the use or purchase of a product or service from us, including details of the product or service purchased. These cookies don’t collect information that identifies you. All information these cookies collect is aggregated and therefore anonymous.","ja":"このカテゴリーのCookieは、最もアクセスが多いページなど、当社のウェブサイトの利用状況についての情報を収集します。収集したデータはウェブサイトの最適化に使われ、お客様による操作をさらに簡単にします。お客様がアフィリエイトサイトからこのウェブサイトにアクセスし、さらにそこで製品を購入したりサービスを利用したことをその詳細とともにアフィリエイトに知らせるのも、このカテゴリーのCookieです。このCookieは、個人を特定できる情報を収集しません。また、収集されたすべての情報は集計されるため、匿名性が保たれます。"}',
				],
				[
					'name' => '{"en":"Functionality Cookie","ja":"機能性クッキー"}',
					'description' =>
						'{"en":"These cookies allow our websites to remember choices you make while browsing. For instance, we may store your geographic location in a cookie to ensure that we show you our website localized for your area. We may also remember preferences such as text size, fonts, and other customizable site elements. They may also be used to keep track of what featured products or videos have been viewed to avoid repetition. The information these cookies collect will not personally identify you, and they cannot track your browsing activity on other websites.","ja":"このカテゴリーのCookieは、ウェブサイト閲覧時のお客様による選択を記憶できるようにします。例えば、お客様がいる国や地域に合わせたウェブサイトが自動的に表示されるように、当社がお客様の地理的な位置情報を保存する場合があります。ウェブサイト上のテキストのサイズやフォント、カスタマイズできるその他の要素などの環境設定を保存する場合もあります。選択の繰り返しを避けるために、お客様が閲覧した製品やビデオを記録するのも、このカテゴリーのCookieです。このCookieが収集した情報によって個人が特定されることはありません。また、ここ以外のウェブサイトでのお客様の行動をこのCookieが追跡することもできません。"}',
				],
				[
					'name' =>
						'{"en":"Social Media Cookies","ja":"ソーシャルメディアクッキー"}',
					'description' =>
						'{"en":"These cookies are used to share information, such as using social media share or like buttons, to link accounts of visitors to our website, or to interact with content on our website on or through social networks such as Facebook and Twitter. Social networks record the above behavior of our website visitors. Information collected by these cookies may be used for targeting and advertising activities.","ja":"このカテゴリーのCookieは、ソーシャルメディアの共有ボタンもしくは「いいね」ボタンなどを使用して情報を共有する場合、当社ウェブサイト訪問者のアカウントをリンクする場合、またはFacebook、Twitterなどのソーシャルネットワーク上において、もしくはそれを通じて当社ウェブサイト上のコンテンツと係わる場合に使用されます。ソーシャルネットワークは、当社ウェブサイト訪問者の上記の行動を記録します。これらのクッキーにより収集される情報は、ターゲティングおよび広告活動に使用されることがあります。"}',
				],
			];
			foreach ($data as $item) {
				$wpdb->insert($table_name, $item); // phpcs:ignore WordPress.DB
			}
		}
	}

	public function initial_data_cookie_opt_tag_info()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_tag_info';

		$checkExit =
			$wpdb->get_var( // phpcs:ignore WordPress.DB
				$wpdb->prepare('SHOW TABLES LIKE %s', $table_name)
			) == $table_name;

		$check_not_exit_data = $wpdb->get_var("SELECT COUNT(tagid) FROM {$table_name}"); // phpcs:ignore WordPress.DB

		if ($checkExit && $check_not_exit_data == 0) {
			$data_to_insert = [
				[
					'name' => '[Google Analytics] Global site tag',
					'position' => 0,
					'tagcategory' => 3,
				],
				[
					'name' => '[Google Ads] Global site tag',
					'position' => 0,
					'tagcategory' => 3,
				],
				[
					'name' => '[Google Ads] Conversion tag',
					'position' => 0,
					'tagcategory' => 3,
				],
				[
					'name' => '[Yahoo! Ads] Site general tag',
					'position' => 0,
					'tagcategory' => 3,
				],
				[
					'name' => '[Yahoo! Ads] Conversion tag',
					'position' => 0,
					'tagcategory' => 3,
				],
				[
					'name' => '[TikTok Ads] TikTok Pixel',
					'position' => 0,
					'tagcategory' => 3,
				],
				[
					'name' => '[Meta Ads] Meta pixel',
					'position' => 0,
					'tagcategory' => 3,
				],
				[
					'name' => '[Microsoft Advertising] UET tag',
					'position' => 0,
					'tagcategory' => 3,
				],
				[
					'name' => '[Twitter Ads] Twitter Pixel',
					'position' => 0,
					'tagcategory' => 3,
				],
			];

			foreach ($data_to_insert as $data) {
				$wpdb->insert($table_name, $data); // phpcs:ignore WordPress.DB
			}
		}
	}

	public function drop_table($name)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . $name;
		$charset_collate = $wpdb->get_charset_collate();

		$table_result = $wpdb->get_var( // phpcs:ignore WordPress.DB
			$wpdb->prepare('SHOW TABLES LIKE %s', $table_name)
		);

		if ($table_result == $table_name) {
			$wpdb->query("DROP TABLE {$table_name}"); // phpcs:ignore WordPress.DB
		}
	}

	public function create_table_cookie_opt_cookie_info()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_cookie_info';
		$charset_collate = $wpdb->get_charset_collate();

		$table_result = $wpdb->get_var( // phpcs:ignore WordPress.DB
			$wpdb->prepare('SHOW TABLES LIKE %s', $table_name)
		);

		if ($table_result != $table_name) {
			$sql = "CREATE TABLE $table_name (
                cookieid INT AUTO_INCREMENT PRIMARY KEY,
                tagid INT NOT NULL,
                name VARCHAR(255) NOT NULL,
                description VARCHAR(255)
			  ) $charset_collate;";
			require_once ABSPATH . 'wp-admin/includes/upgrade.php';
			dbDelta($sql);
		}
		//do something with exist table
	}

	public function initial_data_cookie_opt_cookie_info()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_cookie_info';

		$checkExit =
			$wpdb->get_var( // phpcs:ignore WordPress.DB
				$wpdb->prepare('SHOW TABLES LIKE %s', $table_name)
			) == $table_name;

		$check_not_exit_data = $wpdb->get_var("SELECT COUNT(*) FROM {$table_name}"); // phpcs:ignore WordPress.DB

		if ($checkExit && $check_not_exit_data == 0) {
			$data = [
				[
					'tagid' => 1,
					'name' => '_ga',
					'description' =>
						'Google アナリティクス - ユーザーを識別するために使用されます。有効期限は2年間です.',
				],
				[
					'tagid' => 1,
					'name' => '_gid',
					'description' =>
						'Google アナリティクス - ユーザーを識別するために使用されます。有効期限は24時間です.',
				],
				[
					'tagid' => 1,
					'name' => '_gat',
					'description' =>
						'リクエスト率を抑制するために使用します。有効期限は1分間です.',
				],
				[
					'tagid' => 1,
					'name' => 'AMP_TOKEN',
					'description' =>
						'クライアント ID を AMP クライアント ID サービスから取得するために使用できるトークンが含まれています。他の有効な値によって、オプトアウト、処理中のリクエスト、AMP クライアント ID サービスからのクライアント ID の取得エラーが示されます.',
				],
				[
					'tagid' => 1,
					'name' => '_gac_<property-id>',
					'description' =>
						'ユーザーのキャンペーン関連情報が含まれます。有効期限は90日間です.',
				],
				[
					'tagid' => 2,
					'name' => '_ga',
					'description' =>
						'Google アナリティクス - ユーザーを識別するために使用されます。有効期限は2年間です.',
				],
				[
					'tagid' => 2,
					'name' => '_gid',
					'description' =>
						'Google アナリティクス - ユーザーを識別するために使用されます。有効期限は24時間です.',
				],
				[
					'tagid' => 2,
					'name' => '_ga_<container-id>',
					'description' =>
						'セッション状態を保持するために使用します。有効期限は2年間です.',
				],
				[
					'tagid' => 2,
					'name' => '_gac_gb_<container-id>',
					'description' =>
						'ユーザーのキャンペーン関連情報が含まれます。有効期限は90日間です.',
				],
				[
					'tagid' => 6,
					'name' => '_ttp',
					'description' =>
						'広告キャンペーンのパフォーマンスの測定と向上、そして TikTok での（広告を含む）ユーザーエクスペリエンスのパーソナライズ。有効期限は最後に使用された日付から 13 か月です.',
				],
				[
					'tagid' => 6,
					'name' => '_ttp',
					'description' =>
						'広告キャンペーンのパフォーマンスの測定と向上、そして TikTok での（広告を含む）ユーザーエクスペリエンスのパーソナライズ。有効期限は最後に使用された日付から 13 か月です.',
				],
				[
					'tagid' => 6,
					'name' => '_pangle',
					'description' =>
						'広告キャンペーンのパフォーマンスの測定と向上、そして TikTok での（広告を含む）ユーザーエクスペリエンスのパーソナライズ。有効期限は最後に使用された日付から 13 か月です.',
				],
				[
					'tagid' => 7,
					'name' => 'c_user; xs',
					'description' =>
						'このCookieを使用して、利用者を認証し、利用者が Facebookページ内でページを移動した場合でもログイン状態を維持しています。有効期限は1年間です.',
				],
				[
					'tagid' => 7,
					'name' => 'sb; dbln',
					'description' =>
						'利用者のブラウザを安全に特定するのに役立ちます。有効期限は 2 年間です.',
				],
				[
					'tagid' => 7,
					'name' => 'datr',
					'description' =>
						'利用者のブラウザーに与えられる固有の識別情報であり、特に不正行為から利用者を守るのに役立ちます. 有効期限は 2 年間です.',
				],
				[
					'tagid' => 7,
					'name' => 'csrf',
					'description' =>
						'Meta が利用者のアカウントを安全に維持するのに役立ちます. 有効期限は 1 セッションです.',
				],
				[
					'tagid' => 7,
					'name' => 'fr',
					'description' =>
						'利用者の選択に応じ、広告を配信し、その効果を測定し、広告の関連性を向上させるために使用されます. 有効期限は 90 日間です.',
				],
				[
					'tagid' => 7,
					'name' => '_fbp; _fbc',
					'description' =>
						'広告およびサイト分析サービスを提供する目的で、Meta 製品を利用する事業者のブラウザーを特定します. 有効期限は 5 年間です.',
				],
				[
					'tagid' => 7,
					'name' => 'oo',
					'description' =>
						'利用者の広告表示の設定を保管するのに役立ちます. 有効期限は 5 年間です.',
				],
				[
					'tagid' => 7,
					'name' => 'presence',
					'description' =>
						'Messenger のチャットウィンドウの利用をサポートします. 30 日間です.',
				],
				[
					'tagid' => 7,
					'name' => 'dpr; wd',
					'description' =>
						'これらの Cookie は、利用者が使用するデバイスの画面に最適な表示設定が適用されるのに役立ちます. 有効期限は 7 日間です.',
				],
				[
					'tagid' => 9,
					'name' => '_twclid',
					'description' =>
						'{"en":"The validity period is two years.","ja":"有効期限は2年間です."}',
				],
				[
					'tagid' => 9,
					'name' => 'muc_ads',
					'description' =>
						'{"en":"The validity period is two years.","ja":"有効期限は2年間です."}',
				],
				[
					'tagid' => 9,
					'name' => 'auth_token',
					'description' =>
						'{"en":"The validity period is two years.","ja":"有効期限は2年間です."}',
				],
				[
					'tagid' => 9,
					'name' => 'personalization_id',
					'description' =>
						'{"en":"The validity period is two years.","ja":"有効期限は2年間です."}',
				],
			];
			foreach ($data as $item) {
				$wpdb->insert($table_name, $item); // phpcs:ignore WordPress.DB
			}
		}
	}

	public function initial_data_cookie_opt_cookie_languages()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_cookie_languages';

		$checkExit =
			$wpdb->get_var( // phpcs:ignore WordPress.DB
				$wpdb->prepare('SHOW TABLES LIKE %s', $table_name)
			) == $table_name;

		$check_not_exit_data = $wpdb->get_var("SELECT COUNT(*) FROM {$table_name}"); // phpcs:ignore WordPress.DB

		if ($checkExit && $check_not_exit_data == 0) {
			$data_to_insert = [
				[
					'code' => 'en',
					'name' => 'English',
					'default_language' => true,
					'status' => true,
					'support' => true,
				],
				[
					'code' => 'ab',
					'name' => 'Abkhazian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'aa',
					'name' => 'Afar',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'af',
					'name' => 'Afrikaans',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ak',
					'name' => 'Akan',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'sq',
					'name' => 'Albanian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'am',
					'name' => 'Amharic',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ar',
					'name' => 'Arabic',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'hy',
					'name' => 'Armenian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'as',
					'name' => 'Assamese',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'av',
					'name' => 'Avar',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ae',
					'name' => 'Avestan',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ay',
					'name' => 'Aymara',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'az',
					'name' => 'Azerbaijani',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'bm',
					'name' => 'Bambara',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ba',
					'name' => 'Bashkir',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'eu',
					'name' => 'Basque',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'be',
					'name' => 'Belarusian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'bn',
					'name' => 'Bengali',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'bh',
					'name' => 'Bhutani',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'bi',
					'name' => 'Bislama',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'bs',
					'name' => 'Bosnian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'br',
					'name' => 'Breton',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'bg',
					'name' => 'Bulgarian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'my',
					'name' => 'Burmese',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'km',
					'name' => 'Cambodian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ca',
					'name' => 'Catalan',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ch',
					'name' => 'Chamorro',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ce',
					'name' => 'Chechen',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ny',
					'name' => 'Chichewa',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'zh-hans',
					'name' => 'Chinese (Simplified)',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'zh-hant',
					'name' => 'Chinese (Traditional)',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'cv',
					'name' => 'Chuvash',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'kw',
					'name' => 'Cornish',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'co',
					'name' => 'Corsican',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'cr',
					'name' => 'Cree',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'hr',
					'name' => 'Croatian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'cs',
					'name' => 'Czech',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'da',
					'name' => 'Danish',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'eo',
					'name' => 'Esperanto',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'et',
					'name' => 'Estonian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ee',
					'name' => 'Ewe',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'fo',
					'name' => 'Faeroese',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'fj',
					'name' => 'Fiji',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'fi',
					'name' => 'Finnish',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'fr',
					'name' => 'French',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'fy',
					'name' => 'Frisian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ff',
					'name' => 'Fulah',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'gl',
					'name' => 'Galician',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ka',
					'name' => 'Georgian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'de',
					'name' => 'German',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'el',
					'name' => 'Greek',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'kl',
					'name' => 'Greenlandic',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'gn',
					'name' => 'Guarani',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'gu',
					'name' => 'Gujarati',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ha',
					'name' => 'Hausa',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'he',
					'name' => 'Hebrew',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'hz',
					'name' => 'Herero',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'hi',
					'name' => 'Hindi',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ho',
					'name' => 'Hiri Motu',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'hu',
					'name' => 'Hungarian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'is',
					'name' => 'Icelandic',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ig',
					'name' => 'Igbo',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'id',
					'name' => 'Indonesian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ia',
					'name' => 'Interlingua',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ie',
					'name' => 'Interlingue',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'iu',
					'name' => 'Inuktitut',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ik',
					'name' => 'Inupiak',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ga',
					'name' => 'Irish',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'it',
					'name' => 'Italian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ja',
					'name' => 'Japanese',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'jv',
					'name' => 'Javanese',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'kn',
					'name' => 'Kannada',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'kr',
					'name' => 'Kanuri',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ks',
					'name' => 'Kashmiri',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'kk',
					'name' => 'Kazakh',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ki',
					'name' => 'Kikuyu',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'rw',
					'name' => 'Kinyarwanda',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ky',
					'name' => 'Kirghiz',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'rn',
					'name' => 'Kirundi',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'kv',
					'name' => 'Komi',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'kg',
					'name' => 'Kongo',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ko',
					'name' => 'Korean',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ku',
					'name' => 'Kurdish',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'kj',
					'name' => 'Kwanyama',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'lo',
					'name' => 'Laothian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'lv',
					'name' => 'Latvian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ln',
					'name' => 'Lingala',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'lt',
					'name' => 'Lithuanian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'lg',
					'name' => 'Luganda',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'lb',
					'name' => 'Luxembourgish',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'mk',
					'name' => 'Macedonian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'mg',
					'name' => 'Malagasy',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ms',
					'name' => 'Malay',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ml',
					'name' => 'Malayalam',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'dv',
					'name' => 'Maldivian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'mt',
					'name' => 'Maltese',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'gv',
					'name' => 'Manx',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'mi',
					'name' => 'Maori',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'mr',
					'name' => 'Marathi',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'mh',
					'name' => 'Marshallese',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'mo',
					'name' => 'Moldavian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'mn',
					'name' => 'Mongolian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'na',
					'name' => 'Nauru',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'nv',
					'name' => 'Navajo',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ng',
					'name' => 'Ndonga',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ne',
					'name' => 'Nepali',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'nd',
					'name' => 'North Ndebele',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'se',
					'name' => 'Northern Sami',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'nl',
					'name' => 'Dutch',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'no',
					'name' => 'Norwegian Bokmål',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'nn',
					'name' => 'Norwegian Nynorsk',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'oc',
					'name' => 'Occitan',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'cu',
					'name' => 'Old Slavonic',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'or',
					'name' => 'Oriya',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'om',
					'name' => 'Oromo',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'os',
					'name' => 'Ossetian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'pi',
					'name' => 'Pali',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ps',
					'name' => 'Pashto',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'fa',
					'name' => 'Persian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'pl',
					'name' => 'Polish',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'pt-br',
					'name' => 'Portuguese, Brazil',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'pt',
					'name' => 'Portuguese, Portugal',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'pa',
					'name' => 'Punjabi',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'qu',
					'name' => 'Quechua',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'rm',
					'name' => 'Rhaeto-Romance',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ro',
					'name' => 'Romanian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ru',
					'name' => 'Russian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'sm',
					'name' => 'Samoan',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'sg',
					'name' => 'Sangho',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'sa',
					'name' => 'Sanskrit',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'sc',
					'name' => 'Sardinian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'sr',
					'name' => 'Serbian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'sn',
					'name' => 'Shona',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'sd',
					'name' => 'Sindhi',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'si',
					'name' => 'Sinhalese',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'sk',
					'name' => 'Slovak',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'sl',
					'name' => 'Slovenian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'so',
					'name' => 'Somali',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'st',
					'name' => 'Southern Sotho',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'es',
					'name' => 'Spanish',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'su',
					'name' => 'Sundanese',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'sw',
					'name' => 'Swahili',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'sv',
					'name' => 'Swedish',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'tl',
					'name' => 'Tagalog',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'tg',
					'name' => 'Tajik',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ta',
					'name' => 'Tamil',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'tt',
					'name' => 'Tatar',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'te',
					'name' => 'Telugu',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'th',
					'name' => 'Thai',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'bo',
					'name' => 'Tibetan',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ti',
					'name' => 'Tigrinya',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'to',
					'name' => 'Tonga',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ts',
					'name' => 'Tsonga',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'tn',
					'name' => 'Tswana',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'tr',
					'name' => 'Turkish',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'tk',
					'name' => 'Turkmen',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'tw',
					'name' => 'Twi',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ug',
					'name' => 'Uighur',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'uk',
					'name' => 'Ukrainian',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'ur',
					'name' => 'Urdu',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'uz',
					'name' => 'Uzbek',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 've',
					'name' => 'Venda',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'vi',
					'name' => 'Vietnamese',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'vo',
					'name' => 'Volapük',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'wa',
					'name' => 'Walloon',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'cy',
					'name' => 'Welsh',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'wo',
					'name' => 'Wolof',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'xh',
					'name' => 'Xhosa',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'yi',
					'name' => 'Yiddish',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'yo',
					'name' => 'Yoruba',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'za',
					'name' => 'Zhuang',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
				[
					'code' => 'zu',
					'name' => 'Zulu',
					'default_language' => false,
					'status' => false,
					'support' => false,
				],
			];

			foreach ($data_to_insert as $data) {
				$wpdb->insert($table_name, $data); // phpcs:ignore WordPress.DB
			}
		}
	}

	public function initial_data_cookie_opt_banner()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_banner';

		$checkExit =
			$wpdb->get_var( // phpcs:ignore WordPress.DB
				$wpdb->prepare('SHOW TABLES LIKE %s', $table_name)
			) == $table_name;

		$check_not_exit_data = $wpdb->get_var("SELECT COUNT(*) FROM {$table_name}"); // phpcs:ignore WordPress.DB

		if ($checkExit && $check_not_exit_data == 0) {
			$data = [
				[
					'regulation' => 'eu',
					'default_language' => 'ja',
					'status' => 0,
					'setting' => wp_json_encode([
						'position' => 'box-bottom-right',
						'animation' => 'fade',
						'reloading' => 0,
						'onClick' => 1,
						'onScroll' => [
							'status' => 0,
							'value' => '100',
						],
						'colors' => [
							'text-color' => '#0a0a0a',
							'button-color' => '#dbdbdb',
							'bar-color' => '#fff',
							'bar-opacity' => '100',
						],
						'buttons' => [
							'accept_button' => 1,
							'reject_button' => 1,
							'privacy_policy_button' => 1,
							'customize_button' => 1,
						],
						'customize' => [
							'necessaryCookies' => 1,
							'performanceCookies' => 1,
							'functionalityCookies' => 1,
							'socialMediaCookies' => 1,
						],
						'privacy_policy' => [
							'link_type' => 'page',
							'link' => get_permalink(get_option('wp_page_for_privacy_policy')),
							'link_target' => '_blank',
						],
						'conditional' => [
							'status' => 0,
							'rules' => [
								'show' => [],
								'hide' => [],
							],
						],
						'acceptedExpiry' => 'month',
						'rejectedExpiry' => 'year',
						'deactivation' => 1,
					]),
					'contents' => wp_json_encode([
						'en' => [
							'notice' => [
								'title' => 'This site uses cookies.',
								'description' =>
									'This site uses cookies to ensure comfortable browsing. If you agree to the cookie specifications, please click "Agree All". If you want to set each cookie, please check "Cookie Settings" and set it.',
								'buttons' => [
									'accept_button' => 'Accept All',
									'reject_button' => 'Reject All',
									'customize_button' => 'Customize',
									'privacy_policy_button' => 'Privacy Policy',
									'do_not_sell_page_button' => '',
									'cookie_policy_button' => '',
								],
							],
							'customize' => [
								'title' => ' Customize',
								'description' =>
									'For more information on cookies, please click ',
								'always_active' => 'Always Active',
								'here' => 'here.',
								'button_save' => 'Save Change',
							],
						],
						'ja' => [
							'notice' => [
								'title' => 'このサイトではCookieを利用しています。',
								'description' =>
									'当該サイトでは快適な閲覧のためにCookieを使用しています。Cookieの仕様に同意いただける場合、「すべて同意する」をクリックしてください。それぞれのCookieに対して設定を行う場合は、「Cookie設定」を確認頂き、設定をお願いします。',
								'buttons' => [
									'accept_button' => 'すべて同意する',
									'reject_button' => 'すべて拒否する',
									'customize_button' => 'カスタマイズ',
									'privacy_policy_button' => 'プライバシー',
									'do_not_sell_page_button' => '',
									'cookie_policy_button' => '',
								],
							],
							'customize' => [
								'title' => ' カスタマイズ',
								'description' =>
									'Cookie について詳しくは、ここをクリックしてください',
								'always_active' => '常にアクティブ',
								'here' => 'ここ。',
								'button_save' => '変更を保存する',
							],
						],
					]),
				],
				[
					'regulation' => 'us',
					'default_language' => 'ja',
					'status' => 0,
					'setting' => wp_json_encode([
						'position' => 'box-bottom-right',
						'animation' => 'fade',
						'reloading' => 0,
						'onClick' => 1,
						'onScroll' => [
							'status' => 0,
							'value' => '100',
						],
						'colors' => [
							'text-color' => '#0a0a0a',
							'button-color' => '#dbdbdb',
							'bar-color' => '#fff',
							'bar-opacity' => '100',
						],
						'buttons' => [
							'accept_button' => 1,
							'reject_button' => 1,
							'privacy_policy_button' => 1,
							'customize_button' => 1,
							'do_not_sell_page_button' => 1,
						],
						'customize' => [
							'necessaryCookies' => 1,
							'performanceCookies' => 1,
							'functionalityCookies' => 1,
							'socialMediaCookies' => 1,
						],
						'privacy_policy' => [
							'link_type' => 'page',
							'link' => get_permalink(get_option('wp_page_for_privacy_policy')),
							'link_target' => '_blank',
							'linkPosition' => 'banner',
						],
						'conditional' => [
							'status' => 0,
							'rules' => [
								'show' => [],
								'hide' => [],
							],
						],
						'acceptedExpiry' => 'month',
						'rejectedExpiry' => 'year',
						'deactivation' => 1,
					]),
					'contents' => wp_json_encode([
						'en' => [
							'notice' => [
								'title' => 'This site uses cookies.',
								'description' =>
									'This site uses cookies to ensure comfortable browsing. If you agree to the cookie specifications, please click "Agree All". If you want to set each cookie, please check "Cookie Settings" and set it.',
								'buttons' => [
									'accept_button' => 'Accept All',
									'reject_button' => 'Reject All',
									'customize_button' => 'Customize',
									'privacy_policy_button' => 'Privacy Policy',
									'do_not_sell_page_button' =>
										'Do Not Sell Personal Infomation',
									'cookie_policy_button' => '',
								],
							],
							'customize' => [
								'title' => ' Customize',
								'description' =>
									'For more information on cookies, please click ',
								'always_active' => 'Always Active',
								'here' => 'here.',
								'button_save' => 'Save Change',
							],
						],
						'ja' => [
							'notice' => [
								'title' => 'このサイトではCookieを利用しています。',
								'description' =>
									'当該サイトでは快適な閲覧のためにCookieを使用しています。Cookieの仕様に同意いただける場合、「すべて同意する」をクリックしてください。それぞれのCookieに対して設定を行う場合は、「Cookie設定」を確認頂き、設定をお願いします。',
								'buttons' => [
									'accept_button' => 'すべて同意する',
									'reject_button' => 'すべて拒否する',
									'customize_button' => 'カスタマイズ',
									'privacy_policy_button' => 'プライバシー',
									'do_not_sell_page_button' => '個人情報を販売しないでください',
									'cookie_policy_button' => '',
								],
							],
							'customize' => [
								'title' => ' カスタマイズ',
								'description' =>
									'Cookie について詳しくは、ここをクリックしてください',
								'always_active' => '常にアクティブ',
								'here' => 'ここ。',
								'button_save' => '変更を保存する',
							],
						],
					]),
				],
				[
					'regulation' => 'ja',
					'default_language' => 'ja',
					'status' => 1,
					'setting' => wp_json_encode([
						'position' => 'box-bottom-right',
						'animation' => 'fade',
						'reloading' => 0,
						'onClick' => 1,
						'onScroll' => [
							'status' => 0,
							'value' => '100',
						],
						'colors' => [
							'text-color' => '#0a0a0a',
							'button-color' => '#dbdbdb',
							'bar-color' => '#fff',
							'bar-opacity' => '100',
						],
						'buttons' => [
							'accept_button' => 1,
							'cookie_policy_button' => 1,
							'privacy_policy_button' => 0,
						],
						'privacy_policy' => [
							'link_type' => 'page',
							'link' => get_permalink(get_option('wp_page_for_privacy_policy')),
							'link_target' => '_blank',
							'linkPosition' => 'banner',
						],
						'conditional' => [
							'status' => 0,
							'rules' => [
								'show' => [],
								'hide' => [],
							],
						],
						'acceptedExpiry' => 'month',
						'rejectedExpiry' => 'year',
						'deactivation' => 1,
					]),
					'contents' => wp_json_encode([
						'en' => [
							'notice' => [
								'title' => 'This site uses cookies.',
								'description' =>
									'This site uses cookies to ensure a comfortable browsing experience. If you would like to check the details of cookies, please click "Cookie Policy" and confirm. If you would like to view the site, please click "Confirm".',
								'buttons' => [
									'accept_button' => 'Confirmation',
									'reject_button' => '',
									'customize_button' => '',
									'privacy_policy_button' => 'Privacy Policy',
									'do_not_sell_page_button' => '',
									'cookie_policy_button' => 'Cookie Policy',
								],
							],
							'customize' => [
								'title' => ' ',
								'description' => '',
								'always_active' => '',
								'here' => '',
								'button_save' => '',
							],
						],
						'ja' => [
							'notice' => [
								'title' => 'このサイトではCookieを利用しています。',
								'description' =>
									'当該サイトでは快適な閲覧のためにCookieを使用しています。Cookieの詳細を確認する場合は、「Cookieポリシー」をclickし、確認をお願いします。サイト閲覧をしたい方は、「確認」をclickしてください。',
								'buttons' => [
									'accept_button' => '確認',
									'reject_button' => '',
									'customize_button' => '',
									'privacy_policy_button' => 'プライバシーポリシー',
									'do_not_sell_page_button' => '',
									'cookie_policy_button' => 'クッキーポリシー',
								],
							],
							'customize' => [
								'title' => ' ',
								'description' => '',
								'always_active' => '',
								'here' => '',
								'button_save' => '',
							],
						],
					]),
				],
			];
			foreach ($data as $item) {
				$wpdb->insert($table_name, $item); // phpcs:ignore WordPress.DB
			}
		}
	}

	public function initial_data_options()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'options';

		$checkExit =
			// phpcs:ignore WordPress.DB
			$wpdb->get_var($wpdb->prepare('SHOW TABLES LIKE %s', $table_name)) ==
			$table_name;

		$check_not_exit_data = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM {$table_name} WHERE option_name LIKE %s", 'cookie_plugin_cookie_policy')); // phpcs:ignore WordPress.DB

		if ($checkExit && $check_not_exit_data == 0) {
			$data = [
				[
					'option_name' => 'cookie_plugin_cookie_policy',
					'autoload' => 'no',
				],
				// [
				//     'option_name' => 'cookie_opt_version',
				//     'option_value' => '1.0.0',
				//     'autoload' => 'no'
				// ],
				// [
				//     'option_name' => 'cookie_opt_id',
				//     'autoload' => 'no'
				// ],
				[
					'option_name' => 'cookie_opt_active',
					'autoload' => 'no',
				],
				[
					'option_name' => 'cookie_opt_linkage',
					'autoload' => 'no',
				],
				[
					'option_name' => 'cookie_opt_do_not_sell_page',
					'autoload' => 'no',
				],
				[
					'option_name' => 'cookie_opt_cookie_permission',
					'autoload' => 'no',
				],
				// [
				// 	'option_name' => 'cookie_opt_banner_active',
				// 	'option_value' => false,
				// 	'autoload' => 'no',
				// ],
			];
			foreach ($data as $key => $value) {
				$wpdb->insert($table_name, $value); // phpcs:ignore WordPress.DB
			}
			add_option('cookie_opt_banner_active', -1);
			add_option('cookie_opt_first_setting', 0);
		}
	}

	public function drop_data_wp_options()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'options';
		$option_names = [
			'cookie_plugin_cookie_policy',
			'cookie_opt_version',
			'cookie_opt_id',
			'cookie_opt_active',
			'cookie_opt_linkage',
			'cookie_opt_do_not_sell_page',
			'cookie_opt_cookie_permission',
			'cookie_opt_banner_active',
			'cookie_opt_first_setting',
			'cookie_opt_statistics'
		];
		//Delete Page Policy + Do not sell page
		$policy_page_id = get_option('wp_page_for_privacy_policy');
		$do_not_sell_page_id = get_option('cookie_opt_do_not_sell_page');
		if (!empty($policy_page_id)) {
			wp_delete_post($policy_page_id, true);
		}
		if (!empty($do_not_sell_page_id)) {
			wp_delete_post($do_not_sell_page_id, true);
		}

		// Delete option value
		foreach ($option_names as $option_name) {
			$checkData = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE option_name LIKE %s", $option_name), ARRAY_A); // phpcs:ignore WordPress.DB

			if (count($checkData) > 0) {
				foreach ($checkData as $value) {
					$wpdb->delete($table_name, ['option_id' => $value['option_id']]); // phpcs:ignore WordPress.DB
				}
			}
		}
	}

	public function create_table_cookie_opt_statistics()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_statistics';
		$charset_collate = $wpdb->get_charset_collate();

		// phpcs:ignore WordPress.DB
		$table_result = $wpdb->get_var(
			$wpdb->prepare('SHOW TABLES LIKE %s', $table_name)
		);

		if ($table_result != $table_name) {
			$sql = "CREATE TABLE $table_name (
                id INT PRIMARY KEY NOT NULL AUTO_INCREMENT,
                type INT NOT NULL,
                time DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
                date DATETIME NULL
            )$charset_collate;";
			require_once ABSPATH . 'wp-admin/includes/upgrade.php';
			dbDelta($sql);
		}
	}
}
