<?php

namespace App\Validates;

use WP_Error;

class TagManagementRequest
{
	public static function validateCreate($data)
	{
		$errors = new WP_Error();
		$name = isset($data['name']) ? sanitize_text_field($data['name']) : '';
		$position = isset($data['position']) ? intval($data['position']) : '';
		$installation_page = isset($data['installation_page'])
			? $data['installation_page']
			: '';
		$tag = isset($data['tag']) ? $data['tag'] : '';
		$tag_id = isset($data['tag_id'])
			? sanitize_text_field($data['tag_id'])
			: '';
		if (empty($installation_page)) {
			$errors->add(
				'installation_page',
				esc_html__('installation_page is not empty ', 'cookie-opt')
			);
		}
		if (!is_array($installation_page)) {
			$errors->add(
				'installation_page',
				esc_html__('installation_page must be an array', 'cookie-opt')
			);
		}

		if (empty($tag)) {
			$errors->add('tag', 'Tag is not empty.');
		}

		if ($tag_id !== 'null') {
			if (!in_array($tag_id, self::ruleCheckExist())) {
				$errors->add(
					'tag_id',
					esc_html__('Tag ID does not exist in the system.', 'cookie-opt')
				);
			}
		} else {
			if (empty($name) || strlen($name) > 255) {
				$errors->add(
					'name',
					esc_html__(
						'Name is not empty and should not exceed 255 characters.',
						'cookie-opt'
					)
				);
			}

			if ($position !== 0 && $position !== 1) {
				$errors->add(
					'position',
					esc_html__('Position must be <head> or <body>', 'cookie-opt')
				);
			}
		}
		return $errors;
	}

	public static function ruleCheckExist()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_tag_info';

		$query = "SELECT tagid FROM {$table_name}";
		$results = $wpdb->get_results("SELECT tagid FROM {$table_name}"); // phpcs:ignore WordPress.DB
		$id_array = wp_list_pluck($results, 'tagid');

		return $id_array;
	}

	public static function ruleCheckExistTag($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_tag_management';
		$result = $wpdb->get_row($wpdb->prepare("SELECT id FROM {$table_name} WHERE id = %s", sanitize_text_field($id))); // phpcs:ignore WordPress.DB
		return $result;
	}

	public static function validateUpdate($data, $id)
	{
		$result = self::ruleCheckExistTag($id);
		if (empty($result)) {
			wp_redirect(admin_url('admin.php?page=cookie_opt'));
			exit();
		}
		return self::validateCreate($data);
	}
}
