<?php

namespace App\Validates;

use WP_Error;

class PublishSettingsRequest
{
	public static function publishSettingsError($data)
	{
		$errors = new WP_Error();
		if (!isset($data['cookie_opt_id'])) {
			$errors->add('publish_settings', esc_html__('Error', 'cookie-opt'));
			return $errors;
		}
		if (empty($data['cookie_opt_id'])) {
			$errors->add(
				'publish_settings',
				esc_html__('ID is not empty', 'cookie-opt')
			);
		}
		return $errors;
	}
}
