<?php

namespace App\Validates;

use WP_Error;

class PolicyRequestListRequest
{
	public static function validateListAdd($data)
	{
		$errors = new WP_Error();
		if (!isset($data['name'])) {
			$errors->add('name', esc_html__('Name does not exist', 'cookie-opt'));
			return $errors;
		}
		if (!isset($data['publisher'])) {
			$errors->add('publisher', esc_html__('Publisher does not exist', 'cookie-opt'));
			return $errors;
		}
		if (!isset($data['description'])) {
			$errors->add(
				'description',
				esc_html__('Description does not exist', 'cookie-opt')
			);
			return $errors;
		}
		$name = sanitize_text_field($data['name']);
		$description = sanitize_text_field($data['description']);
		$category_id = sanitize_text_field($data['category_id']);
		$publisher = sanitize_text_field($data['publisher']);

		if (empty($name)) {
			$errors->add('name', esc_html__('Name is not empty', 'cookie-opt'));
		}
		if (empty($publisher)) {
			$errors->add('publisher', esc_html__('Publisher is not empty', 'cookie-opt'));
		}
		if (empty($category_id)) {
			$errors->add(
				'category_id',
				esc_html__('Category is not empty', 'cookie-opt')
			);
		}
		if ($category_id != intval($category_id)) {
			$errors->add('category_id', esc_html__('Invalid Category', 'cookie-opt'));
		}
		if (self::ruleCheckExist($category_id)) {
			$errors->add(
				'category_id',
				esc_html__('Category does not exist in the system', 'cookie-opt')
			);
		}
		if (empty($description)) {
			$errors->add(
				'description',
				esc_html__('Description is not empty', 'cookie-opt')
			);
		}
		if (strlen($description) > 255) {
			$errors->add(
				'description',
				esc_html__('Description not exceed 255 characters', 'cookie-opt')
			);
		}
		return $errors;
	}
	public static function ruleCheckExist($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'cookie_opt_cookie_category';

		$result = $wpdb->get_row($wpdb->prepare("SELECT id FROM {$table_name} WHERE id = %d", absint($id))); // phpcs:ignore WordPress.DB
		return is_null($result);
	}
}
