<?php

namespace App\Validates;

use WP_Error;

class PolicyRequestCategoryRequest
{
	public static function validateCategoryEdit($data)
	{
		$errors = new WP_Error();
		if (!isset($data['name'])) {
			$errors->add('name', esc_html__('Name does not exist', 'cookie-opt'));
			return $errors;
		}
		if (!isset($data['description'])) {
			$errors->add(
				'description',
				esc_html__('Description does not exist', 'cookie-opt')
			);
			return $errors;
		}
		if (count($data['name']) === 0 || !is_array($data['name'])) {
			$errors->add('name', esc_html__('Name does not exist', 'cookie-opt'));
			return $errors;
		}
		if (count($data['description']) === 0 || !is_array($data['description'])) {
			$errors->add(
				'description',
				esc_html__('Description does not exist', 'cookie-opt')
			);
			return $errors;
		}
		foreach ($data['name'] as $key => $value) {
			$name = sanitize_text_field($value);
			if (empty($name)) {
				$errors->add('name', esc_html__('Name is not empty', 'cookie-opt'));
			}
		}
		foreach ($data['description'] as $key => $value) {
			$description = sanitize_text_field($value);
			if (empty($description)) {
				$errors->add(
					'description',
					esc_html__('Description is not empty', 'cookie-opt')
				);
			}
		}
		return $errors;
	}
}
