<?php

namespace App\Validates;

use WP_Error;

class PermissionRequest
{
	const POSITION_LIST = [
		'box-bottom-left',
		'box-bottom-right',
		'box-top-left',
		'box-top-right',
		'classic-bottom',
		'classic-top',
		'banner-bottom',
		'banner-top',
		'popup'
	];
	const ANIMATION_LIST = [
		'none',
		'fade',
		'slide'
	];
	const ANIMATION_SLIDE_VALUE = [
		'slide-right-to-left',
		'slide-left-to-right',
		'slide-top-to-bottom',
		'slide-bottom-to-top',
	];

	/**
	 * Validate for Setting Tab
	 * @return WP_Error
	 */
	public static function settingPageRequest()
	{
		$errors = new WP_Error();

		// echo "<pre>";
		// print_r($_POST);
		// die;

		$regulation = isset($_POST['coop-setting__regulation']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__regulation'])) : null; //phpcs:ignore WordPress.Security

		if (empty($regulation)) {
			$errors->add('regulation', 'Regulation is not empty');
			return $errors;
		}

		$title = isset($_POST['coop-setting__title']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__title'])) : null; //phpcs:ignore WordPress.Security
		$description = isset($_POST['coop-setting__description']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__description'])) : null; //phpcs:ignore WordPress.Security
		$accept_button = isset($_POST['coop-setting__accept-btn']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__accept-btn'])) : null; //phpcs:ignore WordPress.Security

		$reject_status = isset($_POST['coop-setting__reject-status']) ? 1 : 0; //phpcs:ignore WordPress.Security
		$_POST['coop-setting__reject-status'] = $reject_status;
		$reject_btn = isset($_POST['coop-setting__reject-btn']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__reject-btn'])) : null; //phpcs:ignore WordPress.Security

		$cookie_policy_btn = isset($_POST['coop-setting__cookie-policy-btn']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__cookie-policy-btn'])) : null; //phpcs:ignore WordPress.Security

		$pri_policy_status = isset($_POST['coop-setting__pri-policy-status']) ? 1 : 0; //phpcs:ignore WordPress.Security
		$_POST['coop-setting__pri-policy-status'] = $pri_policy_status;
		$pri_policy_btn = isset($_POST['coop-setting__pri-policy-btn']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__pri-policy-btn'])) : null; //phpcs:ignore WordPress.Security
		$pri_policy_page_id = isset($_POST['coop-setting__pri-policy-page-id']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__pri-policy-page-id'])) : null; //phpcs:ignore WordPress.Security
		$pri_policy_target = isset($_POST['coop-setting__pri-policy-target']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__pri-policy-target'])) : null; //phpcs:ignore WordPress.Security

		$customize_status = isset($_POST['coop-setting__cus-status']) ? 1 : 0; //phpcs:ignore WordPress.Security
		$_POST['coop-setting__cus-status'] = $customize_status;
		$customize_btn = isset($_POST['coop-setting__cus-btn']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__cus-btn'])) : null; //phpcs:ignore WordPress.Security
		$customize_title = isset($_POST['coop-setting__cus-title']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__cus-title'])) : null; //phpcs:ignore WordPress.Security
		$customize_des = isset($_POST['coop-setting__cus-des']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__cus-des'])) : null; //phpcs:ignore WordPress.Security
		$customize_save_btn = isset($_POST['coop-setting__cus-save-btn']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__cus-save-btn'])) : null; //phpcs:ignore WordPress.Security

		$term_of_use_status = isset($_POST['coop-setting__term-of-use-status']) ? 1 : 0; //phpcs:ignore WordPress.Security
		$_POST['coop-setting__term-of-use-status'] = $term_of_use_status; //phpcs:ignore WordPress.Security
		$term_of_use_btn = isset($_POST['coop-setting__term-of-use-btn']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__term-of-use-btn'])) : null; //phpcs:ignore WordPress.Security

		$expired = isset($_POST['coop-setting__expired']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__expired'])) : null; //phpcs:ignore WordPress.Security

		$on_scroll_status = isset($_POST['coop-setting__onscroll-status']) ? 1 : 0; //phpcs:ignore WordPress.Security
		$_POST['coop-setting__onscroll-status'] = $on_scroll_status;
		$on_scroll_value = isset($_POST['coop-setting__onscroll-value']) ? sanitize_text_field(wp_unslash($_POST['coop-setting__onscroll-value'])) : null; //phpcs:ignore WordPress.Security

		$on_click = isset($_POST['coop-setting__on-click']) ? 1 : 0; //phpcs:ignore WordPress.Security
		$_POST['coop-setting__on-click'] = $on_click;

		$conditional_status = isset($_POST['coop-setting__conditional-status']) ? 1 : 0; //phpcs:ignore WordPress.Security
		$_POST['coop-setting__conditional-status'] = $conditional_status;

		if (empty($title)) {
			$errors->add(
				'title',
				esc_html__('Title is not empty', 'cookie-opt')
			);
		}
		if (empty($description)) {
			$errors->add(
				'description',
				esc_html__('Description is not empty', 'cookie-opt'),
				$regulation
			);
		}
		if (empty($accept_button)) {
			$errors->add(
				'accept_btn',
				esc_html__('Accept Button is not empty', 'cookie-opt'),
				$regulation
			);
		}

		if ($pri_policy_status == 1) {
			if (empty($pri_policy_btn)) {
				$errors->add(
					'pri_policy_btn',
					esc_html__('Privacy Policy Button is not empty', 'cookie-opt'),
					$regulation
				);
			}
		}

		if ($on_scroll_status == 1) {
			if (empty($on_scroll_value)) {
				$errors->add(
					'onscroll_value',
					esc_html__('Onscroll Value is not empty', 'cookie-opt'),
					$regulation
				);
			}
		}

		if ($regulation == 'ja') {
			if (empty($cookie_policy_btn)) {
				$errors->add(
					'cookie_policy_btn',
					esc_html__('Cookie Policy Button is not empty', 'cookie-opt'),
					$regulation
				);
			}
		}

		if ($regulation == 'eu' || $regulation == 'us') {
			if ($reject_status == 1) {
				if (empty($reject_btn)) {
					$errors->add(
						'reject_btn',
						esc_html__('Reject Button is not empty', 'cookie-opt'),
						$regulation
					);
				}
			}
			if ($customize_status == 1) {
				if (empty($customize_btn)) {
					$errors->add(
						'customize_btn',
						esc_html__('Customize Button is not empty', 'cookie-opt'),
						$regulation
					);
				}
				if (empty($customize_title)) {
					$errors->add(
						'customize_title',
						esc_html__('Customize Title is not empty', 'cookie-opt'),
						$regulation
					);
				}
				if (empty($customize_des)) {
					$errors->add(
						'customize_des',
						esc_html__('Customize Description is not empty', 'cookie-opt'),
						$regulation
					);
				}
				if (empty($customize_save_btn)) {
					$errors->add(
						'customize_save_btn',
						esc_html__('Save Button is not empty', 'cookie-opt'),
						$regulation
					);
				}
			}

			if (empty($expired)) {
				$errors->add(
					'expired',
					esc_html__('Expired is not empty', 'cookie-opt'),
					$regulation
				);
			}
		}

		if ($regulation == 'us') {
			if ($term_of_use_status == 1) {
				if (empty($term_of_use_btn)) {
					$errors->add(
						'term_of_use_btn',
						esc_html__('Term of use button is not empty', 'cookie-opt'),
						$regulation
					);
				}
			}
		}

		return $errors;
	}

	/**
	 * Validate for Startup Tab
	 * @return WP_Error
	 */
	public static function startupPageRequest()
	{
		$errors = new WP_Error();

		// echo "<pre>";
		// print_r($_POST);
		// die;

		$position = isset($_POST['coop-start__position']) ? sanitize_text_field(wp_unslash($_POST['coop-start__position'])) : null; //phpcs:ignore WordPress.Security
		$animation = isset($_POST['coop-start__animation']) ? sanitize_text_field(wp_unslash($_POST['coop-start__animation'])) : null; //phpcs:ignore WordPress.Security
		$animation_slide_value = isset($_POST['coop-start__animation__slide']) ? sanitize_text_field(wp_unslash($_POST['coop-start__animation__slide'])) : null;  //phpcs:ignore WordPress.Security
		$text_color = isset($_POST['coop-start__text-color']) ? sanitize_hex_color(wp_unslash($_POST['coop-start__text-color'])) : null; //phpcs:ignore WordPress.Security
		$btn_color = isset($_POST['coop-start__btn-color']) ? sanitize_hex_color(wp_unslash($_POST['coop-start__btn-color'])) : null; //phpcs:ignore WordPress.Security
		$bar_color = isset($_POST['coop-start__bar-color']) ? sanitize_hex_color(wp_unslash($_POST['coop-start__bar-color'])) : null; //phpcs:ignore WordPress.Security
		$bar_opacity = isset($_POST['coop-start__bar-opacity']) ? sanitize_text_field(wp_unslash($_POST['coop-start__bar-opacity'])) : null; //phpcs:ignore WordPress.Security

		// For position 
		if (empty($animation)) {
			$errors->add(
				'position',
				esc_html__('Position must exist', 'cookie-opt')
			);
		}
		if (!in_array($position, self::POSITION_LIST)) {
			$errors->add(
				'position',
				esc_html__('Position is invalid', 'cookie-opt')
			);
		}

		//For animation
		if (empty($animation)) {
			$errors->add(
				'animation',
				esc_html__('Animation must exist', 'cookie-opt')
			);
		}
		if (!in_array($animation, self::ANIMATION_LIST)) {
			$errors->add(
				'animation',
				esc_html__('Animation is invalid', 'cookie-opt')
			);
		}
		if (!empty($animation) && $animation == 'slide') {
			if (empty($animation_slide_value)) {
				$errors->add(
					'animation',
					esc_html__('Animation slide value must exist', 'cookie-opt')
				);
			} elseif (!in_array($animation_slide_value, self::ANIMATION_SLIDE_VALUE)) {
				$errors->add(
					'animation',
					esc_html__('Animation slide value is invalid', 'cookie-opt')
				);
			} else {
				$_POST['coop-start__animation'] = $animation_slide_value;
			}
		}

		// For Text color
		if (empty($text_color)) {
			$errors->add(
				'text_color',
				esc_html__('Text color is not empty', 'cookie-opt')
			);
		}
		if (!preg_match('/^#(?:[0-9a-fA-F]{3}){1,2}$/', $text_color)) {
			$errors->add(
				'text_color',
				esc_html__('Text color is invalid', 'cookie-opt')
			);
		}

		// For Button color
		if (empty($btn_color)) {
			$errors->add(
				'btn_color',
				esc_html__('Button color is not empty', 'cookie-opt')
			);
		}
		if (!preg_match('/^#(?:[0-9a-fA-F]{3}){1,2}$/', $btn_color)) {
			$errors->add(
				'btn_color',
				esc_html__('Button color is invalid', 'cookie-opt')
			);
		}

		// For Bar color
		if (empty($bar_color)) {
			$errors->add(
				'bar_color',
				esc_html__('Bar color is not empty', 'cookie-opt')
			);
		}
		if (!preg_match('/^#(?:[0-9a-fA-F]{3}){1,2}$/', $bar_color)) {
			$errors->add(
				'bar_color',
				esc_html__('Bar color is invalid', 'cookie-opt')
			);
		}

		if (empty($bar_opacity)) {
			$errors->add(
				'bar_opacity',
				esc_html__('Bar opacity is not empty', 'cookie-opt')
			);
		}
		if (is_numeric($bar_opacity)) {
			if ($bar_opacity < 50 || $bar_opacity > 100) {
				$errors->add(
					'bar_opacity',
					esc_html__('The value of opacity must be >= 50 or <= 100', 'cookie-opt')
				);
			}
		} else {
			$errors->add(
				'bar_opacity',
				esc_html__('Bar opacity is numeric', 'cookie-opt')
			);
		}

		return $errors;
	}

	/**
	 * Validate for Banner layout Tab
	 * @return WP_Error
	 */
	public static function layoutPageRequest(){
		$errors = new WP_Error();

		// echo "<pre>";
		// print_r($_POST);
		// die;

		$position = isset($_POST['coop-layout__position']) ? sanitize_text_field(wp_unslash($_POST['coop-layout__position'])) : null; //phpcs:ignore WordPress.Security
		$animation = isset($_POST['coop-layout__animation']) ? sanitize_text_field(wp_unslash($_POST['coop-layout__animation'])) : null; //phpcs:ignore WordPress.Security
		$animation_slide_value = isset($_POST['coop-layout__animation__slide']) ? sanitize_text_field(wp_unslash($_POST['coop-layout__animation__slide'])) : null; //phpcs:ignore WordPress.Security
		$text_color = isset($_POST['coop-layout__text-color']) ? sanitize_hex_color(wp_unslash($_POST['coop-layout__text-color'])) : null; //phpcs:ignore WordPress.Security
		$btn_color = isset($_POST['coop-layout__btn-color']) ? sanitize_hex_color(wp_unslash($_POST['coop-layout__btn-color'])) : null; //phpcs:ignore WordPress.Security
		$bar_color = isset($_POST['coop-layout__bar-color']) ? sanitize_hex_color(wp_unslash($_POST['coop-layout__bar-color'])) : null; //phpcs:ignore WordPress.Security
		$bar_opacity = isset($_POST['coop-layout__bar-opacity']) ? sanitize_text_field(wp_unslash($_POST['coop-layout__bar-opacity'])) : null; //phpcs:ignore WordPress.Security

		// For position 
		if (empty($animation)) {
			$errors->add(
				'position',
				esc_html__('Position must exist', 'cookie-opt')
			);
		}
		if (!in_array($position, self::POSITION_LIST)) {
			$errors->add(
				'position',
				esc_html__('Position is invalid', 'cookie-opt')
			);
		}

		//For animation
		if (empty($animation)) {
			$errors->add(
				'animation',
				esc_html__('Animation must exist', 'cookie-opt')
			);
		}
		if (!in_array($animation, self::ANIMATION_LIST)) {
			$errors->add(
				'animation',
				esc_html__('Animation is invalid', 'cookie-opt')
			);
		}
		if (!empty($animation) && $animation == 'slide') {
			if (empty($animation_slide_value)) {
				$errors->add(
					'animation',
					esc_html__('Animation slide value must exist', 'cookie-opt')
				);
			} elseif (!in_array($animation_slide_value, self::ANIMATION_SLIDE_VALUE)) {
				$errors->add(
					'animation',
					esc_html__('Animation slide value is invalid', 'cookie-opt')
				);
			} else {
				$_POST['coop-layout__animation'] = $animation_slide_value;
			}
		}

		// For Text color
		if (empty($text_color)) {
			$errors->add(
				'text_color',
				esc_html__('Text color is not empty', 'cookie-opt')
			);
		}
		if (!preg_match('/^#(?:[0-9a-fA-F]{3}){1,2}$/', $text_color)) {
			$errors->add(
				'text_color',
				esc_html__('Text color is invalid', 'cookie-opt')
			);
		}

		// For Button color
		if (empty($btn_color)) {
			$errors->add(
				'btn_color',
				esc_html__('Button color is not empty', 'cookie-opt')
			);
		}
		if (!preg_match('/^#(?:[0-9a-fA-F]{3}){1,2}$/', $btn_color)) {
			$errors->add(
				'btn_color',
				esc_html__('Button color is invalid', 'cookie-opt')
			);
		}

		// For Bar color
		if (empty($bar_color)) {
			$errors->add(
				'bar_color',
				esc_html__('Bar color is not empty', 'cookie-opt')
			);
		}
		if (!preg_match('/^#(?:[0-9a-fA-F]{3}){1,2}$/', $bar_color)) {
			$errors->add(
				'bar_color',
				esc_html__('Bar color is invalid', 'cookie-opt')
			);
		}

		if (empty($bar_opacity)) {
			$errors->add(
				'bar_opacity',
				esc_html__('Bar opacity is not empty', 'cookie-opt')
			);
		}
		if (is_numeric($bar_opacity)) {
			if ($bar_opacity < 50 || $bar_opacity > 100) {
				$errors->add(
					'bar_opacity',
					esc_html__('The value of opacity must be >= 50 or <= 100', 'cookie-opt')
				);
			}
		} else {
			$errors->add(
				'bar_opacity',
				esc_html__('Bar opacity is numeric', 'cookie-opt')
			);
		}


		return $errors;
	}
}
