<?php

namespace App\Validates;

use WP_Error;

class OtherRequest
{
	public static function otherRequest($data)
	{
		$errors = new WP_Error();
		if (!isset($data['other'])) {
			$errors->add('other', esc_html__('Error', 'cookie-opt'));
			return $errors;
		}
		if (empty($data['other'])) {
			$errors->add('other', esc_html__('Other is not empty', 'cookie-opt'));
		}
		if (!preg_match('/^[A-Za-z0-9_-]*$/', $data['other'])) {
			$errors->add('other', esc_html__('Invalid Data', 'cookie-opt'));
		}

		return $errors;
	}
}
