<?php

namespace App\Validates;

use WP_Error;

class LanguagesEditRequest
{
	public static function validateLanguagesEdit($data, $regulation)
	{
		$errors = new WP_Error();
		$title = isset($data['title']) ? $data['title'] : [];
		$message = isset($data['message']) ? $data['message'] : [];
		$accept = isset($data['accept']) ? $data['accept'] : [];
		$policy = isset($data['policy']) ? $data['policy'] : [];
		$cookie_policy = isset($data['cookie_policy_button'])
			? $data['cookie_policy_button']
			: [];

		if (count($title) == 0) {
			$errors->add('title', esc_html__('Title must exist', 'cookie-opt'));
			return $errors;
		}
		if (count($message) == 0) {
			$errors->add('message', esc_html__('Message must exist', 'cookie-opt'));
			return $errors;
		}
		if (count($accept) == 0) {
			$errors->add(
				'accept',
				esc_html__('Accept Button must exist', 'cookie-opt')
			);
			return $errors;
		}

		if (count($policy) == 0) {
			$errors->add(
				'policy',
				esc_html__('Policy Button must exist', 'cookie-opt')
			);
			return $errors;
		}

		foreach ($title as $key => $value) {
			if (empty($value)) {
				$errors->add(
					'title',
					esc_html__('Title is not empty', 'cookie-opt'),
					$key
				);
			}
		}
		foreach ($message as $key => $value) {
			if (empty($value)) {
				$errors->add(
					'message',
					esc_html__('Message is not empty', 'cookie-opt'),
					$key
				);
			}
		}
		foreach ($accept as $key => $value) {
			if (empty($value)) {
				$errors->add(
					'accept',
					esc_html__('Accept Button is not empty', 'cookie-opt'),
					$key
				);
			}
		}

		foreach ($policy as $key => $value) {
			if (empty($value)) {
				$errors->add(
					'policy',
					esc_html__('Policy Button is not empty', 'cookie-opt'),
					$key
				);
			}
		}

		if ($regulation == 'ja') {
			if (count($cookie_policy) == 0) {
				$errors->add(
					'cookie_policy',
					esc_html__('Cookie Policy Button must exist', 'cookie-opt')
				);
				return $errors;
			}

			foreach ($cookie_policy as $key => $value) {
				if (empty($value)) {
					$errors->add(
						'cookie_policy',
						esc_html__('Cookie Policy Button is not empty', 'cookie-opt'),
						$key
					);
				}
			}
		}

		if ($regulation != 'ja') {
			$reject = isset($data['reject']) ? $data['reject'] : [];
			$customize = isset($data['customize']) ? $data['customize'] : [];
			$do_not_sell_page_btn = isset($data['do_not_sell_page_button'])
				? $data['do_not_sell_page_button']
				: [];
			$customize_title = isset($data['customize_title'])
				? $data['customize_title']
				: [];
			$customize_description = isset($data['customize_description'])
				? $data['customize_description']
				: [];
			$necessary_cookies = isset($data['necessary_cookies'])
				? $data['necessary_cookies']
				: [];
			$performance_cookies = isset($data['performance_cookies'])
				? $data['performance_cookies']
				: [];
			$functionality_cookies = isset($data['functionality_cookies'])
				? $data['functionality_cookies']
				: [];
			$social_media_cookies = isset($data['social_media_cookies'])
				? $data['social_media_cookies']
				: [];
			$here = isset($data['here']) ? $data['here'] : [];
			$always_active = isset($data['always_active'])
				? $data['always_active']
				: [];
			$button_save = isset($data['button_save']) ? $data['button_save'] : [];

			if ($regulation == 'us') {
				if (count($do_not_sell_page_btn) == 0) {
					$errors->add(
						'do_not_sell_page_btn',
						esc_html__('Do Not Sell Page Button must exist', 'cookie-opt')
					);
					return $errors;
				}

				foreach ($do_not_sell_page_btn as $key => $value) {
					if (empty($value)) {
						$errors->add(
							'do_not_sell_page_btn',
							esc_html__('Do Not Sell Page Button is not empty', 'cookie-opt'),
							$key
						);
					}
				}
			}

			if (count($reject) == 0) {
				$errors->add(
					'reject',
					esc_html__('Reject Button must exist', 'cookie-opt')
				);
				return $errors;
			}
			if (count($customize) == 0) {
				$errors->add(
					'customize',
					esc_html__('Customize Button must exist', 'cookie-opt')
				);
				return $errors;
			}
			if (count($customize_title) == 0) {
				$errors->add(
					'customize_title',
					esc_html__('Customize Title must exist', 'cookie-opt')
				);
				return $errors;
			}
			if (count($customize_description) == 0) {
				$errors->add(
					'customize_description',
					esc_html__('Customize Description must exist', 'cookie-opt')
				);
				return $errors;
			}
			if (count($necessary_cookies) == 0) {
				$errors->add(
					'necessary_cookies',
					esc_html__('Necessary Cookies must exist', 'cookie-opt')
				);
				return $errors;
			}
			if (count($performance_cookies) == 0) {
				$errors->add(
					'performance_cookies',
					esc_html__('Performance Cookies must exist', 'cookie-opt')
				);
				return $errors;
			}
			if (count($functionality_cookies) == 0) {
				$errors->add(
					'functionality_cookies',
					esc_html__('Functionality Cookies must exist', 'cookie-opt')
				);
				return $errors;
			}
			if (count($social_media_cookies) == 0) {
				$errors->add(
					'social_media_cookies',
					esc_html__('Social Media Cookies must exist', 'cookie-opt')
				);
				return $errors;
			}
			if (count($here) == 0) {
				$errors->add('here', esc_html__('Here must exist', 'cookie-opt'));
				return $errors;
			}
			if (count($always_active) == 0) {
				$errors->add(
					'always_active',
					esc_html__('Always Active must exist', 'cookie-opt')
				);
				return $errors;
			}
			if (count($button_save) == 0) {
				$errors->add(
					'button_save',
					esc_html__('Save Button must exist', 'cookie-opt')
				);
				return $errors;
			}

			foreach ($reject as $key => $value) {
				if (empty($value)) {
					$errors->add(
						'reject',
						esc_html__('Reject Button is not empty', 'cookie-opt'),
						$key
					);
				}
			}
			foreach ($customize as $key => $value) {
				if (empty($value)) {
					$errors->add(
						'customize',
						esc_html__('Customize Button is not empty', 'cookie-opt'),
						$key
					);
				}
			}
			foreach ($customize_title as $key => $value) {
				if (empty($value)) {
					$errors->add(
						'customize_title',
						esc_html__('Customize Title is not empty', 'cookie-opt'),
						$key
					);
				}
			}
			foreach ($customize_description as $key => $value) {
				if (empty($value)) {
					$errors->add(
						'customize_description',
						esc_html__('Customize Description is not empty', 'cookie-opt'),
						$key
					);
				}
			}
			foreach ($necessary_cookies as $key => $value) {
				if (empty(sanitize_text_field($value))) {
					$errors->add(
						'necessary_cookies',
						esc_html__('Necessary Cookies is not empty', 'cookie-opt'),
						$key
					);
				}
			}
			foreach ($performance_cookies as $key => $value) {
				if (empty(sanitize_text_field($value))) {
					$errors->add(
						'performance_cookies',
						esc_html__('Performance Cookies is not empty', 'cookie-opt'),
						$key
					);
				}
			}
			foreach ($functionality_cookies as $key => $value) {
				if (empty(sanitize_text_field($value))) {
					$errors->add(
						'functionality_cookies',
						esc_html__('Functionality Cookies is not empty', 'cookie-opt'),
						$key
					);
				}
			}
			foreach ($social_media_cookies as $key => $value) {
				if (empty(sanitize_text_field($value))) {
					$errors->add(
						'social_media_cookies',
						esc_html__('Social Media Cookies is not empty', 'cookie-opt'),
						$key
					);
				}
			}
			foreach ($here as $key => $value) {
				if (empty(sanitize_text_field($value))) {
					$errors->add(
						'here',
						esc_html__('Here is not empty', 'cookie-opt'),
						$key
					);
				}
			}
			foreach ($always_active as $key => $value) {
				if (empty(sanitize_text_field($value))) {
					$errors->add(
						'always_active',
						esc_html__('Always Active is not empty', 'cookie-opt'),
						$key
					);
				}
			}
			foreach ($button_save as $key => $value) {
				if (empty(sanitize_text_field($value))) {
					$errors->add(
						'button_save',
						esc_html__('Save Button is not empty', 'cookie-opt'),
						$key
					);
				}
			}
		}
		return $errors;
	}
}
