<?php

namespace App\Validates;

use WP_Error;
use App\Services\CookieOptLanguagesService;

class LanguagesAddRequest
{
	public static function validateCategoryEdit($data)
	{
		$errors = new WP_Error();
		$language = isset($data['language']) ? $data['language'] : [];
		if (count($language) === 0) {
			$errors->add('language', esc_html__('Language must exist', 'cookie-opt'));
			return $errors;
		}
		foreach ($language as $key => $value) {
			if (empty($value)) {
				$errors->add(
					'language',
					esc_html__('Language is not empty', 'cookie-opt')
				);
				return $errors;
			}
			if (!array_key_exists($value, CookieOptLanguagesService::CODE_LANG)) {
				$errors->add(
					'language',
					esc_html__('Language dont exist', 'cookie-opt')
				);
				return $errors;
			}
		}
		return $errors;
	}
}
