<?php

namespace App\Tables;

if (!class_exists('WP_List_Table')) {
	require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

class CookieOptBaseTable extends \WP_List_Table
{
	public function getCustomParamsSortable()
	{
		return [];
	}

	public function print_column_headers($with_id = true)
	{
		list($columns, $hidden, $sortable, $primary) = $this->get_column_info();

		$current_url = set_url_scheme('http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']); //phpcs:ignore WordPress.Security
		$current_url = remove_query_arg('paged', $current_url);

		// When users click on a column header to sort by other columns.
		if (isset($_GET['orderby'])) { //phpcs:ignore WordPress.Security
			$current_orderby = $_GET['orderby']; //phpcs:ignore WordPress.Security
			// In the initial view there's no orderby parameter.
		} else {
			$current_orderby = '';
		}

		// Not in the initial view and descending order.
		if (isset($_GET['order']) && 'desc' === $_GET['order']) { //phpcs:ignore WordPress.Security
			$current_order = 'desc';
		} else {
			// The initial view is not always 'asc', we'll take care of this below.
			$current_order = 'asc';
		}

		if (!empty($columns['cb'])) {
			static $cb_counter = 1;
			$columns['cb'] = '<input id="cb-select-all-' . $cb_counter . '" type="checkbox" />
			<label for="cb-select-all-' . $cb_counter . '">' .
				'<span class="screen-reader-text">' .
				/* translators: Hidden accessibility text. */
				esc_html__('Select All', 'cookie-opt') .
				'</span>' .
				'</label>';
			++$cb_counter;
		}

		foreach ($columns as $column_key => $column_display_name) {
			$class = array('manage-column', "column-$column_key");
			$aria_sort_attr = '';
			$abbr_attr = '';
			$order_text = '';

			if (in_array($column_key, $hidden, true)) {
				$class[] = 'hidden';
			}

			if ('cb' === $column_key) {
				$class[] = 'check-column';
			} elseif (in_array($column_key, array('posts', 'comments', 'links'), true)) {
				$class[] = 'num';
			}

			if ($column_key === $primary) {
				$class[] = 'column-primary';
			}

			if (isset($sortable[$column_key])) {
				$orderby = isset($sortable[$column_key][0]) ? $sortable[$column_key][0] : '';
				$desc_first = isset($sortable[$column_key][1]) ? $sortable[$column_key][1] : false;
				$abbr = isset($sortable[$column_key][2]) ? $sortable[$column_key][2] : '';
				$orderby_text = isset($sortable[$column_key][3]) ? $sortable[$column_key][3] : '';
				$initial_order = isset($sortable[$column_key][4]) ? $sortable[$column_key][4] : '';

				/*
				 * We're in the initial view and there's no $_GET['orderby'] then check if the
				 * initial sorting information is set in the sortable columns and use that.
				 */
				if ('' === $current_orderby && $initial_order) {
					// Use the initially sorted column $orderby as current orderby.
					$current_orderby = $orderby;
					// Use the initially sorted column asc/desc order as initial order.
					$current_order = $initial_order;
				}

				/*
				 * True in the initial view when an initial orderby is set via get_sortable_columns()
				 * and true in the sorted views when the actual $_GET['orderby'] is equal to $orderby.
				 */
				if ($current_orderby === $orderby) {
					// The sorted column. The `aria-sort` attribute must be set only on the sorted column.
					if ('asc' === $current_order) {
						$order = 'desc';
						$aria_sort_attr = ' aria-sort="ascending"';
					} else {
						$order = 'asc';
						$aria_sort_attr = ' aria-sort="descending"';
					}

					$class[] = 'sorted';
					$class[] = $current_order;
				} else {
					// The other sortable columns.
					$order = strtolower($desc_first);

					if (!in_array($order, array('desc', 'asc'), true)) {
						$order = $desc_first ? 'desc' : 'asc';
					}

					$class[] = 'sortable';
					$class[] = 'desc' === $order ? 'asc' : 'desc';

					/* translators: Hidden accessibility text. */
					$asc_text = esc_html__('Sort ascending.', 'cookie-opt');
					/* translators: Hidden accessibility text. */
					$desc_text = esc_html__('Sort descending.', 'cookie-opt');
					$order_text = 'asc' === $order ? $asc_text : $desc_text;
				}

				if ('' !== $order_text) {
					$order_text = ' <span class="screen-reader-text">' . $order_text . '</span>';
				}

				// Print an 'abbr' attribute if a value is provided via get_sortable_columns().
				$abbr_attr = $abbr ? ' abbr="' . esc_attr($abbr) . '"' : '';

				$params_sortable = [
					'orderby' => $orderby,
					'order' => $order,
				];

				$column_display_name = sprintf(
					'<a href="%1$s">' .
					'<span>%2$s</span>' .
					'<span class="sorting-indicators">' .
					'<span class="sorting-indicator asc" aria-hidden="true"></span>' .
					'<span class="sorting-indicator desc" aria-hidden="true"></span>' .
					'</span>' .
					'%3$s' .
					'</a>',
					esc_url(add_query_arg(array_merge($params_sortable, $this->getCustomParamsSortable()), $current_url)),
					$column_display_name,
					$order_text
				);
			}

			$tag = ('cb' === $column_key) ? 'td' : 'th';
			$scope = ('th' === $tag) ? 'scope="col"' : '';
			$id = $with_id ? "id='$column_key'" : '';

			if (!empty($class)) {
				$class = "class='" . implode(' ', $class) . "'";
			}

			echo "<$tag $scope $id $class $aria_sort_attr $abbr_attr>$column_display_name</$tag>"; //phpcs:ignore WordPress.Security
		}
	}
	protected function pagination($which)
	{
		if (empty($this->_pagination_args) || !is_array($this->_pagination_args)) {
			return;
		}

		$total_items = $this->_pagination_args['total_items'];
		$total_pages = $this->_pagination_args['total_pages'];
		$per_page = $this->_pagination_args['per_page'];
		$current = $this->get_pagenum();
		$page = sanitize_text_field($_REQUEST['page'] ?? '');

		if ('top' === $which && $total_pages <= 1) {
			return;
		}

		// Custom params như sort, filter
		$custom_params = $this->getCustomParamsSortable();

		// Base URL
		$base_url = add_query_arg(array_merge([
			'page' => $page,
		], $custom_params), 'admin.php');

		$first_page_url = esc_url(admin_url($base_url));
		$prev_page_url = esc_url(admin_url($base_url . '&paged=' . max(1, $current - 1)));
		$next_page_url = esc_url(admin_url($base_url . '&paged=' . min($total_pages, $current + 1)));
		$last_page_url = esc_url(admin_url($base_url . '&paged=' . $total_pages));

		// Hiển thị số lượng
		$start = ($current - 1) * $per_page + 1;
		$end = min($total_items, $current * $per_page);

		echo '<span class="displaying-num">' . sprintf(__('%1$s items'), $total_items) . '</span>';

		echo '<span class="pagination-links">';

		// « First page
		if ($current > 1) {
			echo '<a class="first-page button" href="' . $first_page_url . '">
					<span class="screen-reader-text">' . __('First page') . '</span>
					<span aria-hidden="true">«</span>
				</a>';
		} else {
			echo '<span class="tablenav-pages-navspan button disabled" aria-hidden="true">«</span>';
		}

		// ‹ Previous page
		if ($current > 1) {
			echo '<a class="prev-page button" href="' . $prev_page_url . '">
					<span class="screen-reader-text">' . __('Previous page') . '</span>
					<span aria-hidden="true">‹</span>
				</a>';
		} else {
			echo '<span class="tablenav-pages-navspan button disabled" aria-hidden="true">‹</span>';
		}

		// Page input
		echo '<span class="paging-input">';
		echo '<label for="current-page-selector" class="screen-reader-text">' . __('Current Page') . '</label>';
		echo '<input class="current-page" id="current-page-selector" type="text" name="paged" value="' . esc_attr($current) . '" size="1" aria-describedby="table-paging" />';
		echo '<span class="tablenav-paging-text">' . __(' of ');
		echo '<span class="total-pages">' . number_format_i18n($total_pages) . '</span>';
		echo '</span>';
		echo '</span>';

		// › Next page
		if ($current < $total_pages) {
			echo '<a class="next-page button" href="' . $next_page_url . '">
					<span class="screen-reader-text">' . __('Next page') . '</span>
					<span aria-hidden="true">›</span>
				</a>';
		} else {
			echo '<span class="tablenav-pages-navspan button disabled" aria-hidden="true">›</span>';
		}

		// » Last page
		if ($current < $total_pages) {
			echo '<a class="last-page button" href="' . $last_page_url . '">
					<span class="screen-reader-text">' . __('Last page') . '</span>
					<span aria-hidden="true">»</span>
				</a>';
		} else {
			echo '<span class="tablenav-pages-navspan button disabled" aria-hidden="true">»</span>';
		}

		echo '</span>'; // .pagination-links
	}

	protected function display_tablenav($which)
	{
		if (empty($this->_pagination_args)) {
			return;
		}

		$total_pages = $this->_pagination_args['total_pages'];

		// Ẩn phân trang ở top nếu chỉ có 1 trang
		if ('top' === $which && $total_pages <= 1) {
			return;
		}
		?>
		<div class="tablenav <?php echo esc_attr($which); ?>">
			<?php if ($this->has_items()): ?>
				<div class="alignleft actions bulkactions">
					<?php $this->bulk_actions($which); ?>
				</div>
			<?php endif; ?>

			<?php $this->extra_tablenav($which); ?>

			<div class="tablenav-pages">
				<?php $this->pagination($which); ?>
			</div>

			<br class="clear" />
		</div>

		<?php
	}






}