<?php

namespace App\Services\ViewHelper;

use App\Services\CookieOptTagManagementService;

class TagManagementView
{
	/**
	 * Render an item by transforming its properties
	 *
	 * @param array $item - An array containing item properties
	 * @return array - Transformed item data
	 */
	public static function renderItem($item)
	{
		$data = [];
		$data['id'] = $item['id'];
		$data['name'] = empty($item['tagid'])
			? $item['name_tag_management']
			: $item['name_tag_info'];
		$data['tag'] = $item['tag'];
		$data['position'] = !empty($item['tagid'])
			? ''
			: self::render_position($item['position']);
		$data['installation_page'] = self::render_installation_page(
			$item['installation_page']
		);
		$data['status'] = self::render_active($item['active']);
		$data['registration_date'] = gmdate(
			'Y/m/d h:i A',
			strtotime($item['created_at'])
		);
		return $data;
	}

	public static function render_installation_page($installation_page)
	{
		if ($installation_page != 'all') {
			$current_page = json_decode($installation_page, true);
			foreach ($current_page as $item) {
				$new_pages[] = self::get_name_page($item);
			}

			$installation_page = implode(',', $new_pages);
		}
		return $installation_page;
	}

	public static function get_name_page($id)
	{
		$tag_management_service = new CookieOptTagManagementService();
		return $tag_management_service->findName($id);
	}

	/**
	 * Render the "position" property based on its value
	 *
	 * @param int $item - The "position" property value (0 or 1)
	 * @return string - Rendered position ('<head>' or '<body>')
	 */
	public static function render_position($item)
	{
		return $item == 0 ? '<head>' : '<body>';
	}

	/**
	 * Render the "active" property based on its value
	 *
	 * @param int $item - The "active" property value (0 or 1)
	 * @return string - Rendered status ('active' or 'inactive')
	 */
	public static function render_active($item)
	{
		return $item == 0
			? esc_html__('Active', 'cookie-opt')
			: esc_html__('Passive', 'cookie-opt');
	}
	/**
	 * Display an error message for a specific key
	 *
	 * @param string $key - The key for the error message
	 * @param string $key_error - The key for the error transient
	 * @return void - Error message displayed if it exists
	 */
	public static function messageError($key, $key_error)
	{
		if (get_transient($key_error) !== false) {
			$errors = get_transient($key_error);
			$msg = $errors->get_error_messages($key);
			if (count($msg) > 0) {
				$string = esc_html($msg[0]);
				ob_start();
				?>
  					<div>
      					<p style="color: red;"><?php echo esc_html($string) ?></p>
  					</div>
				<?php
				$html_string = ob_get_clean();
				echo wp_kses($html_string, COOKIE_OPT_ALLOW_HTML_TAG);
			}
		}
	}
	/**
	 * Display a success alert message with a custom message
	 *
	 * @param string $key_error - The key for the success transient
	 * @param string $msg - Custom success message
	 * @return void - Success alert displayed if it exists, and then the transient is deleted
	 */
	public static function alert($key_error, $msg)
	{
		if (get_transient($key_error) !== false) {
			ob_start();
			?>
				<div class="alert alert-success" id="custom-alert">
					<strong><?php esc_html__('Notification:','cookie-opt') ?></strong><?php esc_attr($msg) ?>
					<button type="button" class="close" id="close-alert" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
			<?php
			$html_string = ob_get_clean();
			esc_html($html_string);
			delete_transient($key_error);
		}
	}
}
