<?php

namespace App\Services\ViewHelper;

class CookieOptLanguagesView
{
    public static function selectContent($data, $content, $key, $index_op)
    {
        ob_start(); ?>

        <?php $check_logic =
            $data['res_by_index']->default_language == $data['id'] ||
            $data['id'] == $key ||
            $key != $data['res_by_index']->default_language; ?>
        <div class="<?php echo esc_attr(
            $check_logic ? 'logic-show' : 'logic-hidden'
        ); ?>">
            <div class="mb-3 row flex-nowrap">
                <div class="col-sm-9 row align-items-center">
                    <h4 class="col-sm-6"><?php echo esc_html__(
                        'Edit Content In:',
                        'cookie-opt'
                    ); ?></h4>
                    <select class="col-sm-6 select-language-js" data-key=<?php echo esc_attr(
                        $index_op
                    ); ?>>
                        <?php foreach ($data['content'] as $key_banner => $value_banner) { ?>
                            <option <?php echo esc_attr(
                                $key_banner == $key ? 'selected' : ''
                            ); ?> value="<?php echo esc_attr(
                                  $key_banner
                              ); ?>" data-code="<?php echo esc_attr(
                                   $key_banner
                               ); ?>" data-car-parent="<?php echo esc_attr('car-' . $key_banner); ?>">
                                <?php echo esc_attr(
                                    $data['array_of_banner'][$key_banner]
                                ); ?>
                            </option>
                        <?php } ?>
                    </select>
                </div>

                <div class="col-sm-3 row justify-content-end align-items-center">
                    <label class="title-banner" for="switch-<?php echo esc_attr(
                        $key
                    ); ?>"><b><?php echo esc_html__('Banner Preview', 'cookie-opt'); ?></b></label>
                    <input class="checkbox-switch banner-preview" type="checkbox" id="switch-<?php echo esc_attr(
                        $key
                    ); ?>" />
                    <label class="label-switch" for="switch-<?php echo esc_attr(
                        $key
                    ); ?>"><?php echo esc_html__('Toggle', 'cookie-opt'); ?></label>
                </div>
            </div>
        </div>
        <div class="<?php echo esc_attr(!$check_logic)
            ? 'logic-show'
            : 'logic-hidden'; ?>">
            <div class="mb-3 row flex-nowrap">
                <div class="col-sm-9 row">
                    <h4 class="col-sm-9">
                        <?php echo esc_html__(
                            'Default Language:',
                            'cookie-opt'
                        ); ?><b><?php echo esc_attr($data['array_of_banner'][$data['res_by_index']->default_language]); ?></b></h4>
                    <div class="col-sm-6"></div>
                </div>
                <div class="col-sm-3 row"></div>
            </div>
        </div>

        <?php return ob_get_clean();
    }
    public static function renderContent($data, $content, $key)
    {
        ob_start(); ?>


        <div class="accordion border">
            <div class="accordion__item">
                <div class="accordion__title cookie-opt-title accordion-active">
                    <div class="accordion__arrow accordion__arrow cookie-opt-arrow accordion__rotate"><span
                            class="accordion__arrow-item ">+</span></div>
                    <span class="accordion__title-text"><?php echo esc_html__(
                        'Cookie Notice',
                        'cookie-opt'
                    ); ?></span>
                </div>
                <div class="accordion__content cookie-opt-content">
                    <div class="row mb-3">
                        <label for="title-default<?php echo esc_attr(
                            $key
                        ); ?>" class="col-sm-3 col-form-label">
                            <h7><b><?php echo esc_html__(
                                'Title',
                                'cookie-opt'
                            ); ?></b></h7>
                        </label>
                        <div class="col-sm-9">
                            <input name="title[<?php echo esc_attr(
                                $key
                            ); ?>]" data-value-change="banner-title" type="text" class="form-control title-main coop-change-value"
                                id="title-default<?php echo esc_attr($key); ?>" placeholder="We value your privacy"
                                value="<?php echo esc_attr(isset($content['notice']['title']) ? $content['notice']['title'] : ''); ?>">
                            <?php echo self::messageError('title', $key);//phpcs:ignore WordPress.Security ?>
                            <!-- $errors->get_error_data() -->
                        </div>

                    </div>
                    <div class="row mb-3">
                        <label for="message-default<?php echo esc_attr(
                            $key
                        ); ?>" class="col-sm-3 col-form-label d-flex align-items-center description-main">
                            <h7><b><?php echo esc_html__(
                                'Message',
                                'cookie-opt'
                            ); ?></b></h7>
                        </label>
                        <div class="col-sm-9">
                            <textarea name="message[<?php echo esc_attr(
                                $key
                            ); ?>]" data-value-change="banner-description" class="form-control coop-change-value"
                                id="message-default<?php echo esc_attr($key); ?>" cols="20" rows="6"
                                placeholder='We use cookies to enhance your browsing experience, serve personalized ads or content, and analyze our traffic. By clicking "Accept All", you consent to our use of cookies.'><?php echo esc_attr(isset($content['notice']['description']) ? stripslashes($content['notice']['description']) : ''); ?></textarea>
                            <?php echo esc_attr(
                                self::messageError('message', $key)
                            ); ?>
                        </div>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <label for="accept<?php echo esc_attr(
                            $key
                        ); ?>" class="form-label accept-button">
                            <h4><?php echo esc_html__(
                                '“Accept All” Button',
                                'cookie-opt'
                            ); ?> </h4>
                        </label>
                        <input name="accept[<?php echo esc_attr(
                            $key
                        ); ?>]" type="text" data-value-change="banner-accept_button" class="form-control coop-change-value"
                            id="accept<?php echo esc_attr($key); ?>" placeholder="Accept All"
                            value="<?php echo esc_attr($content['notice']['buttons']['accept_button'] ? $content['notice']['buttons']['accept_button'] : ''); ?>">
                        <?php echo esc_attr(
                            self::messageError('accept', $key)
                        ); ?>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <label for="reject[<?php echo esc_attr(
                            $key
                        ); ?>]" class="form-label reject-button">
                            <h4><?php echo esc_html__(
                                '“Reject All” Button',
                                'cookie-opt'
                            ); ?> </h4>
                        </label>
                        <input name="reject[<?php echo esc_attr(
                            $key
                        ); ?>]" type="text" data-value-change="banner-reject_button" class="form-control coop-change-value"
                            id="reject<?php echo esc_attr($key); ?>" placeholder="Reject All"
                            value="<?php echo esc_attr($content['notice']['buttons']['reject_button'] ? $content['notice']['buttons']['reject_button'] : ''); ?>">
                        <?php echo esc_attr(
                            self::messageError('reject', $key)
                        ); ?>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <label for="customize<?php echo esc_attr(
                            $key
                        ); ?>" class="form-label customize-button">
                            <h4><?php echo esc_html__(
                                '“Customize” Button',
                                'cookie-opt'
                            ); ?> </h4>
                        </label>
                        <input name="customize[<?php echo esc_attr(
                            $key
                        ); ?>]" type="text" data-value-change="banner-customize_button" class="form-control coop-change-value"
                            id="customize<?php echo esc_attr($key); ?>" placeholder="Customize"
                            value="<?php echo esc_attr($content['notice']['buttons']['customize_button'] ? $content['notice']['buttons']['customize_button'] : ''); ?>">
                        <?php echo esc_attr(
                            self::messageError('customize', $key)
                        ); ?>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label">
                            <h4><?php echo esc_html__(
                                '“Cookie Policy” Link',
                                'cookie-opt'
                            ); ?> </h4>
                        </label>
                        <input name="policy[<?php echo esc_attr(
                            $key
                        ); ?>]" type="text" data-value-change="banner-privacy_policy_button" class="form-control coop-change-value"
                            id="exampleInputEmail1" placeholder="Cookie Policy"
                            value="<?php echo esc_attr($content['notice']['buttons']['privacy_policy_button'] ? $content['notice']['buttons']['privacy_policy_button'] : ''); ?>">
                        <?php echo esc_attr(
                            self::messageError('policy', $key)
                        ); ?>
                    </div>
                    <div class="mb-3">
                        <input type="text" name="policy-link[<?php echo esc_attr(
                            $key
                        ); ?>]" value="<?php echo esc_url($data['link_policy']); ?>" class="form-control"
                            id="exampleInputEmail1" placeholder="Enter the URL to your cookie policy or privacy page">
                    </div>
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label">
                            <h4><?php echo esc_html__(
                                'Do Not Sell Page',
                                'cookie-opt'
                            ); ?> </h4>
                        </label>
                        <input name="do_not_sell_page_button[<?php echo esc_attr(
                            $key
                        ); ?>]" type="text" data-value-change="banner-do_not_sell_page_button" class="form-control coop-change-value"
                            id="exampleInputEmail1" placeholder="Do not sell page"
                            value="<?php echo esc_attr($content['notice']['buttons']['do_not_sell_page_button'] ? $content['notice']['buttons']['do_not_sell_page_button'] : ''); ?>">
                        <?php echo esc_attr(
                            self::messageError('do_not_sell_page_btn', $key)
                        ); ?>
                    </div>
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label privacy-policy-button">
                            <h4><?php echo esc_html__(
                                'Cookie Policy Button',
                                'cookie-opt'
                            ); ?> </h4>
                        </label>
                        <input name="cookie_policy_button[<?php echo esc_attr(
                            $key
                        ); ?>]" type="text" data-value-change="banner-cookie_policy_button" class="form-control coop-change-value"
                            id="exampleInputEmail1" placeholder="Cookie Policy Button"
                            value="<?php echo esc_attr($content['notice']['buttons']['cookie_policy_button'] ? $content['notice']['buttons']['cookie_policy_button'] : ''); ?>">
                        <?php echo esc_attr(
                            self::messageError('cookie_policy', $key)
                        ); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="accordion border">
            <div class="accordion__item">
                <div class="accordion__title cookie-customize-title accordion-active">
                    <div class="accordion__arrow accordion__arrow cookie-customize-arrow accordion__rotate"><span
                            class="accordion__arrow-item ">+</span></div>
                    <span class="accordion__title-text"><?php echo esc_html__(
                        'Cookie Customize',
                        'cookie-opt'
                    ); ?></span>
                </div>
                <div class="accordion__content cookie-customize-content">
                    <div class="row mb-3">
                        <label for="customize-title-default<?php echo esc_attr(
                            $key
                        ); ?>" class="col-sm-3 col-form-label">
                            <h7><b><?php echo esc_html__(
                                'Customize Title',
                                'cookie-opt'
                            ); ?></b></h7>
                        </label>
                        <div class="col-sm-9">
                            <input name="customize_title[<?php echo esc_attr(
                                $key
                            ); ?>]" type="text" data-value-change="banner-cus-title" class="form-control coop-change-value"
                                id="customize-title-default<?php echo esc_attr($key); ?>" placeholder="Customize"
                                value="<?php echo esc_attr($content['customize']['title'] ? $content['customize']['title'] : ''); ?>">
                            <?php echo esc_attr(
                                self::messageError('customize_title', $key)
                            ); ?>
                            <!-- $errors->get_error_data() -->
                        </div>

                    </div>
                    <div class="row mb-3">
                        <label for="customize-message-default<?php echo esc_attr(
                            $key
                        ); ?>" class="col-sm-3 col-form-label d-flex align-items-center">
                            <h7><b><?php echo esc_html__(
                                'Description',
                                'cookie-opt'
                            ); ?></b></h7>
                        </label>
                        <div class="col-sm-9">
                            <textarea name="customize_description[<?php echo esc_attr(
                                $key
                            ); ?>]" data-value-change="banner-cus-des" class="form-control coop-change-value"
                                id="customize-message-default<?php echo esc_attr($key); ?>" cols="20" rows="6"
                                placeholder='For more information on cookies, please click here'><?php echo esc_attr($content['customize']['description'] ? stripslashes($content['customize']['description']) : ''); ?></textarea>
                            <?php echo esc_attr(
                                self::messageError('customize_description', $key)
                            ); ?>
                        </div>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <label for="necessary_cookies<?php echo esc_attr(
                            $key
                        ); ?>" class="form-label">
                            <h4><?php echo esc_html__(
                                'Strictly Necessary Cookies',
                                'cookie-opt'
                            ); ?></h4>
                        </label>
                        <input name="necessary_cookies[<?php echo esc_attr(
                            $key
                        ); ?>]" type="text" data-value-change="banner-cus__necessary-cookies" class="form-control coop-change-value"
                            id="necessary_cookies<?php echo esc_attr($key); ?>" placeholder="Strictly Necessary Cookies"
                            value="<?php echo esc_attr($content['customize']['category']['necessary_cookies'] ? $content['customize']['category']['necessary_cookies'] : ''); ?>">
                        <?php echo esc_attr(
                            self::messageError('necessary_cookies', $key)
                        ); ?>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <label for="performance_cookies<?php echo esc_attr(
                            $key
                        ); ?>" class="form-label">
                            <h4><?php echo esc_html__(
                                'Performance Cookies',
                                'cookie-opt'
                            ); ?></h4>
                        </label>
                        <input name="performance_cookies[<?php echo esc_attr(
                            $key
                        ); ?>]" type="text" data-value-change="banner-cus__performance-cookies" class="form-control coop-change-value"
                            id="performance_cookies<?php echo esc_attr($key); ?>" placeholder="Performance Cookies"
                            value="<?php echo esc_attr($content['customize']['category']['performance_cookies'] ? $content['customize']['category']['performance_cookies'] : ''); ?>">
                        <?php echo esc_attr(
                            self::messageError('performance_cookies', $key)
                        ); ?>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <label for="functionality_cookies<?php echo esc_attr(
                            $key
                        ); ?>" class="form-label">
                            <h4><?php echo esc_html__(
                                'Functionality Cookie',
                                'cookie-opt'
                            ); ?></h4>
                        </label>
                        <input name="functionality_cookies[<?php echo esc_attr(
                            $key
                        ); ?>]" type="text" data-value-change="banner-cus__functionality-cookies" class="form-control coop-change-value"
                            id="functionality_cookies<?php echo esc_attr($key); ?>" placeholder="Functionality Cookie"
                            value="<?php echo esc_attr($content['customize']['category']['functionality_cookies'] ? $content['customize']['category']['functionality_cookies'] : ''); ?>">
                        <?php echo esc_attr(
                            self::messageError('functionality_cookies', $key)
                        ); ?>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <label for="social_media_cookies<?php echo esc_attr(
                            $key
                        ); ?>" class="form-label">
                            <h4><?php echo esc_html__(
                                'Social Media Cookies',
                                'cookie-opt'
                            ); ?> </h4>
                        </label>
                        <input name="social_media_cookies[<?php echo esc_attr(
                            $key
                        ); ?>]" type="text" data-value-change="banner-cus__social-media-cookies" class="form-control coop-change-value"
                            id="social_media_cookies<?php echo esc_attr($key); ?>" placeholder="Social Media Cookies"
                            value="<?php echo esc_attr($content['customize']['category']['social_media_cookies'] ? $content['customize']['category']['social_media_cookies'] : ''); ?>">
                        <?php echo esc_attr(
                            self::messageError('social_media_cookies', $key)
                        ); ?>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <label for="here<?php echo esc_attr(
                            $key
                        ); ?>" class="form-label">
                            <h4><?php echo esc_html__(
                                'Here',
                                'cookie-opt'
                            ); ?> </h4>
                        </label>
                        <input name="here[<?php echo esc_attr(
                            $key
                        ); ?>]" type="text" data-value-change="banner-here-link" class="form-control coop-change-value"
                            id="here<?php echo esc_attr($key); ?>" placeholder="Name Link"
                            value="<?php echo esc_attr($content['customize']['here'] ? $content['customize']['here'] : ''); ?>">
                        <?php echo esc_attr(
                            self::messageError('here', $key)
                        ); ?>
                    </div>
                    <div class="mb-3">
                        <input type="text" name="hereLink[<?php echo esc_attr(
                            $key
                        ); ?>]" value="<?php echo esc_url($data['link_policy']); ?>" class="form-control"
                            id="here<?php echo esc_attr($key); ?>"
                            placeholder="Enter the URL to your cookie policy or privacy page">
                    </div>
                    <hr>
                    <div class="mb-3">
                        <label for="always_active<?php echo esc_attr(
                            $key
                        ); ?>" class="form-label">
                            <h4><?php echo esc_html__(
                                'Always Active',
                                'cookie-opt'
                            ); ?></h4>
                        </label>
                        <input name="always_active[<?php echo esc_attr(
                            $key
                        ); ?>]" type="text" data-value-change="banner-cus__always-active" class="form-control coop-change-value"
                            id="always_active<?php echo esc_attr($key); ?>" placeholder="Always Active"
                            value="<?php echo esc_attr($content['customize']['always_active'] ? $content['customize']['always_active'] : ''); ?>">
                        <?php echo esc_attr(
                            self::messageError('always_active', $key)
                        ); ?>
                    </div>
                    <div class="mb-3">
                        <label for="button_save<?php echo esc_attr(
                            $key
                        ); ?>" class="form-label">
                            <h4><?php echo esc_html__(
                                'Button Save',
                                'cookie-opt'
                            ); ?></h4>
                        </label>
                        <input name="button_save[<?php echo esc_attr($key); ?>]" type="text" data-value-change="banner-save_button" class="form-control coop-change-value" id="button_save<?php echo esc_attr($key); ?>" placeholder="Button Save" value="<?php echo esc_attr($content['customize']['button_save'] ? $content['customize']['button_save'] : ''); ?>">
                        <?php echo esc_attr(
                            self::messageError('button_save', $key)
                        ); ?>
                    </div>
                </div>
            </div>
        </div>

        <?php return ob_get_clean();
    }
    protected static function messageError(
        $key,
        $key_parent,
        $key_error = 'validate-err'
    ) {
        if (get_transient($key_error) !== false) {
            $errors = get_transient($key_error);
            $array_error = $errors->get_all_error_data($key);
            if (in_array($key_parent, $array_error)) {
                $msg = $errors->get_error_messages($key);
                if (count($msg) > 0) {
                    $string = esc_html($msg[0]);
                    ob_start();
                    ?>
                        <div>
                            <p style="color: red;"><?php echo esc_html($string) ?></p>
                        </div>
                    <?php
                    $htmlString = ob_get_clean();
                    echo wp_kses($htmlString, COOKIE_OPT_ALLOW_HTML_TAG);
                }
            }
        }
    }
}
