<?php

namespace App\Services;

class CookieOptTagManagementService
{
	private $CookieOptTagManagement;

	public function __construct()
	{
		global $wpdb;
		$this->CookieOptTagManagement = $wpdb->prefix . 'cookie_opt_tag_management'; //table wp_CookieOptTagManagement
	}

	public function get($search = '')
	{
		global $wpdb;
		$table_tag_info = $wpdb->prefix . 'cookie_opt_tag_info';
		$table_tag_management = $wpdb->prefix . 'cookie_opt_tag_management';

		$items = $wpdb->get_results($wpdb->prepare("SELECT tag_manage.id, tag_manage.tagid, tag_manage.name AS name_tag_management, tag_info.name AS name_tag_info, tag_manage.tag, tag_manage.position, tag_manage.installation_page, tag_manage.active, tag_manage.created_at FROM {$table_tag_management} AS tag_manage LEFT JOIN {$table_tag_info} AS tag_info ON tag_manage.tagid  = tag_info.tagid WHERE tag_manage.name LIKE %s", '%' . $wpdb->esc_like($search) . '%'), ARRAY_A); // phpcs:ignore WordPress.DB
		return $items;
	}

	public function getAllTagPosition($position)
	{
		global $wpdb;
		$table_tag_info = $wpdb->prefix . 'cookie_opt_tag_info';
		$table_tag_management = $wpdb->prefix . 'cookie_opt_tag_management';

		$items = $wpdb->get_results($wpdb->prepare("SELECT tm.id, tm.tagid, tm.name AS name_tag_management, ti.name AS name_tag_info, tm.tag, tm.position, tm.installation_page, tm.active, tm.created_at FROM {$table_tag_management} AS tm LEFT JOIN {$table_tag_info} AS ti ON tm.tagid = ti.tagid WHERE tm.position = %d", $position), ARRAY_A); // phpcs:ignore WordPress.DB
		return $items;
	}
	public function findName($id = 25)
	{
		global $wpdb;
		$table_posts = $wpdb->prefix . 'posts';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$table_posts} WHERE ID = %d AND post_type = %s AND post_status = %s", $id, 'page', 'publish'), ARRAY_A); // phpcs:ignore WordPress.DB

		return $result['post_title'];
	}

	public function find($id)
	{
		global $wpdb;
		$item = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$this->CookieOptTagManagement} WHERE id = %d", $id)); // phpcs:ignore WordPress.DB
		return $item;
	}

	public function render_installation_page($installation_page)
	{
		if ($installation_page != 'all') {
			$current_page = json_decode($installation_page, true);
			foreach ($current_page as $item) {
				$new_pages[] = $this->findName($item);
			}

			$installation_page = implode(', ', $new_pages);
		}
		return $installation_page;
	}
}
