<?php

namespace App\Services;

if (!class_exists('WP_List_Table')) {
	require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

class CookieOptTagManagementListTable extends \WP_List_Table
{
	public $service;
	public function __construct()
	{
		parent::__construct([
			'singular' => 'item',
			'plural' => 'items',
			'ajax' => false,
			'screen' => 'toplevel_page_membership-demo',
		]);

		$this->service = new CookieOptTagManagementService();
	}

	public function get_columns()
	{
		$columns = [
			'cb' => '<input type="checkbox" />',
			'name_tag_management' => esc_html__('Tag Name', 'cookie-opt'),
			'tag' => esc_html__('HTML Tag', 'cookie-opt'),
			'position' => esc_html__('Position Setting', 'cookie-opt'),
			'installation_page' => esc_html__('Tag Installation Page', 'cookie-opt'),
			'active' => esc_html__('Status', 'cookie-opt'),
			'created_at' => esc_html__('Registration Date', 'cookie-opt'),
		];
		return $columns;
	}

	public function prepare_items()
	{
		//Search
		$search_term = isset($_REQUEST['s']) ? sanitize_text_field($_REQUEST['s']) : false; //phpcs:ignore WordPress.Security
		$args = [
			'search' => '*' . $search_term . '*',
			'search_columns' => [
				'name',
				'tag',
				'position',
				'installation_page',
				'status',
				'created_at',
			],
		];

		//Get Data
		if ($search_term == false) {
			$data = $this->service->get();
		} else {
			$data = $this->service->get($search_term);
		}

		//Prepare for Pagination
		$per_page = $this->get_items_per_page('items_per_page', 5);
		$current_page = $this->get_pagenum();
		$total_items = count($data);

		//Sort
		usort($data, [$this, 'usort_reorder']);

		//Pagination
		$this->set_pagination_args([
			'total_items' => $total_items,
			'per_page' => $per_page,
			'total_pages' => ceil($total_items / $per_page),
		]);

		// Extract data for current page
		$this->items = array_slice(
			$data,
			($current_page - 1) * $per_page,
			$per_page
		);
	}

	public function column_default($item, $column_name)
	{
		// echo"<pre>";print_r($item);die;
		switch ($column_name) {
			case 'cb':
			case 'name_tag_management':
			case 'tag':
			case 'position':
			case 'installation_page':
			case 'active':
			case 'created_at':
				return $item[$column_name];
			default:
				return '';
		}
	}
	public function column_cb($item)
	{
		return sprintf(
			'<input type="checkbox" name="element[]" value="%s" />',
			$item['id']
		);
	}
	public function column_name_tag_management($item)
	{
		$nds_edit = wp_create_nonce('tag_action');
		$actions = [
			'edit' => sprintf(
				'<a href="?page=%s&action=%s&id=%s&tag_nonce=%s">' .
				__('Edit', 'cookie-opt') .
				'</a>',
				$_REQUEST['page'], //phpcs:ignore WordPress.Security
				'edit',
				$item['id'],
				$nds_edit
			), //phpcs:ignore WordPress.Security
			'delete' => sprintf(
				'<a href="?page=%s&action=%s&id=%s&tag_nonce=%s">' .
				__('Delete', 'cookie-opt') .
				'</a>',
				$_REQUEST['page'], //phpcs:ignore WordPress.Security
				'delete',
				$item['id'],
				$nds_edit
			), //phpcs:ignore WordPress.Security
		];

		return sprintf(
			'%1$s %2$s',
			$item['name_tag_management'],
			$this->row_actions($actions)
		);
	}

	public function column_tag($item)
	{
		$tag = $item['tag'];
		return sprintf('%s', (string) $tag);
	}

	public function column_position($item)
	{
		$position = $item['position'] == 0 ? '<head>' : '<body>';
		return sprintf('%s', htmlspecialchars($position));
	}

	public function column_active($item)
	{
		$status =
			$item['active'] == 0
			? esc_html__('Active', 'cookie-opt')
			: esc_html__('Passive', 'cookie-opt');
		return sprintf('%s', $status);
	}

	public function column_installation_page($item)
	{
		$installation_page = $this->service->render_installation_page(
			$item['installation_page']
		);
		return sprintf('%s', $installation_page);
	}

	public function column_created_at($item)
	{
		return gmdate('Y-m-d', strtotime($item['created_at']));
	}

	protected function get_sortable_columns()
	{
		$sortable_columns = [
			'name_tag_management' => ['name_tag_management', true],
			'tag' => ['tag', true],
			'installation_page' => ['installation_page', true],
			'created_at' => ['created_at', true],
			'position' => ['position', true],
			'active' => ['active', true],
		];
		return $sortable_columns;
	}

	public function usort_reorder($a, $b)
	{
		// If no sort, default to user_login
		$orderby = !empty($_GET['orderby']) ? $_GET['orderby'] : 'name_tag_management'; //phpcs:ignore WordPress.Security

		// If no order, default to asc
		$order = !empty($_GET['order']) ? $_GET['order'] : 'asc'; //phpcs:ignore WordPress.Security

		// Determine sort order
		$result = strcmp($a[$orderby], $b[$orderby]);

		// Send final sort direction to usort
		return $order === 'asc' ? $result : -$result;
	}
}
