<?php

namespace App\Services;

class CookieOptPublishSettingsService
{
	public function cookie_opt_schedule_daily_once($schedule_time)
	{
		wp_clear_scheduled_hook('opt_cookie_id_check_daily_event');
		if (function_exists('wp_get_scheduled_event')) {
			$evt = wp_get_scheduled_event('cookie_opt_check_daily_event');
			if ($evt) return true; // had
		} else {
			if (wp_next_scheduled('cookie_opt_check_daily_event')) return true; //had
		}

		wp_schedule_event($schedule_time, 'daily', 'cookie_opt_check_daily_event');
		return false;
	}

	public function cookie_opt_reschedule_daily($schedule_time)
	{
		while ($ts = wp_next_scheduled('cookie_opt_check_daily_event')) {
			wp_unschedule_event($ts, 'cookie_opt_check_daily_event');
		}
		wp_schedule_event($schedule_time, 'daily', 'cookie_opt_check_daily_event');
	}
}
