<?php

namespace App\Services;

use App\Services\BaseService\CookieOptBaseService;

class CookieOptPostService extends CookieOptBaseService
{
	public $posts;

	public function getTable()
	{
		return 'posts';
	}

	public function getAllPage()
	{
		global $wpdb;
		$where = [
			'page',
			'publish'
		];
		$items = $wpdb->get_results($wpdb->prepare("SELECT * FROM {$this->table} WHERE post_type = %s AND post_status = %s", $where[0],  $where[1])); // phpcs:ignore WordPress.DB
		return $items;
	}

	public function findPage($id)
	{
		global $wpdb;
		$item = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$this->table} WHERE ID = %d AND post_type = %s AND post_status = %s", $id, 'page', 'publish')); // phpcs:ignore WordPress.DB
		return $item;
	}

	public function loadAllPage()
	{
		global $wpdb;
		$items = $wpdb->get_results($wpdb->prepare("SELECT ID, post_title FROM {$this->table} WHERE post_type = %s AND post_status = %s", 'page', 'publish')); // phpcs:ignore WordPress.DB
		return $items;
	}

	/**
	 * Return link page + preview link page
	 *
	 * @return array [page_id][edit_link, preview_link]
	 */
	public function getLinksPage()
	{
		global $wpdb;
		$items = $wpdb->get_results($wpdb->prepare("SELECT ID, post_title FROM {$this->table} WHERE post_type = %s AND post_status = %s", 'page','publish')); // phpcs:ignore WordPress.DB

		foreach ($items as $page) {
			$data[$page->ID]['edit'] = get_edit_post_link($page->ID);
			$data[$page->ID]['preview'] = get_preview_post_link($page->ID);
		}

		return $data ?? [];
	}
}
