<?php

namespace App\Services;

use App\Services\BaseService\CookieOptBaseService;
use App\Tables\CookieOptCookieListTable;
use App\Services\CookieOptLanguagesService;

class CookieOptPolicyServices extends CookieOptBaseService
{
	const ARRAY_CODE_CATEGORY = [
		1 => 'strictly',
		2 => 'performance',
		3 => 'functionality',
		4 => 'social',
	];

	public $category_list = [
		1 => [],
		2 => [],
		3 => [],
		4 => []
	];

	public function getTable()
	{
		return 'cookie_opt_cookie_list';
	}

	public function getDataCategory($category)
	{
		$data = [];
		foreach ($category as $key => $value) {
			$data[$key]['id'] = $value['id'];
			$data[$key]['code'] = self::ARRAY_CODE_CATEGORY[$value['id']];
			$data[$key]['name'] = json_decode($value['name'], true);
			$data[$key]['description'] = json_decode($value['description'], true);
		}
		return $data;
	}

	public function getDefaultLanguage()
	{
		global $wpdb;
		$table_CookieOptBanner = $wpdb->prefix . 'cookie_opt_banner';
		$items = $wpdb->get_row($wpdb->prepare("SELECT `default_language` FROM {$table_CookieOptBanner} WHERE status = %d", 1), ARRAY_A); // phpcs:ignore WordPress.DB
		$table_cookie_opt_category = $wpdb->prefix . 'cookie_opt_cookie_category';
		$itemCategory = $wpdb->get_results("SELECT id FROM {$table_cookie_opt_category}", ARRAY_A); // phpcs:ignore WordPress.DB
		$listID = wp_list_pluck($itemCategory, 'id');

		return ['default_language' => $items, 'id_category' => $listID];
	}

	public function addCategory($name, $description, $dataBannerAndCategory)
	{
		global $wpdb;
		$data = [];
		$default_language =
			$dataBannerAndCategory['default_language']['default_language'];
		foreach ($dataBannerAndCategory['id_category'] as $value) {
			$data[$value]['name'] = $name[$value];
			$data[$value]['description'] = $name[$value];
		}

		$table_cookie_opt_category = $wpdb->prefix . 'cookie_opt_cookie_category';
		$itemCategory = $wpdb->get_results("SELECT * FROM {$table_cookie_opt_category}", ARRAY_A); // phpcs:ignore WordPress.DB

		foreach ($itemCategory as $key => $value) {
			$itemCategory[$key]['name'] = json_decode($value['name'], true);
			$itemCategory[$key]['description'] = json_decode(
				$value['description'],
				true
			);

			$itemCategory[$key]['name'][$default_language] = $name[$value['id']];
			$itemCategory[$key]['description'][$default_language] =
				$description[$value['id']];

			$itemCategory[$key]['name'] = wp_json_encode($itemCategory[$key]['name']);
			$itemCategory[$key]['description'] = wp_json_encode(
				$itemCategory[$key]['description']
			);

			// phpcs:ignore WordPress.DB
			$wpdb->update(
				$table_cookie_opt_category,
				[
					'name' => $itemCategory[$key]['name'],
					'description' => $itemCategory[$key]['description'],
				],
				['id' => $value['id']]
			);
		}
	}

	public function addCookieList($data)
	{
		global $wpdb;
		$table_cookie_opt_CookieList = $this->table;
		$wpdb->insert($table_cookie_opt_CookieList, $data); // phpcs:ignore WordPress.DB
	}

	public function indexCookieList($search = '', $locale = null)
	{
		global $wpdb;
		$table_cookie_opt_CookieList = $this->table;
		$table_cookie_opt_Category = $wpdb->prefix . 'cookie_opt_cookie_category';
		$search_query = $search ? $wpdb->prepare(" WHERE cl.name LIKE '%%%s%%' ", $wpdb->esc_like($search)) : ''; // phpcs:ignore WordPress.DB
		$items = $wpdb->get_results("SELECT cl.id,cl.categoryID AS category_id,cl.name,cl.publisher,cat.name AS category_name, cl.description FROM {$table_cookie_opt_CookieList} AS cl JOIN {$table_cookie_opt_Category} AS cat ON cl.categoryID = cat.id  ORDER BY cl.id", ARRAY_A); // phpcs:ignore WordPress.DB

		$translations = ['category_name'];

		foreach ($items as $key => $value) {
			foreach ($translations as $translation) {
				$decodedValue = json_decode($value[$translation], true);
				$items[$key][$translation] = $decodedValue[$locale] ?? '';
			}
		}
		return $items;
	}

	public function editCookieList($data, $id)
	{
		global $wpdb;
		// phpcs:ignore WordPress.DB
		$wpdb->update(
			$this->table,
			[
				'name' => $data['name'],
				'categoryID' => $data['categoryID'],
				'description' => $data['description'],
			],
			['id' => $id]
		);
	}

	public function showEditByEdit($id)
	{
		global $wpdb;
		$table_cookie_cookie_list = $wpdb->prefix . 'cookie_opt_cookie_list';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$table_cookie_cookie_list} WHERE id = %s", $id)); // phpcs:ignore WordPress.DB
		return $result;
	}

	public function deleteCookieList($id)
	{
		global $wpdb;
		$wpdb->delete($this->table, ['id' => $id]); // phpcs:ignore WordPress.DB
	}

	public function deleteManyCookieList($ids)
	{
		global $wpdb;
		foreach ($ids as $id) {
			$wpdb->delete($this->table, ['id' => $id]); // phpcs:ignore WordPress.DB
		}
	}

	public function getDataForRender()
	{
		global $wpdb;
		$table_cookie_cookie_list = $wpdb->prefix . 'cookie_opt_cookie_list';

		$results = $wpdb->get_results("SELECT categoryID, JSON_ARRAYAGG(JSON_OBJECT('id', id,'name', name, 'description', description, 'publisher', publisher)) as item_details FROM {$table_cookie_cookie_list} GROUP BY categoryID ORDER BY categoryID"); // phpcs:ignore WordPress.DB

		foreach ($results as $row) {
			// $category[$row->categoryID] = $row->categoryID;
			if (array_key_exists($row->categoryID, $this->category_list)){
				$this->category_list[$row->categoryID] = json_decode($row->item_details, true);
			}
		}

		return $this->category_list;
	}

	public function getCookieListTable()
	{
		$cookie_list_table = new CookieOptCookieListTable();

		// Fetch, prepare, sort, and filter our data.
		$cookie_list_table->prepare_items();

		return $cookie_list_table;
	}

	public function renderTextList($setLanguage, $nameCategory)
	{
		if ($setLanguage == 'ja') {
			return '当社ウェブサイトで使用している「' .
				$nameCategory .
				'」は下記の通りです。';
		}
		return 'The ' . "$nameCategory" . ' used on our website are as follows';
	}

	public function renderTextLink($setLanguage)
	{
		$link = [
			'Firefox' =>
				'https://support.mozilla.org/ja/kb/enhanced-tracking-protection-firefox-desktop',
			'Chrome' => 'https://support.google.com/chrome/answer/95647?hl=ja',
			'Explorer' =>
				'https://support.microsoft.com/ja-jp/help/17442/windows-internet-explorer-delete-manage-cookies',
			'Mac-Safari-1' =>
				'https://support.apple.com/ja-jp/guide/safari/ibrw1069/mac'
		];
		if ($setLanguage == 'ja') {
			return [
				"Firefoxの「プライベートブラウジング」設定およびCookie設定の管理に関する詳細は<a href='" . $link['Firefox'] . "'>こちら</a>",
				"Chromeの「シークレットモード」設定およびCookie設定の管理に関する詳細は<a href='" . $link['Chrome'] . "'>こちら</a>",
				"Internet Explorerの「InPrivate」設定およびCookie設定の管理に関する詳細は<a href='" . $link['Explorer'] . "'>こちら</a>",
				"Mac版Safariの「プライベートブラウジング」設定およびCookie設定の管理に関する詳細は<a href='" . $link['Mac-Safari-1'] ."'>こちら</a>",
			];
		}
		return [
			"For more information about Firefox's Private Browsing settings and cookie management, click <a href='" . $link['Firefox'] . "'>here</a>.",
			"For more information about Chrome's Incognito Mode settings and cookie management, click <a href='" . $link['Chrome'] . "'>here</a>.",
			"For more information about Internet Explorer's InPrivate settings and cookie management, click <a href='" . $link['Explorer'] . "'>here</a>.",
			"For more information about Safari for Mac's Private Browsing settings and cookie management, click <a href='" . $link['Mac-Safari-1'] . "'>here</a>.",
		];
		;
	}

	public function renderPolicy($data, $default_language)
	{
		$setLanguage = 'def';
		if ($default_language == 'ja') {
			$setLanguage = 'ja';
		}
		$textLink = $this->renderTextLink($setLanguage);
		$textOther = [
			'def' => [
				'what_cookie' => 'What is a cookie?',
				'our_website' => 'Our website uses some of the following cookies.',
				'title-cookie' => 'A cookie is a function that stores information from when you browse a website into the web browser you used.
			There are two types of cookies: "session cookies," which are temporarily stored only while viewing the website, and
			"persistent cookies," which are stored until their expiration date or until deleted by the user, even after viewing the website.
			They are used to improve the usability of the website.
			Visitors to our website must agree to our use of cookies in accordance with this cookie policy in order to use our website.',
				'page_cookies' => 'About the cookies used on our website',
				'necessary_cookies_title' => 'The "Essential Cookies" used on our website are as follows.',
				'necessary_cookies_name' => 'Essential Cookies',
				'necessary_cookies_des' => 'Essential cookies are indispensable for users to freely browse this website and use its functions.',
				'necessary_cookies_no_use' => 'Our website does not use "Essential Cookies."',
				'performance_cookies_title' => 'The "Performance Cookies" used on our website are as follows.',
				'performance_cookies_name' => 'Performance Cookies',
				'performance_cookies_des' => 'Performance cookies collect information about how our website is used, such as the most frequently visited pages.
			The collected data is used to optimize the website and make user interactions easier.
			This category also includes cookies used to notify affiliates when a user accesses our website via an affiliate site and makes a purchase or uses a service.
			These cookies do not collect personally identifiable information. All collected information is aggregated and remains anonymous.',
				'performance_cookies_no_use' => 'Our website does not use "Performance Cookies."',
				'functionality_cookies_title' => 'The "Functionality Cookies" used on our website are as follows.',
				'functionality_cookies_name' => 'Functionality Cookies',
				'functionality_cookies_des' => 'Functionality cookies allow the website to remember user choices while browsing.
			For example, we may store a user’s geographic location to display the appropriate regional website, or save settings such as text size, font, and other customizable elements.
			These cookies may also remember viewed products or videos to avoid repetitive selections.
			These cookies do not collect information that identifies individuals, nor can they track user behavior on other websites.',
				'functionality_cookies_no_use' => 'Our website does not use "Functionality Cookies."',
				'social_media_cookies_title' => 'The "Social Media Cookies" used on our website are as follows.',
				'social_media_cookies_name' => 'Social Media Cookies',
				'social_media_cookies_des' => 'Social media cookies are used when sharing information via social media buttons like "Like,"
			when linking your account while visiting our website, or when interacting with our website content on social networks such as Facebook or Twitter.
			Social networks record user behavior related to the above.
			Information collected by these cookies may be used for targeting and advertising purposes.',
				'social_media_cookies_no_use' => 'Our website does not use "Social Media Cookies."',
				'use_cookie' => 'Cookies in Use',
				'manage-cookies' => 'How to Manage Cookies',
				'text-1-manage-cookies' => 'To block cookies or display a warning when cookies are sent, please change your browser settings.
			These procedures vary depending on the browser.
			To manage cookie usage on our website, refer to your browser’s help section.
			Blocking cookies may restrict or prevent access to some or all functions or content of our website.
			We reserve the right to revise this cookie policy without notice.
			Any changes to the cookie policy will become effective immediately once posted on our website.',
				'disable-cookies' => 'How to Disable Cookies',
				'text-1-disable-cookies' => 'You can manage cookie usage in individual browsers.
			Even if cookies are not enabled or are later disabled, you can continue using our website,
			but some functions or usage within the site may be limited.
			Typically, cookie usage can be enabled or later disabled using your browser’s built-in features.',
				'text-2-disable-cookies' => 'How to manage cookie settings from your browser:',
				'cookie_name_title' => 'Cookie Name',
				'cookie_publisher_title' => 'Name / Company / Service Name',
				'cookie_description' => 'Purpose of Use',
			],

			'ja' => [
				'what_cookie' => 'cookie とは',
				'our_website' => '当社ウェブサイトでは、以下のcookieの一部を使用いたします。',
				'title-cookie' => 'cookieとは、ウェブサイトをご覧になった際の情報を、使用されたウェブブラウザに記憶させる機能です。
				cookieには、「セッションcookie」：ウェブサイトを閲覧している期間のみ一時的に保存されるcookie、
				「パーシステントcookie」：ウェブサイト閲覧後も有効期限までもしくは閲覧者が削除するまで保存されるcookieがあり、ウェブサイトの利便性向上を目的に使用されます。
				当社ウェブサイト訪問者は、当社ウェブサイトを使用する場合、当社が、このcookiepolicyに従って、cookieを使用することに同意いただく必要があります。',
				'page_cookies' => '当社ウェブサイトで使用するcookieについて',
				'necessary_cookies_title' => '当社ウェブサイトで使用している「不可欠なcookie」は下記の通りです。',
				'necessary_cookies_name' => '不可欠なcookie',
				'necessary_cookies_des' => '不可欠なcookieは、お客様がこのウェブサイトを自由に閲覧し、その機能を利用する上で欠かせないものです。',
				'necessary_cookies_no_use' => '当社ウェブサイトでは「不可欠なcookie」は使用されておりません。',
				'performance_cookies_title' => '当社ウェブサイトで使用している「パフォーマンスcookie」は下記の通りです。',
				'performance_cookies_name' => 'パフォーマンスcookie',
				'performance_cookies_des' => 'パフォーマンスcookieは、最もアクセスが多いページなど、当社のウェブサイトの利用状況についての情報を収集します。収集したデータはウェブサイトの最適化に使われ、お客様による操作をさらに簡単にします。お客様がアフィリエイトサイトからこのウェブサイトにアクセスし、さらにそこで製品を購入したりサービスを利用したことをその詳細とともにアフィリエイトに知らせるのも、このカテゴリーのCookieです。このCookieは、個人を特定できる情報を収集しません。また、収集されたすべての情報は集計されるため、匿名性が保たれます。',
				'performance_cookies_no_use' => '当社ウェブサイトでは「パフォーマンスcookie」は使用されておりません。',
				'functionality_cookies_title' => '当社ウェブサイトで使用している「機能性cookie」は下記の通りです。',
				'functionality_cookies_name' => '機能性cookie',
				'functionality_cookies_des' => '機能性cookieは、ウェブサイト閲覧時のお客様による選択を記憶できるようにします。例えば、お客様がいる国や地域に合わせたウェブサイトが自動的に表示されるように、当社がお客様の地理的な位置情報を保存する場合があります。ウェブサイト上のテキストのサイズやフォント、カスタマイズできるその他の要素などの環境設定を保存する場合もあります。選択の繰り返しを避けるために、お客様が閲覧した製品やビデオを記録するのも、このカテゴリーのCookieです。このCookieが収集した情報によって個人が特定されることはありません。また、ここ以外のウェブサイトでのお客様の行動をこのCookieが追跡することもできません。',
				'functionality_cookies_no_use' => '当社ウェブサイトでは「機能性cookie」は使用されておりません。',
				'social_media_cookies_title' => '当社ウェブサイトで使用している「ソーシャルメディアcookie」は下記の通りです。',
				'social_media_cookies_name' => 'ソーシャルメディアcookie',
				'social_media_cookies_des' => 'ソーシャルメディアcookieは、ソーシャルメディアの共有ボタンもしくは「いいね」ボタンなどを使用して情報を共有する場合、当社ウェブサイト訪問者のアカウントをリンクする場合、またはFacebook、Twitterなどのソーシャルネットワーク上において、もしくはそれを通じて当社ウェブサイト上のコンテンツと係わる場合に使用されます。ソーシャルネットワークは、当社ウェブサイト訪問者の上記の行動を記録します。これらのcookieにより収集される情報は、ターゲティングおよび広告活動に使用されることがあります。',
				'social_media_cookies_no_use' => '当社ウェブサイトでは「ソーシャルメディアcookie」は使用されておりません。',
				'use_cookie' => '使用Cookie',
				'manage-cookies' => 'cookieの管理方法',
				'text-1-manage-cookies' => "cookieをブロックしたり、cookieが送信された際に警告を表示する場合は、ブラウザの設定をご変更ください。
				その手順はブラウザによって異なります。当社ウェブサイトでのcookie使用を管理する場合は、ブラウザのヘルプ画面をご覧ください。
				cookieをブロックすることにより、当社ウェブサイトの一部または全部の機能やコンテンツ等にアクセス・使用することができなくなる場合があります。
				当社は、このcookiepolicyを予告なく改定することができるものとします。
				Cookiepolicyに関する変更は、変更後の内容が当社ウェブサイトに掲載された時点で即時に有効となります。",
				'disable-cookies' => 'Cookieを無効にする方法',
				'text-1-disable-cookies' => '個別のブラウザでCookieの使用を管理することができます。
				Cookieを有効化しない、もしくは後でCookieを無効にした場合も、当社ウェブサイトを引き続きご利用いただけますが、ウェブサイトの一部機能またはサイト内のご利用が制限される場合があります。
				通常、ご利用のウェブブラウザに搭載されている機能によって、Cookieの使用を有効化または後で無効化することができます。',
				'text-2-disable-cookies' => 'ご利用のブラウザからCookie設定を管理する方法：',
				'cookie_name_title' => 'cookie名',
				'cookie_publisher_title' => '氏名・会社名・サービス名',
				'cookie_description' => '利用目的',
			],
		];
		ob_start();
		include COOKIE_OPT_PATH . '/templates/cookie_policy/cookie-policy-page-for-render.php';
		return ob_get_clean();
	}

	public function storePolicyPage()
	{
        $languages_service = new CookieOptLanguagesService();

		$dataRender = $this->getDataForRender();
		$resByIndex = $languages_service->getLanguagesByStatus();
		$html = $this->renderPolicy($dataRender, $resByIndex->default_language);

		$old_page_id = get_option('wp_page_for_privacy_policy');
		if (!empty($old_page_id)) {
			wp_delete_post($old_page_id, true);
		}

		$new_page = array(
			'post_title'    => 'Cookie Policy',
			'post_content'  =>  $html,
			'post_status'   => 'publish',
			'post_type'     => 'page',
			'post_name' => 'cookie-policy'
		);
		// Tạo trang mới
		$new_page_id = wp_insert_post($new_page);
		update_option('wp_page_for_privacy_policy', $new_page_id);
		return true;
    }
}
