<?php

namespace App\Services;

use App\Services\BaseService\CookieOptBaseService;

class CookieOptOptionService extends CookieOptBaseService
{
	public function getTable()
	{
		return 'options';
	}
	public function getOption_Opt_Id()
	{
		global $wpdb;
		$items = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$this->table} WHERE option_name = %s", 'cookie_opt_id')); // phpcs:ignore WordPress.DB
		return $items;
	}
	public function getOption_Opt_Linkage()
	{
		global $wpdb;
		$items = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$this->table} WHERE option_name = %s", 'cookie_opt_linkage')); // phpcs:ignore WordPress.DB
		return $items;
	}
	public function editOption_Opt_Id($post)
	{
		global $wpdb;
		$option = $this->getOption_Opt_Id();

		// phpcs:ignore WordPress.DB
		$wpdb->update(
			$this->table,
			[
				'option_value' => $post['option_value'],
			],
			[
				'option_id' => $option->option_id,
			]
		);
	}
	public function editOption_Opt_linkage($post)
	{
		global $wpdb;
		$option = $this->getOption_Opt_Linkage();

		// phpcs:ignore WordPress.DB
		$wpdb->update(
			$this->table,
			[
				'option_value' => $post['option_value'],
			],
			[
				'option_id' => $option->option_id,
			]
		);
	}
}
