<?php

namespace App\Services;

use App\Services\BaseService\CookieOptBaseService;

class CookieOptLanguagesService extends CookieOptBaseService
{
	const STATUS_ACT = 1;
	const CODE_LANG = [
		'aa' => 'Afar',
		'ab' => 'Abkhazian',
		'af' => 'Afrikaans',
		'ak' => 'Akan',
		'sq' => 'Albanian',
		'am' => 'Amharic',
		'ar' => 'Arabic',
		'an' => 'Aragonese',
		'hy' => 'Armenian',
		'as' => 'Assamese',
		'av' => 'Avaric',
		'ae' => 'Avestan',
		'ay' => 'Aymara',
		'az' => 'Azerbaijani',
		'ba' => 'Bashkir',
		'bm' => 'Bambara',
		'eu' => 'Basque',
		'be' => 'Belarusian',
		'bn' => 'Bengali',
		'bh' => 'Bihari',
		'bi' => 'Bislama',
		'bs' => 'Bosnian',
		'br' => 'Breton',
		'bg' => 'Bulgarian',
		'my' => 'Burmese',
		'ca' => 'Catalan; Valencian',
		'ch' => 'Chamorro',
		'ce' => 'Chechen',
		'zh-cn' => 'Chinese (Simplified)',
		'zh-tw' => 'Chinese (Traditional)',
		'cu' =>
			'Church Slavic; Old Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic',
		'cv' => 'Chuvash',
		'kw' => 'Cornish',
		'co' => 'Corsican',
		'cr' => 'Cree',
		'cs' => 'Czech',
		'da' => 'Danish',
		'dv' => 'Divehi; Dhivehi; Maldivian',
		'nl' => 'Dutch; Flemish',
		'dz' => 'Dzongkha',
		'en' => 'English',
		'eo' => 'Esperanto',
		'et' => 'Estonian',
		'ee' => 'Ewe',
		'fo' => 'Faroese',
		'fj' => 'Fijjian',
		'fi' => 'Finnish',
		'fr' => 'French',
		'fy' => 'Western Frisian',
		'ff' => 'Fulah',
		'ka' => 'Georgian',
		'de' => 'German',
		'gd' => 'Gaelic; Scottish Gaelic',
		'ga' => 'Irish',
		'gl' => 'Galician',
		'gv' => 'Manx',
		'el' => 'Greek, Modern',
		'gn' => 'Guarani',
		'gu' => 'Gujarati',
		'ht' => 'Haitian; Haitian Creole',
		'ha' => 'Hausa',
		'he' => 'Hebrew',
		'hz' => 'Herero',
		'hi' => 'Hindi',
		'ho' => 'Hiri Motu',
		'hu' => 'Hungarian',
		'ig' => 'Igbo',
		'is' => 'Icelandic',
		'io' => 'Ido',
		'ii' => 'Sichuan Yi',
		'iu' => 'Inuktitut',
		'ie' => 'Interlingue',
		'ia' => 'Interlingua (International Auxiliary Language Association)',
		'id' => 'Indonesian',
		'ik' => 'Inupiaq',
		'it' => 'Italian',
		'jv' => 'Javanese',
		'ja' => 'Japanese',
		'kl' => 'Kalaallisut; Greenlandic',
		'kn' => 'Kannada',
		'ks' => 'Kashmiri',
		'kr' => 'Kanuri',
		'kk' => 'Kazakh',
		'km' => 'Central Khmer',
		'ki' => 'Kikuyu; Gikuyu',
		'rw' => 'Kinyarwanda',
		'ky' => 'Kirghiz; Kyrgyz',
		'kv' => 'Komi',
		'kg' => 'Kongo',
		'ko' => 'Korean',
		'kj' => 'Kuanyama; Kwanyama',
		'ku' => 'Kurdish',
		'lo' => 'Lao',
		'la' => 'Latin',
		'lv' => 'Latvian',
		'li' => 'Limburgan; Limburger; Limburgish',
		'ln' => 'Lingala',
		'lt' => 'Lithuanian',
		'lb' => 'Luxembourgish; Letzeburgesch',
		'lu' => 'Luba-Katanga',
		'lg' => 'Ganda',
		'mk' => 'Macedonian',
		'mh' => 'Marshallese',
		'ml' => 'Malayalam',
		'mi' => 'Maori',
		'mr' => 'Marathi',
		'ms' => 'Malay',
		'mg' => 'Malagasy',
		'mt' => 'Maltese',
		'mo' => 'Moldavian',
		'mn' => 'Mongolian',
		'na' => 'Nauru',
		'nv' => 'Navajo; Navaho',
		'nr' => 'Ndebele, South; South Ndebele',
		'nd' => 'Ndebele, North; North Ndebele',
		'ng' => 'Ndonga',
		'ne' => 'Nepali',
		'nn' => 'Norwegian Nynorsk; Nynorsk, Norwegian',
		'nb' => 'Bokmål, Norwegian, Norwegian Bokmål',
		'no' => 'Norwegian',
		'ny' => 'Chichewa; Chewa; Nyanja',
		'oc' => 'Occitan, Provençal',
		'oj' => 'Ojibwa',
		'or' => 'Oriya',
		'om' => 'Oromo',
		'os' => 'Ossetian; Ossetic',
		'pa' => 'Panjabi; Punjabi',
		'fa' => 'Persian',
		'pi' => 'Pali',
		'pl' => 'Polish',
		'pt-br' => 'Portuguese, Brazil',
		'pt' => 'Portuguese, Portugal',
		'ps' => 'Pushto',
		'qu' => 'Quechua',
		'rm' => 'Romansh',
		'ro' => 'Romanian',
		'rn' => 'Rundi',
		'ru' => 'Russian',
		'sg' => 'Sango',
		'sa' => 'Sanskrit',
		'sr' => 'Serbian',
		'hr' => 'Croatian',
		'si' => 'Sinhala; Sinhalese',
		'sk' => 'Slovak',
		'sl' => 'Slovenian',
		'se' => 'Northern Sami',
		'sm' => 'Samoan',
		'sn' => 'Shona',
		'sd' => 'Sindhi',
		'so' => 'Somali',
		'st' => 'Sotho, Southern',
		'es' => 'Spanish; Castilian',
		'sc' => 'Sardinian',
		'ss' => 'Swati',
		'su' => 'Sundanese',
		'sw' => 'Swahili',
		'sv' => 'Swedish',
		'ty' => 'Tahitian',
		'ta' => 'Tamil',
		'tt' => 'Tatar',
		'te' => 'Telugu',
		'tg' => 'Tajik',
		'tl' => 'Tagalog',
		'th' => 'Thai',
		'bo' => 'Tibetan',
		'ti' => 'Tigrinya',
		'to' => 'Tonga (Tonga Islands)',
		'tn' => 'Tswana',
		'ts' => 'Tsonga',
		'tk' => 'Turkmen',
		'tr' => 'Turkish',
		'tw' => 'Twi',
		'ug' => 'Uighur; Uyghur',
		'uk' => 'Ukrainian',
		'ur' => 'Urdu',
		'uz' => 'Uzbek',
		've' => 'Venda',
		'vi' => 'Vietnamese',
		'vo' => 'Volapük',
		'cy' => 'Welsh',
		'wa' => 'Walloon',
		'wo' => 'Wolof',
		'xh' => 'Xhosa',
		'yi' => 'Yiddish',
		'yo' => 'Yoruba',
		'za' => 'Zhuang; Chuang',
		'zu' => 'Zulu',
	];

	public function getTable()
	{
		return 'cookie_opt_banner';
	}
	public function getLanguagesByStatus()
	{
		global $wpdb;
		$items = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$this->table} Where status = %d", 1)); // phpcs:ignore WordPress.DB
		return $items;
	}
	public function getBanner()
	{
		global $wpdb;
		$items = $wpdb->get_results("SELECT * FROM {$this->table}", ARRAY_A); // phpcs:ignore WordPress.DB
		return $items;
	}
	public function updateBannerById($data, $id)
	{
		$jsonData = wp_json_encode($data);
		global $wpdb;
		$wpdb->update($this->table, ['contents' => $jsonData], ['id' => $id]); // phpcs:ignore WordPress.DB
	}
	public function updateBannerByStatus($data)
	{
		$jsonData = wp_json_encode($data);
		global $wpdb;
		$wpdb->update($this->table, ['contents' => $jsonData], ['status' => self::STATUS_ACT]); // phpcs:ignore WordPress.DB
	}
	public function updateBannerDefault($code, $id)
	{
		global $wpdb;
		$wpdb->update($this->table, ['default_language' => $code], ['id' => $id]); // phpcs:ignore WordPress.DB
	}
	public function deleteLanguages($id)
	{
		global $wpdb;
		$wpdb->update($this->table, ['status' => 0], ['language' => $id]); // phpcs:ignore WordPress.DB
	}
	public function updateCategories($categories_name, $key)
	{
		global $wpdb;
		$table_category = $wpdb->prefix . 'cookie_opt_cookie_category';
		$wpdb->update( // phpcs:ignore WordPress.DB
			$table_category,
			['name' => wp_json_encode($categories_name)],
			['id' => $key]
		);
	}
	public function handle_add_languages($post, $struct, $data_array)
	{
		$data = [];
		foreach ($data_array as $key => $value) {
			$content = json_decode($value['contents'], true);
			$keys_content  = array_keys($content);
			foreach ($post as $value_language) {
				if (empty($data)) {
					if (!in_array($value_language, $keys_content)) {
						$data[$value_language] = $struct;
					}
				} else {
					$key_new = array_keys($data);
					if (!in_array($value_language, $keys_content) && !in_array($value_language, $key_new)) {
						$data[$value_language] = $struct;
					}
				}
			}
			if (!empty($data)) {
				foreach ($data as $key_data => &$value_data) {
					if ($value["regulation"] == 'ja') {
						$value_data['customize'] = array_fill_keys(
							['title', 'description', 'always_active', 'here', 'button_save'], 
							''
						);
					}	
					$content[$key_data] = $value_data;
				};
				unset($value_data);
				$this->updateBannerById($content, $value['id']);
			}
		}
	}

	public function getCategory()
	{
		global $wpdb;
		$table_category = $wpdb->prefix . 'cookie_opt_cookie_category';
		$items = $wpdb->get_results("SELECT * FROM {$table_category}", ARRAY_A); // phpcs:ignore WordPress.DB
		return $items;
	}
	public function handle_add_category($post, $struct, $dataArray)
	{
		foreach ($dataArray as $key => $value) {
			$content_name = json_decode($value['name'], true);
			$content_description = json_decode($value['description'], true);

			$size_array_name = count($content_name);
			$size_array_description = count($content_description);

			$keys_content_name  = array_keys($content_name);
			$keys_content_description  = array_keys($content_description);

			foreach ($post as $value_language) {
				if (!in_array($value_language, $keys_content_name) && !in_array($value_language, $keys_content_description)) {
					$content_name[$value_language] = $struct['name'][$value['id']];
					$content_description[$value_language] = $struct['description'][$value['id']];
				}
			}
			if($size_array_name !== count($content_name) && $size_array_description !== count($content_description)){
				$json_data_name = wp_json_encode($content_name);
				$json_data_description = wp_json_encode($content_description);
				global $wpdb;
				$table_category = $wpdb->prefix . "cookie_opt_cookie_category";
				// phpcs:ignore WordPress.DB
				$wpdb->update($table_category, [
					'name' => $json_data_name,
					'description' => $json_data_description
				], [
					'id' => $value['id']
				]);
			}
		}
	}
}
