<?php

namespace App\Services;

use App\Services\BaseService\CookieOptBaseService;
use App\Services\CookieOptBannerService;

class CookieOptDashboardService extends CookieOptBaseService
{
	const TYPE = [
		0 => 'Skip',
		1 => 'All Consents',
		2 => 'Customize',
		3 => 'All Refuse',
		4 => 'View',
	];

	const TYPE_KEY = [
		'All_Consents' => 1,
		'Customize' => 2,
		'All_Refuse' => 3,
		'VIEW' => 4,
	];

	const TAG = [
		'active' => 0,
		'inactive' => 1,
	];

	const COOKIE_CATEGORY = [
		'Strictly Necessary Cookies',
		'Performance Cookies',
		'Functionality Cookie',
		'Social Media Cookies',
	];

	public function getTable()
	{
		return 'cookie_opt_statistics';
	}

	public function drawChart()
	{
		$statistics = CookieOptBannerService::getStatisticBanner();
		return $statistics ?? [];
	}

	public function sentDataToCompany($date)
	{
		global $wpdb;
		$items = $wpdb->get_results($wpdb->prepare("SELECT `type` , count(`type`) as sum,time,date FROM {$this->table} AS dashboard WHERE DATE(dashboard.date) = %s GROUP BY `type`", $date), ARRAY_A); // phpcs:ignore WordPress.DB
		return $items;
	}

	public function updateDataEveryDay($date)
	{
		global $wpdb;
		$items = $wpdb->get_results($wpdb->prepare("SELECT id FROM {$this->table} as dashboard WHERE DATE(dashboard.date) = %s", $date), ARRAY_A); // phpcs:ignore WordPress.DB
		if (!empty($items)) {
			// Mảng điều kiện WHERE IN
			$ids = wp_list_pluck($items, 'id');
			// Chuyển đổi mảng $ids thành chuỗi dạng ('1', '2', '3')
			$placeholders = implode(',', array_map('absint', $ids));
			$wpdb->query($wpdb->prepare("UPDATE {$this->table} SET `date` = NULL WHERE id IN (%s)", $placeholders)); // phpcs:ignore WordPress.DB
		}
	}

	public function data30DayDelete($date)
	{
		global $wpdb;
		$result = $wpdb->query($wpdb->prepare("DELETE FROM {$this->table} as dashboard WHERE DATE(dashboard.time) <= %s", $date)); // phpcs:ignore WordPress.DB
		if ($result === false) {
			error_log($wpdb->last_error); // phpcs:ignore WordPress.PHP
		}
	}

	public function dataTag()
	{
		global $wpdb;
		$table_tag_management = $wpdb->prefix . 'cookie_opt_tag_management';
		$items = $wpdb->get_results("SELECT active, COUNT(active) AS count FROM {$table_tag_management} GROUP BY active", ARRAY_A); // phpcs:ignore WordPress.DB
		return $items;
	}

	public function handleCookie($cookie_category)
	{
		$count = 0;
		if (isset($cookie_category['cookie_category'])) {
			$count = count($cookie_category['cookie_category']);
			if ($count == 3) {
				return self::TYPE_KEY['All_Consents'];
			}
			return self::TYPE_KEY['Customize'];
		}
		return self::TYPE_KEY['All_Refuse'];
	}

	public function addStatistics($type)
	{
		global $wpdb;

		// phpcs:ignore WordPress.DB
		$wpdb->insert($this->table, [
			'type' => $type,
			'date' => current_datetime()->format('Y-m-d H:i:s'),
		]);
	}

	public function dataStatistical()
	{
		$statistics = CookieOptBannerService::getStatisticBanner() ?? [];
		$tags = $this->dataTag();

		$array_action = array_map('intval', [
			$statistics[self::TYPE_KEY['All_Consents']] ?? 0,
			$statistics[self::TYPE_KEY['All_Refuse']] ?? 0,
			$statistics[self::TYPE_KEY['Customize']] ?? 0
		]);

		$sum_action = array_sum($array_action);

		$data_statistics = [
			[
				'type' => self::TYPE_KEY['All_Consents'],
				'count' => $statistics[self::TYPE_KEY['All_Consents']],
			],
			[
				'type' => self::TYPE_KEY['All_Refuse'],
				'count' => $statistics[self::TYPE_KEY['All_Refuse']] ,
			],
			[
				'type' => self::TYPE_KEY['Customize'],
				'count' => $statistics[self::TYPE_KEY['Customize']],
			],
			[
				'type' => self::TYPE_KEY['VIEW'],
				'count' => $statistics[self::TYPE_KEY['VIEW']],
			],
		];

		$sum_tag = 0;
		$tag_active = 0;
		if (!empty($tags)) {
			foreach ($tags as $tag) {
				$sum_tag += $tag['count'] ?? 0;
				if (($tag['active'] ?? null) === CookieOptDashboardService::TAG['active']) {
					$tag_active = $tag['count'] ?? 0;
				}
			}
		}

		return [
			'view' => $statistics[self::TYPE_KEY['VIEW']],
			'sum_action' => $sum_action,
			'statistics' => $data_statistics,
			'tags' => $tags,
			'sum_statistics' => $statistics[self::TYPE_KEY['VIEW']],
			'sum_tag' => $sum_tag,
			'tag_active' => $tag_active,
		];
	}
}
