<?php

namespace App\Services;

use App\Services\BaseService\CookieOptBaseService;

class CookieOptCookieCategoryService extends CookieOptBaseService
{
	const CATEGORY_LIST = [
		'0' => 'necessary_cookies',
		'1' => 'performance_cookies',
		'2' => 'functionality_cookies',
		'3' => 'social_media_cookies',
	];

	public function getTable()
	{
		return 'cookie_opt_cookie_category';
	}

	public function getNameAllCategory()
	{
		global $wpdb;
		$results = $wpdb->get_results("SELECT * FROM {$this->table}", ARRAY_A); // phpcs:ignore WordPress.DB

		foreach ($results as $key => $category) {
			$data[] = json_decode($category['name'], true);
		}

		return $data;
	}
	public function getAllCategory()
	{
		global $wpdb;
		$results = $wpdb->get_row("SELECT name FROM {$this->table}", ARRAY_A); // phpcs:ignore WordPress.DB
		$list_language = array_keys(json_decode($results['name'], true));
		foreach ($list_language as $key_lang => $lang) {
			$data[$lang] = $this->getDataCategory($lang);
		}
	}
	public function getDataCategory($lang)
	{
		global $wpdb;
		$results = $wpdb->get_results("SELECT name FROM {$this->table}", ARRAY_A); // phpcs:ignore WordPress.DB
		foreach ($results as $key => $val) {
			$name = json_decode($val['name'], true);
			$data[self::CATEGORY_LIST[$key]] = $name[$lang];
		}
		return $data;
	}
}
