<?php

namespace App\Includes\FeatureManager\FeatureUser;

use App\Services\CookieOptOptionService;

abstract class CookieOptManagerBase
{
	const PACKAGE_NAME = [
		'KEY' => [
			'FREE' => 0,
			'BASIC' => 1,
			'PRO' => 2,
		],
		'VALUE' => [
			0 => 'FREE',
			1 => 'BASIC',
			2 => 'PRO',
		],
	];
	protected $factoryMethod;
	protected function __construct()
	{
		$this->factoryMethod = $this->factoryMethod();
	}
	abstract protected function factoryMethod(): CookieOptInterfacePackage;

	public function checkSpLanguages(): string
	{
		return $this->factoryMethod->getSpLanguage();
	}

	public function getLanguages()
	{
		return $this->factoryMethod->getLanguage();
	}

	public function packageType()
	{
		return $this->factoryMethod->getType();
	}
	public function checkLimitPackage()
	{
		return $this->factoryMethod->checkLimitBanner();
	}
	public function getNumberLimitPackage()
	{
		return $this->factoryMethod->getNumberLimitBanner();
	}
	public function checkCurrentLimit()
	{
		return $this->factoryMethod->currentLimit();
	}
	public function getOptionBase()
	{
		$server = new CookieOptOptionService();
		return $server->getOption_Opt_Id();
	}
	public function setCreateTime($time)
	{
		return $this->factoryMethod->setCreateTime($time);
	}
	public function getCreateTime()
	{
		return $this->factoryMethod->getCreateTime();
	}
}
