<?php

namespace App\Includes\FeatureManager\FeatureUser;

use App\Services\CookieOptBannerService;

class CookieOptManager extends CookieOptManagerBase
{
	public function __construct()
	{
		parent::__construct();
	}
	public function factoryMethod(): CookieOptInterfacePackage
	{
		//call api
		if (!wp_doing_ajax()) {
			$package = $this->handel();
			switch ($package['plan']) {
				case 'FREE':
					$obj = new CookieOptFree();
					break;
				case 'BASIC':
					$obj = new CookieOptBasic();
					break;
				case 'PRO':
					$obj = new CookieOptPro();
					break;
				default:
					$obj = new CookieOptFree();
					break;
			}
			if (isset($package['created_time'])) {
				$obj->setCreateTime($package['created_time']);
			}
		} else {
			$obj = new CookieOptFree();
		}
		return $obj;
	}

	public function handel()
	{
		return CookieOptBannerService::getStatisticBanner();
	}
}
