<?php
namespace App\Includes\FeatureManager\FeatureUser;

use App\Services\CookieOptDashboardService;
use App\Services\CookieOptLanguagesService;

class CookieOptFree extends CookieIOptPackageBase implements
	CookieOptInterfacePackage
{
	private $type;
	private $limit_banner;
	private $number_limit;
	private $serverDashboard;

	public function __construct()
	{
		$this->serverLanguages = new CookieOptLanguagesService();
		$this->serverDashboard = new CookieOptDashboardService();
		$userPack = $this->getPackageUser();
		$this->type = $userPack['plan'];
		$this->limit_banner = $userPack['limit_banner'];
		$this->number_limit = $userPack['number_limit'];
		$this->sp_language = $userPack['sp_language'];
	}

	public function getNameClass()
	{
		return CookieOptFree::class;
	}
	public function getSpLanguage()
	{
		return $this->sp_language;
	}
	public function getLanguage()
	{
		$languages = $this->serverLanguages->getLanguagesByStatus();
		return $languages->default_language;
	}
	public function getType()
	{
		return $this->type;
	}
	public function checkLimitBanner()
	{
		return $this->limit_banner;
	}
	public function getNumberLimitBanner()
	{
		return $this->number_limit;
	}

	public function currentLimit()
	{
		return $this->limit_banner;
	}
}
