<?php

namespace App\Includes\FeatureManager\FeatureUser;

use App\Services\CookieOptDashboardService;
use App\Services\CookieOptLanguagesService;

class CookieOptBasic extends CookieIOptPackageBase implements
	CookieOptInterfacePackage
{
	private $type;
	private $limitBanner;
	private $number_limit;

	protected $serverDashboard;
	public function __construct()
	{
		$this->serverLanguages = new CookieOptLanguagesService();
		$this->serverDashboard = new CookieOptDashboardService();
		$userPack = $this->getPackageUser();
		$this->type = $userPack['plan'];
		$this->limitBanner = $userPack['limit_banner'];
		$this->number_limit = $userPack['number_limit'];
		$this->sp_language = $userPack['sp_language'];
	}
	public function getNameClass()
	{
		return self::class;
	}
	public function getSpLanguage()
	{
		return $this->sp_language;
	}
	public function getLanguage()
	{
		return parent::getLanguageForBasicPro();
	}
	public function getType()
	{
		return $this->type;
	}
	public function checkLimitBanner()
	{
		return $this->limitBanner;
	}
	public function getNumberLimitBanner()
	{
		return $this->number_limit;
	}
	public function currentLimit()
	{
		return $this->limitBanner;
	}
}
