<?php
namespace App\Includes\FeatureManager\FeatureUser;
use App\Services\CookieOptBannerService;

abstract class CookieIOptPackageBase
{
	protected $sp_language;
	protected $serverLanguages;
	protected $createdTime;

	protected function getLanguagesByUser()
	{
		$lang = substr(sanitize_text_field(wp_unslash($_SERVER['HTTP_ACCEPT_LANGUAGE'])), 0, 2); //phpcs:ignore WordPress.Security
		switch ($lang) {
			case 'zh':
			case 'pt':
				$lang = substr(sanitize_text_field(wp_unslash($_SERVER['HTTP_ACCEPT_LANGUAGE'])), 0, 5); //phpcs:ignore WordPress.Security
				break;
		}
		return $lang;
	}
	public function getLanguageForBasicPro()
	{
		$codeLang = $this->getLanguagesByUser();
		$banner = $this->serverLanguages->getLanguagesByStatus();

		$codeLang = strtolower($codeLang);
		if (!array_key_exists($codeLang, json_decode($banner->contents, true))) {
			return $banner->default_language;
		}
		return $codeLang;
	}
	public function setCreateTime($time)
	{
		$this->createdTime = $time;
	}
	public function getCreateTime()
	{
		return $this->createdTime;
	}
	public function getPackageUser()
	{
		return CookieOptBannerService::getStatisticBanner();
	}
}
