<?php

namespace App\Includes;

if (!defined('ABSPATH')) {
	exit();
}

use App\Services\CookiePermissionService;
use App\Services\CookieOptCookieCategoryService;
use App\Services\CookieOptBannerService;
use App\Validates\PermissionRequest;
use App\Includes\CookieOptBaseInc;
use App\Includes\FeatureManager\CookieOptFeatureManager;
use App\Includes\FeatureManager\CookieOptManager;
use App\Services\CookieOptPostService;
use App\Services\CookieOptPolicyServices;

class CookieOptPermission extends CookieOptBaseInc
{
	const BANNER_IS_CHOSEN = 1;

	public $CookiePermissionService;
	public $CookieOptCookieCategoryService;
	public $CookieOptBannerService;
	public $CookieOptPolicyService;
	public $cookie_opt_post_service;
	public $pageIndex;
	public $regulationIndex;

	public function __construct()
	{
		$this->CookiePermissionService = new CookiePermissionService();
		$this->CookieOptCookieCategoryService = new CookieOptCookieCategoryService();
		$this->CookieOptBannerService = new CookieOptBannerService();
		$this->cookie_opt_post_service = new CookieOptPostService();
		$this->CookieOptPolicyService = new CookieOptPolicyServices();

		add_action('admin_init', [$this, 'admin_hook_page']);
	}
	public function admin_hook_page()
	{
		add_action('cookie_plugin_cookie_permission_library', [$this, 'register_scripts_and_styles',]);

		add_action('wp_ajax_generate_do_not_sell_page', [$this, 'generate_do_not_sell_page',]);
		add_action('wp_ajax_nopriv_generate_do_not_sell_page', [$this, 'generate_do_not_sell_page',]);

		add_action('wp_ajax_get_cookie', [$this, 'get_cookie']);
		add_action('wp_ajax_nopriv_get_cookie', [$this, 'get_cookie']);

		add_action('wp_ajax_get_template_add_new_rule', [$this, 'get_template_add_new_rule']);
		add_action('wp_ajax_nopriv_get_template_add_new_rule', [$this, 'get_template_add_new_rule']);

		add_action('wp_ajax_get_template_add_new_rule_option_page', [$this, 'get_template_add_new_rule_option_page']);
		add_action('wp_ajax_nopriv_get_template_add_new_rule_option_page', [$this, 'get_template_add_new_rule_option_page']);

		add_action('wp_ajax_get_template_add_new_rule_option_page_type', [$this, 'get_template_add_new_rule_option_page_type']);
		add_action('wp_ajax_nopriv_get_template_add_new_rule_option_page_type', [$this, 'get_template_add_new_rule_option_page_type']);

		add_action('wp_ajax_get_template_add_new_rule_option_post_type', [$this, 'get_template_add_new_rule_option_post_type']);
		add_action('wp_ajax_nopriv_get_template_add_new_rule_option_post_type', [$this, 'get_template_add_new_rule_option_post_type']);

		add_action('wp_ajax_get_template_add_new_rule_option_user_type', [$this, 'get_template_add_new_rule_option_user_type']);
		add_action('wp_ajax_nopriv_get_template_add_new_rule_option_user_type', [$this, 'get_template_add_new_rule_option_user_type']);

		add_action('wp_ajax_get_data_setting_tab', [$this, 'get_data_setting_tab']);
		add_action('wp_ajax_nopriv_get_data_setting_tab', [$this, 'get_data_setting_tab']);

		add_action('admin_post_handle_post_permission_startup', [$this, 'handle_post_permission_startup',]);
		add_action('admin_post_handle_post_reset_data_startup', [$this, 'handle_post_reset_data_startup',]);
		add_action('admin_post_handle_post_permission_setting', [$this, 'handle_post_permission_setting',]);
		add_action('admin_post_handle_post_permission_banner_layout', [$this, 'handle_post_permission_banner_layout',]);
		add_action('admin_post_handle_post_permission_banner_customize', [$this, 'handle_post_permission_banner_customize',]);
		add_filter('wp_script_attributes', [$this, 'add_type_attribute'], 10, 1);
		// add_filter('script_loader_tag', [$this, 'load_as_ES6'], 10, 3);
	}

	public function register_scripts_and_styles($page)
	{
		if ($page == 'toplevel_page_cookie_opt') {
			$notify_cookie_scan = $this->CookiePermissionService->getNotifyCookieScanByLocale();
			//Js & Css Color Picker
			wp_enqueue_script('wp-color-picker');
			wp_enqueue_style('wp-color-picker');

			//Js Custom Script
			wp_register_script_es6(
				'cookie-startup',
				vite('resources/js/pages/cookie_startup.js'),
				['jquery'],
				VERSION,
				true
			);

			wp_localize_script('cookie-startup', 'dataCookiePermission', [
				'ajaxurl' => admin_url('admin-ajax.php'),
				'settingTabUrl' => admin_url('admin.php?page=cookie_opt&index=setting'),
				'layoutTabUrl' => admin_url('admin.php?page=cookie_opt&index=banner_layout'),
				'notifyCookieScan' => $notify_cookie_scan
			]);

			wp_enqueue_script('cookie-startup');
		}
	}

	public function add_type_attribute($attributes)
	{
		if (isset($attributes['id']) && ($attributes['id'] === 'cookie-startup-js' || $attributes['id'] === 'banner-preview-js' || $attributes['id'] === 'custom-script-cookie-opt_-js')) {
			$attributes['type'] = 'module';
		}

		return $attributes;
	}

	public function run()
	{
		$pageIndex = 'startup';
		if (
			isset($_GET['nonce_action']) &&
			!empty($_GET['nonce_action']) &&
			wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['nonce_action'])), 'action_permission') &&
			isset($_GET['index']) &&
			!empty($_GET['index'])
		) {
			if ($_GET['index'] == 'setting') {
				$pageIndex = 'setting';
			}
			if ($_GET['index'] == 'banner_layout') {
				$pageIndex = 'banner_layout';
			}
			$this->regulationIndex =
				isset($_GET['regulation']) &&
				!empty($_GET['regulation']) &&
				in_array($_GET['regulation'], ['us', 'eu', 'ja'])
				? sanitize_text_field(wp_unslash($_GET['regulation']))
				: $this->CookiePermissionService->getDefaultRegulation();
		}
		$this->pageIndex = $pageIndex;

		$this->index();
	}

	public function get_cookie()
	{
		if (
			isset($_POST['nonce_action']) &&
			!empty($_POST['nonce_action']) &&
			wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['nonce_action'])), 'ajax_scan') &&
			isset($_POST['data']) &&
			!empty($_POST['data'])
		) {
			$this->CookieOptBannerService->saveCookie($_POST['data']); //phpcs:ignore WordPress.Security
			$this->CookieOptPolicyService->storePolicyPage();
			return wp_send_json([
				'status' => 200,
			]);
		}
		return wp_send_json(
			[
				'status' => 403,
			],
			403
		);
	}

	public function get_data_setting_tab()
	{

		$regulation = sanitize_text_field(wp_unslash($_POST['regulation'])); //phpcs:ignore WordPress.Security

		$data['setting'] = $this->CookiePermissionService->getDataSettingTab($regulation);

		ob_start();
		include COOKIE_OPT_PATH . '/templates/cookie_permissions/partials/cookie_opt_setting_data_setup.php';
		$html = ob_get_clean();

		return wp_send_json([
			'status' => 200,
			'data' => wp_json_encode($html)
		]);
	}

	public function get_template_add_new_rule()
	{
		$id = isset($_POST['id']) ? sanitize_text_field(wp_unslash($_POST['id'])) : 1; //phpcs:ignore WordPress.Security
		$option_type = sanitize_text_field(wp_unslash($_POST['optionType'])); //phpcs:ignore WordPress.Security
		ob_start();
		include COOKIE_OPT_PATH . '/templates/cookie_permissions/partials/cookie_conditional_add_new_rule.php';
		$html = ob_get_clean();

		return wp_send_json([
			'status' => 200,
			'data' => wp_json_encode($html)
		]);
	}

	public function get_template_add_new_rule_option_page()
	{
		$all_pages = $this->cookie_opt_post_service->loadAllPage();
		$first_key = reset($all_pages)->ID;
		ob_start();
		foreach ($all_pages as $id => $item) {
			?>
			<option value="<?php echo esc_attr($item->ID); ?>" <?php $this->propSelected($id, $first_key) ?>><?php echo esc_html($item->post_title); ?></option>
			<?php
		}
		$html = ob_get_clean();

		return wp_send_json([
			'status' => 200,
			'data' =>  wp_json_encode($html)
		]);
	}

	public function get_template_add_new_rule_option_page_type()
	{
		ob_start();
		?>
		<option selected value="front"><?php echo esc_html__('Front Page', 'cookie-opt') ?></option>
		<option value="home"><?php echo esc_html__('Home Page', 'cookie-opt') ?></option>
		<?php
		$html = ob_get_clean();

		return wp_send_json([
			'status' => 200,
			'data' => wp_json_encode($html)
		]);
	}

	public function get_template_add_new_rule_option_post_type()
	{
		$all_post_types = get_post_types(['public' => true], 'names', 'or');
		$first_key = array_key_first($all_post_types);
		ob_start();
		foreach ($all_post_types as $key => $value) {
			?>
			<option value="<?php echo esc_attr($key); ?>" <?php $this->propSelected($key, $first_key) ?>><?php echo esc_html(ucfirst($value)); ?></option>
			<?php
		}
		$html = ob_get_clean();

		return wp_send_json([
			'status' => 200,
			'data' => wp_json_encode($html)
		]);
	}

	public function get_template_add_new_rule_option_user_type()
	{
		ob_start();
		?>
		<option selected value="login"><?php echo esc_html__('Login', 'cookie-opt') ?></option>
		<option value="guest"><?php echo esc_html__('Guest', 'cookie-opt') ?></option>
		<?php
		$html = ob_get_clean();

		return wp_send_json([
			'status' => 200,
			'data' => wp_json_encode($html)
		]);
	}

	public function generate_do_not_sell_page()
	{
		$page_id = $this->CookiePermissionService->generateDoNotSellPage();

		wp_send_json_success([
			'message' => esc_html__('Generate Successful, Please reload to update', 'cookie-opt'),
			'href' => admin_url(
				'admin.php?page=cookie_opt&index=setting&regulation=us'
			),
			'urlEditPage' => admin_url('post.php?post=' . $page_id . '&action=edit'),
		]);
		wp_die();
	}

	public function data_conditional_display()
	{
		return $this->CookiePermissionService->dataConditionalParamValue();
	}

	public function index()
	{
		if (is_null($this->regulationIndex)) {
			$this->regulationIndex = $this->CookiePermissionService->getDefaultRegulation();
		}

		$setting_tab = $this->CookiePermissionService->getDataSettingTab($this->regulationIndex);
		$banner_layout = $this->CookiePermissionService->getDataBannerLayout($this->regulationIndex);

		//Check is active
		$is_active_key = get_option('cookie_opt_banner_active');
		$is_first_active = get_option('cookie_opt_first_setting');
		return $this->view('cookie_permissions/cookie_permission', [
			'is_active_key' => $is_active_key,
			'is_first_active' => $is_first_active,
			'setting' => $setting_tab,
			'layout' => $banner_layout,
			'index' => $this->pageIndex,
			'regulationIndex' => $this->regulationIndex,
		]);
	}

	/**
	 * Handle Startup Tab Post Event
	 * To save data setting for startup tab
	 * @return void
	 */
	public function handle_post_permission_startup()
	{
		if (isset($_POST['nds_add_meta_nonce_update_banner']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['nds_add_meta_nonce_update_banner'])), 'nds_add_meta_nonce_update_banner')) {
			//Validate
			$errors = PermissionRequest::startupPageRequest();
			if ($errors->has_errors()) {
				set_transient('validate-err', $errors);
				wp_redirect(admin_url('admin.php?page=cookie_opt&index=startup&step=4'));
				die;
			}

			$nds_action_permission = isset($_POST['action_permission']) ? sanitize_text_field(wp_unslash($_POST['action_permission'])) : '';
			$regulation = sanitize_text_field(wp_unslash($_POST['coop-start__regulation'])); //phpcs:ignore WordPress.Security

			$this->CookiePermissionService->updateDataStartup($regulation, $_POST);

			set_transient('successUpdate', true);
			set_transient(
				'msg-cookie-opt',
				esc_html__('Update successfully', 'cookie-opt')
			);

			wp_redirect(
				admin_url(
					'admin.php?page=cookie_opt&index=setting&nonce_action=' .
					$nds_action_permission
				)
			);
		} else {
			wp_die('Forbidden', 'Forbidden', ['response' => 403]);
		}
	}

	/**
	 * Handles the form submission for resetting startup cookie permission data.
	 *
	 * @return void
	 */
	public function handle_post_reset_data_startup()
	{
		if (isset($_POST['nds_add_meta_nonce_reset_data_startup']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['nds_add_meta_nonce_reset_data_startup'])), 'nds_add_meta_nonce_reset_data_startup')) {
			//Validate

			$nds_action_permission = isset($_POST['action_permission']) ? sanitize_text_field(wp_unslash($_POST['action_permission'])) : '';

			$this->CookiePermissionService->resetDataStartup();

			set_transient('successUpdate', true);
			set_transient(
				'msg-cookie-opt',
				esc_html__('Update successfully', 'cookie-opt')
			);

			wp_redirect(
				admin_url(
					'admin.php?page=cookie_opt&index=startup&nonce_action=' .
					$nds_action_permission
				)
			);
		} else {
			wp_die('Forbidden', 'Forbidden', ['response' => 403]);
		}
	}

	/**
	 * Handle Setting Tab Post Event
	 * To save data setting for setting tab
	 * @return void
	 */
	public function handle_post_permission_setting()
	{
		if (
			isset($_POST['nds_add_meta_nonce_update_banner']) &&
			wp_verify_nonce(
				sanitize_text_field(wp_unslash($_POST['nds_add_meta_nonce_update_banner'])),
				'nds_add_meta_nonce_update_banner'
			)
		) {
			$regulation = sanitize_text_field(wp_unslash($_POST['coop-setting__regulation'])); //phpcs:ignore WordPress.Security
			$nonce_action = isset($_POST['action_permission']) ? sanitize_text_field(wp_unslash($_POST['action_permission'])) : '';

			//Validate
			$errors = PermissionRequest::settingPageRequest();
			if ($errors->has_errors()) {
				set_transient('validate-err', $errors);
				wp_redirect(
					admin_url(
						'admin.php?page=cookie_opt&index=setting&regulation=' . $regulation . '&nonce_action=' . $nonce_action
					)
				);
				die();
			}

			//Update data
			$this->CookiePermissionService->updateDataSetting($regulation, $_POST);

			//Init notify
			set_transient('successUpdate', true);
			set_transient(
				'msg-cookie-opt',
				esc_html__('Update successfully', 'cookie-opt')
			);

			wp_redirect(
				admin_url(
					'admin.php?page=cookie_opt&index=setting&regulation=' .
					$regulation .
					'&nonce_action=' .
					$nonce_action
				)
			);
			die;
		} else {
			wp_die('Forbidden', 'Forbidden', ['response' => 403]);
		}
	}

	/**
	 * Handle Banner layout Tab Post Event
	 * To save data setting for banner layout tab
	 * @return void
	 */
	public function handle_post_permission_banner_layout()
	{
		if (
			isset($_POST['nds_add_meta_nonce_update_banner']) &&
			wp_verify_nonce(
				sanitize_text_field(wp_unslash($_POST['nds_add_meta_nonce_update_banner'])),
				'nds_add_meta_nonce_update_banner'
			)
		) {

			//Validate
			$errors = PermissionRequest::layoutPageRequest();
			if ($errors->has_errors()) {
				set_transient('validate-err', $errors);
				wp_redirect(admin_url('admin.php?page=cookie_opt&index=banner_layout'));
				die;
			}

			$nonce_action = isset($_POST['action_permission']) ? sanitize_text_field(wp_unslash($_POST['action_permission'])) : '';
			$regulation = sanitize_text_field(wp_unslash($_POST['coop-layout__regulation'])); //phpcs:ignore WordPress.Security
			//Update data
			$this->CookiePermissionService->updateDataBannerLayout($regulation, $_POST);

			//Init notify
			set_transient('successUpdate', true);
			set_transient(
				'msg-cookie-opt',
				esc_html__('Update successfully', 'cookie-opt')
			);
			wp_redirect(
				admin_url(
					'admin.php?page=cookie_opt&index=banner_layout&regulation=' . $regulation . '&nonce_action=' . $nonce_action
				)
			);
		} else {
			wp_die('Forbidden', 'Forbidden', ['response' => 403]);
		}
	}
}
