<?php

namespace App\Includes;

// exit if accessed directly
if (!defined('ABSPATH')) {
	exit();
}

use App\Includes\CookieOptBaseInc;
use App\Services\CookieOptOptionService;
use App\Validates\OtherRequest;

/**
 * CookieOptOther class.
 *
 * @class CookieOptOther
 */
class CookieOptOther extends CookieOptBaseInc
{
	private $option_server;
	public function __construct()
	{
		$this->option_server = new CookieOptOptionService();
		add_action('admin_init', [$this, 'admin_hook_page']);
	}
	public function admin_hook_page()
	{
		add_action('admin_post_handle_add_other', [$this,'admin_post_handle_add_other']);
	}
	public function admin_post_handle_add_other()
	{
		if (
			isset($_POST['nds_add_other']) &&
			wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['nds_add_other'])), 'nds_add_other')
		) {
			$errors = OtherRequest::otherRequest($_POST);
			if ($errors->has_errors()) {
				set_transient('validate-err', $errors);
				wp_redirect(admin_url('admin.php?page=co_others'));
				die();
			}

			$option_value = sanitize_text_field(wp_unslash($_POST['other'])); //phpcs:ignore WordPress.Security 
			$this->option_server->editOption_Opt_linkage([
				'option_value' => $option_value,
			]);
			wp_redirect(admin_url('admin.php?page=co_others'));
			die();
		}
		wp_die('Forbidden', 'Forbidden', ['response' => 403]);
	}
	public function run()
	{
		$this->index();
	}
	public function index()
	{
		$option = $this->option_server->getOption_Opt_Linkage();
		$this->view('other/index', ['option' => $option]);
	}
}
