<?php

namespace App\Includes;

// exit if accessed directly
if (!defined('ABSPATH')) {
	exit();
}

use App\Services\CookieOptLanguagesService;
use App\Services\CookiePermissionService;
use App\Services\CookieOptCookieCategoryService;
use App\Includes\CookieOptBaseInc;
use App\Validates\LanguagesAddRequest;
use App\Validates\LanguagesEditRequest;

/**
 * CookieOptLanguages class.
 *
 * @class CookieOptLanguages
 */
class CookieOptLanguages extends CookieOptBaseInc
{
	public $CookiePermissionService;
	public $cookie_category_service;
	public function __construct()
	{
		$this->servicer = new CookieOptLanguagesService();
		$this->CookiePermissionService = new CookiePermissionService();
		$this->cookie_category_service = new CookieOptCookieCategoryService();
		add_action('admin_init', [$this, 'admin_hook_page']);
	}
	public function admin_hook_page()
	{
		add_action('admin_post_handle_add_languages', [
			$this,
			'handle_add_languages',
		]);
		add_action('admin_post_handle_change_languages', [
			$this,
			'handle_change_languages',
		]);
		add_action('cookie_plugin_language_library', [
			$this,
			'library_co_languages',
		]);
	}
	public function library_co_languages($page)
	{
		if ($page == 'cookie-optimizer_page_co_languages') {
			$action = sanitize_text_field(
				filter_input(INPUT_GET, 'action', FILTER_SANITIZE_STRING)
			);

			wp_register_style(
				'cookie-opt-custom-css',
				COOKIE_OPT_URL . '/public/assets/css/co_languages.css',
				[],
				VERSION
			);
			wp_enqueue_style('cookie-opt-custom-css');
			if (isset($action) && $action == 'edit') {
				//&& isset($_GET['action'])
				wp_register_script_es6(
					'cookie-opt-languages-js-custom',
					vite('resources/js/pages/languages_for_edit.js'),
					[],
					VERSION,
					true
				);
			} else {
				wp_register_script_es6(
					'cookie-opt-languages-js-custom',
					vite('resources/js/pages/co_languages.js'),
					[],
					VERSION,
					true
				);
			}
			wp_enqueue_script('cookie-opt-languages-js-custom');
			// wp_enqueue_style(
			// 	'cookie-custom-banner-css',
			// 	COOKIE_OPT_URL . '/public/assets/css/banner.css',
			// 	[],
			// 	VERSION
			// );
		}
	}
	public function add_type_attribute($attributes)
	{
		if (
			isset($attributes['id']) &&
			$attributes['id'] === 'cookie-opt-languages-js-custom-js'
		) {
			$attributes['type'] = 'module';
		}

		return $attributes;
	}

	public function run()
	{
		$this->action = 'index';
		if (
			isset($_GET['nonce_action']) &&
			!empty($_GET['nonce_action']) &&
			wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['nonce_action'])), 'action_languages')
		) {
			$this->action = isset($_GET['action']) ? sanitize_text_field(wp_unslash($_GET['action'])) : null;
			$this->param['id'] = isset($_GET['language']) ? sanitize_text_field(wp_unslash($_GET['language'])) : null;
			$this->param['verify'] = isset($_GET['verify']) ? sanitize_text_field(wp_unslash($_GET['verify'])) : null;
		}
		switch ($this->action) {
			case 'add':
				$this->create();
				break;
			case 'edit':
				if (!empty($this->param['id'])) {
					$this->edit($this->param['id']);
					break;
				}
			case 'delete':
				if (!empty($this->param['id']) && !empty($this->param['verify'])) {
					$this->delete($this->param['id'], $this->param['verify']);
					break;
				}
			case 'default':
				if (!empty($this->param['id']) && !empty($this->param['verify'])) {
					$this->setDefault($this->param['id'], $this->param['verify']);
					break;
				}
			default:
				$this->index();
				break;
		}
	}
	public function index()
	{
		$res_by_index = $this->servicer->getLanguagesByStatus();
		$content = json_decode($res_by_index->contents, true);
		$keyArray = array_keys($content);

		$array_of_banner = array_filter(
			$this->servicer::CODE_LANG,
			function ($value, $key) use ($keyArray) {
				return in_array($key, $keyArray);
			},
			ARRAY_FILTER_USE_BOTH
		);

		$this->view('languages/languages', [
			'res_by_index' => $res_by_index,
			'array_of_banner' => $array_of_banner,
		]);
	}
	public function create()
	{
		$resAll = $this->servicer::CODE_LANG;
		$res_by_index = $this->servicer->getLanguagesByStatus();
		$content = json_decode($res_by_index->contents, true);
		$keyArray = array_keys($content);

		$array_of_banner = array_filter(
			$resAll,
			function ($value, $key) use ($keyArray) {
				return in_array($key, $keyArray);
			},
			ARRAY_FILTER_USE_BOTH
		);

		$arrayKeyTaget = array_keys($array_of_banner);
		$this->view('languages/add_languages', [
			'resAll' => $resAll,
			'arrayKeyTaget' => $arrayKeyTaget,
		]);
	}
	public function delete($code, $verify)
	{
		if (wp_verify_nonce($verify, 'nds_delete_languages')) {
			$allbanner = $this->servicer->getBanner();
			foreach ($allbanner as $key => $value) {
				$content = json_decode($value['contents'], true);
				$keyArray = array_keys($content);
				if (in_array($code, $keyArray)) {
					unset($content[$code]);
					$this->servicer->updateBannerById($content, $value['id']);
					set_transient(
						'msg-cookie-opt',
						esc_html__('Deleted language successfully', 'cookie-opt')
					);
				}
			}
			wp_redirect(admin_url('admin.php?page=co_languages'));
			die();
		}
		wp_die('Forbidden', 'Forbidden', ['response' => 403]);
	}
	public function setDefault($code, $verify)
	{
		if (wp_verify_nonce($verify, 'nds_setDefault_languages')) {
			$banner = $this->servicer->getLanguagesByStatus();
			$content = json_decode($banner->contents, true);
			$keyArray = array_keys($content);
			if (in_array($code, $keyArray)) {
				$this->servicer->updateBannerDefault($code, $banner->id);
				set_transient(
					'msg-cookie-opt',
					esc_html__('Set default language successfully', 'cookie-opt')
				);
				wp_redirect(admin_url('admin.php?page=co_languages'));
				die();
			}
		}
		wp_die('Forbidden', 'Forbidden', ['response' => 403]);
	}
	public function handle_add_languages()
	{
		if (
			isset($_POST['nds_add_languages']) &&
			wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['nds_add_languages'])), 'nds_add_languages')
		) {
			$nonce_action = isset($_POST['nonce_action'])
				? sanitize_text_field(wp_unslash($_POST['nonce_action']))
				: '';
			$errors = LanguagesAddRequest::validateCategoryEdit($_POST);
			if ($errors->has_errors()) {
				set_transient('validate-err', $errors);
				wp_redirect(
					admin_url(
						'admin.php?page=co_languages&action=add&nonce_action=' .
						$nonce_action
					)
				);
				die();
			}
			$Banner = $this->servicer->getBanner();
			$Category = $this->servicer->getCategory();

			// $idPagePolicy = get_option('wp_page_for_privacy_policy');
			// $link_policy = get_permalink($idPagePolicy);
			$struct = [
				'notice' => [
					'title' => 'We value your privacy',
					'description' =>
						'We use cookies to enhance your browsing experience, serve personalized ads or content, and analyze our traffic. By clicking "Accept All", you consent to our use of cookies.',
					'buttons' => [
						'accept_button' => 'Accept All',
						'reject_button' => 'Reject All',
						'customize_button' => 'Customize',
						'privacy_policy_button' => 'Privacy Policy',
						'do_not_sell_page_button' => 'Do Not Sell Personal Information',
						'cookie_policy_button' => 'Cookie Policy',
					],
				],
				'customize' => [
					'title' => ' Customize',
					'description' => 'For more information on cookies, please click here.',
					'always_active' => 'Always Active',
					'here' => 'here.',
					'button_save' => 'Save Change',
				],
			];
			$structCategory = [
				'name' => [
					'1' => 'Strictly Necessary Cookies',
					'2' => 'Performance Cookies',
					'3' => 'Functionality Cookie',
					'4' => 'Social Media Cookies',
				],
				'description' => [
					'1' =>
						'These cookies are essential to enable you to browse around our websites and use their features.',
					'2' =>
						'These cookies collect information about how you use our websites — for instance, which pages you go to most. This data may be used to help optimize our websites and make them easier for you to navigate. These cookies are also used to let affiliates know if you came to one of our websites from an affiliate and if your visit resulted in the use or purchase of a product or service from us, including details of the product or service purchased. These cookies don’t collect information that identifies you. All information these cookies collect is aggregated and therefore anonymous.',
					'3' =>
						'These cookies allow our websites to remember choices you make while browsing. For instance, we may store your geographic location in a cookie to ensure that we show you our website localized for your area. We may also remember preferences such as text size, fonts, and other customizable site elements. They may also be used to keep track of what featured products or videos have been viewed to avoid repetition. The information these cookies collect will not personally identify you, and they cannot track your browsing activity on other websites.',
					'4' =>
						'These cookies are used to share information, such as using social media share or like buttons, to link accounts of visitors to our website, or to interact with content on our website on or through social networks such as Facebook and Twitter. Social networks record the above behavior of our website visitors. Information collected by these cookies may be used for targeting and advertising activities.',
				],
			];
			$this->servicer->handle_add_languages(
				$_POST['language'], //phpcs:ignore WordPress.Security
				$struct,
				$Banner
			);
			$this->servicer->handle_add_category(
				$_POST['language'], //phpcs:ignore WordPress.Security
				$structCategory,
				$Category
			);
			set_transient(
				'msg-cookie-opt',
				esc_html__('Category Languages successfully', 'cookie-opt')
			);
			wp_redirect(admin_url('admin.php?page=co_languages'));
			die();
		}
		wp_die('Forbidden', 'Forbidden', ['response' => 403]);
	}
	public function edit($id)
	{
		//check $id co trong mảng key không
		$resAll = $this->servicer::CODE_LANG;
		$res_by_index = $this->servicer->getLanguagesByStatus();
		$content = json_decode($res_by_index->contents, true);
		foreach ($content as $lang => $val) {
			$content[$lang]['customize'][
				'category'
			] = $this->cookie_category_service->getDataCategory($lang);
		}
		$keyArray = array_keys($content);
		if (!in_array($id, $keyArray)) {
			wp_redirect(admin_url('admin.php?page=co_languages'));
			die();
		}
		//
		$array_of_banner = array_filter(
			$resAll,
			function ($value, $key) use ($keyArray) {
				return in_array($key, $keyArray);
			},
			ARRAY_FILTER_USE_BOTH
		); //*

		$default = $res_by_index->default_language;
		uksort($content, function ($key1, $key2) use ($default) {
			if ($key1 == $default) {
				return -1;
			} elseif ($key2 == $default) {
				return 1;
			} else {
				return 0;
			}
		});
		$idPagePolicy = get_option('wp_page_for_privacy_policy');
		$link_policy = get_permalink($idPagePolicy);

		$this->view('languages/edit_setting_languages', [
			'res_by_index' => $res_by_index, //tren data
			'array_of_banner' => $array_of_banner,
			'content' => $content, //chuyen json
			'id' => $id,
			'link_policy' => $link_policy,
		]);
	}
	public function handle_change_languages()
	{
		if (
			isset($_POST['nds_edit_languages']) &&
			wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['nds_edit_languages'])), 'nds_edit_languages')
		) {
			$this->param['id'] = isset($_GET['language']) ? sanitize_text_field(wp_unslash($_GET['language'])) : '';
			$nonce_action = isset($_POST['nonce_action'])
				? sanitize_text_field(wp_unslash($_POST['nonce_action']))
				: '';

			$data = [];
			$arrayCode = $this->servicer->getLanguagesByStatus();
			$categories = $this->servicer->getCategory();
			$content = json_decode($arrayCode->contents, true);

			$errors = LanguagesEditRequest::validateLanguagesEdit(
				$_POST,
				$arrayCode->regulation
			);
			if ($errors->has_errors()) {
				$language = $errors->get_error_data();
				set_transient('validate-err', $errors);
				wp_redirect(
					admin_url(
						'admin.php?page=co_languages&action=edit&language=' .
						$language .
						'&nonce_action=' .
						$nonce_action
					)
				);
				die();
			}
			foreach ($content as $key => $value) {
				$data[$key]['notice']['title'] =
					isset($_POST['title'][$key]) && !empty($_POST['title'][$key])
					? sanitize_text_field(wp_unslash($_POST['title'][$key]))
					: $value['notice']['title'];
				$data[$key]['notice']['description'] =
					isset($_POST['message'][$key]) && !empty($_POST['message'][$key])
					? stripslashes(sanitize_text_field(wp_unslash($_POST['message'][$key])))
					: stripslashes($value['notice']['description']);
				$data[$key]['notice']['buttons']['accept_button'] =
					isset($_POST['accept'][$key]) && !empty($_POST['accept'][$key])
					? sanitize_text_field(wp_unslash($_POST['accept'][$key]))
					: $value['notice']['buttons']['accept_button'];
				$data[$key]['notice']['buttons']['reject_button'] =
					isset($_POST['reject'][$key]) && !empty($_POST['reject'][$key])
					? sanitize_text_field(wp_unslash($_POST['reject'][$key]))
					: $value['notice']['buttons']['reject_button'];
				$data[$key]['notice']['buttons']['customize_button'] =
					isset($_POST['customize'][$key]) && !empty($_POST['customize'][$key])
					? sanitize_text_field(wp_unslash($_POST['customize'][$key]))
					: $value['notice']['buttons']['customize_button'];
				$data[$key]['notice']['buttons']['privacy_policy_button'] =
					isset($_POST['policy'][$key]) && !empty($_POST['policy'][$key])
					? sanitize_text_field(wp_unslash($_POST['policy'][$key]))
					: $value['notice']['buttons']['privacy_policy_button'];
				$data[$key]['notice']['buttons']['do_not_sell_page_button'] =
					isset($_POST['do_not_sell_page_button'][$key]) &&
					!empty($_POST['do_not_sell_page_button'][$key])
					? sanitize_text_field(wp_unslash($_POST['do_not_sell_page_button'][$key]))
					: $value['notice']['buttons']['do_not_sell_page_button'];
				$data[$key]['notice']['buttons']['cookie_policy_button'] =
					isset($_POST['cookie_policy_button'][$key]) &&
					!empty($_POST['cookie_policy_button'][$key])
					? sanitize_text_field(wp_unslash($_POST['cookie_policy_button'][$key]))
					: $value['notice']['buttons']['cookie_policy_button'];
				$data[$key]['customize'] = $value['customize'];
				if ($arrayCode->regulation !== 'ja') {
					$data[$key]['customize']['title'] =
						isset($_POST['customize_title'][$key]) &&
						!empty($_POST['customize_title'][$key])
						? sanitize_text_field(wp_unslash($_POST['customize_title'][$key]))
						: $value['notice']['customize']['title'];
					$data[$key]['customize']['description'] =
						isset($_POST['customize_description'][$key]) &&
						!empty($_POST['customize_description'][$key])
						? sanitize_text_field(wp_unslash($_POST['customize_description'][$key]))
						: $value['notice']['customize']['description'];
					$data[$key]['customize']['always_active'] =
						isset($_POST['always_active'][$key]) &&
						!empty($_POST['always_active'][$key])
						? sanitize_text_field(wp_unslash($_POST['always_active'][$key]))
						: $value['notice']['customize']['always_active'];
					$data[$key]['customize']['here'] =
						isset($_POST['here'][$key]) && !empty($_POST['here'][$key])
						? sanitize_text_field(wp_unslash($_POST['here'][$key]))
						: $value['notice']['customize']['here'];
					$data[$key]['customize']['button_save'] =
						isset($_POST['button_save'][$key]) &&
						!empty($_POST['button_save'][$key])
						? sanitize_text_field(wp_unslash($_POST['button_save'][$key]))
						: $value['notice']['customize']['button_save'];
				}
			}
			foreach ($this->cookie_category_service::CATEGORY_LIST as $key => $val) {
				$name = isset($_POST[$val]) && !empty($_POST[$val]) ? $_POST[$val] : json_decode($categories[$key]['name'], true); //phpcs:ignore WordPress.Security
				$this->servicer->updateCategories($name, ++$key);
			}

			$this->servicer->updateBannerByStatus($data);
			// $this->servicer->updateCategories($categories);
			set_transient(
				'msg-cookie-opt',
				esc_html__('Update Language successfully', 'cookie-opt')
			);
			wp_redirect(
				admin_url(
					'admin.php?page=co_languages&action=edit&language=' .
					$this->param['id'] .
					'&nonce_action=' .
					$nonce_action
				)
			);
			die();
		}
		wp_die('Forbidden', 'Forbidden', ['response' => 403]);
	}
}
