<?php

namespace App\Includes;

// exit if accessed directly
if (!defined('ABSPATH')) {
	exit();
}

use App\Includes\CookieOptBaseInc;
use App\Includes\FeatureManager\CookieOptFeatureManager;
use App\Services\CookieOptDashboardService;
use DateTime;

/**
 * CookieOptDashboard class.
 *
 * @class CookieOptDashboard
 */
class CookieOptDashboard extends CookieOptBaseInc
{
	private $server_dashboard;
	private $dataStatistical;
	private function viewByDashboard($name_view, $data = [])
	{
		require_once COOKIE_OPT_PATH . "templates/$name_view.php";
	}
	public static function getTimeZone()
	{
		return current_time('timestamp');
	}
	public function timeEverDay()
	{
		$currentTimestamp = self::getTimeZone();
		// Lấy ngày hiện tại
		$currentDate = date_i18n('Y-m-d', $currentTimestamp);
		// Thiết lập thời gian là 00:00:00
		$midnightTime = strtotime($currentDate . ' 00:00:00');
		// Nếu thời gian hiện tại đã vượt qua 00:00:00, thì thêm 1 ngày
		if ($currentTimestamp > $midnightTime) {
			$midnightTime += 86400; // Thêm 1 ngày (86400 giây)
		}
		return $midnightTime;
	}
	public function __construct()
	{
		$this->server_dashboard = new CookieOptDashboardService();

		add_action('admin_init', [$this, 'admin_hook_page']);

		$this->cookie_opt_cron_mycustom();
	}
	public function admin_hook_page()
	{
		add_action('current_screen', [$this, 'detecting_current_screen']);
		// add_action('wp_enqueue_scripts', [$this, 'register_handling_js']);
	}
	public function setDataStatistical()
	{
		$this->dataStatistical = $this->server_dashboard->dataStatistical();

	}
	public function cookie_opt_cron_mycustom()
	{
		add_filter('cron_schedules', function ($schedules) {
			// Thêm một lịch trình mới có tên là 'per_minute'
			$schedules['monthly'] = [
				'interval' => 60 * DAY_IN_SECONDS, // Khoảng thời gian giữa mỗi lần chạy (đơn vị: giây)
				'display' => esc_attr('One Month (30 day)'),
			];
			$schedules['daily'] = [
				'interval' => 86400, //one day have 86400s
				'display' => esc_attr('24:00 every day'),
			];
			return $schedules;
		});
	}


	public function detecting_current_screen()
	{
		$current_screen = get_current_screen();
		if (is_admin() && $current_screen->id == 'dashboard') {
			add_action('cookie_plugin_dashboard_library', [
				$this,
				'cookie_plugin_dashboard_library',
			]);
			$this->setDataStatistical();


			add_action('wp_dashboard_setup', [$this, 'wpdocs_add_dashboard_widgets']);
		}
	}
	public function cookie_plugin_dashboard_library()
	{
		wp_register_script_es6(
			'cookie-opt-dashboard-js-chart-custom',
			vite('resources/js/pages/chart.js'),
			[],
			VERSION,
			true
		);
		wp_localize_script('cookie-opt-dashboard-js-chart-custom', 'data', [
			'dataDrawChart' => $this->dataStatistical,
		]);

		//apply register
		wp_enqueue_style('cookie-opt-dashboard-custom-css');
		wp_enqueue_script('cookie-opt-dashboard-js-chart');
		wp_enqueue_script('cookie-opt-dashboard-js-chart-custom');
	}
	public function wpdocs_add_dashboard_widgets()
	{
		wp_add_dashboard_widget(
			'dashboard_widget',
			'Cookie Optimizer',
			[$this, 'dashboard_widget_function'],
			null,
			$this->dataStatistical
		);
	}
	public function dashboard_widget_function($var, $data)
	{
		$view = $data['args']['sum_statistics'];
		$userPackage = CookieOptFeatureManager::userPackage();
		$limitPackage = $userPackage->getNumberLimitPackage();
		$typePackage = $userPackage->packageType();
		if ($typePackage == 'PRO') {
			$limitPackage = __('Unlimited', 'cookie-opt');
			$remaining_amount = __('Unlimited', 'cookie-opt');
		} else {
			$limitPackage = $userPackage->getNumberLimitPackage();
			$remaining_amount = $userPackage->checkCurrentLimit()
				? 0
				: $limitPackage - $view;
		}

		//todo: handle info action banner
		$action = [
			'All_Consents' => 0,
			'Customize' => 0,
			'All_Refuse' => 0,
		];
		if (isset($data['args']['statistics']) && (count($data['args']['statistics']) != 0)) {
			$type_action = CookieOptDashboardService::TYPE_KEY;
			$name_key = array_flip($type_action);
			foreach ($data['args']['statistics'] as $value) {
				if ($value['type'] != $type_action['VIEW']) {
					$action[$name_key[$value['type']]] = ($data['args']['sum_action'] != 0)
						? round(($value['count'] / $data['args']['sum_action']) * 100, 0, PHP_ROUND_HALF_DOWN)
						: 0;
				}
			}
		}
		//todo: end handle info action banner
		$this->viewByDashboard('module/dashboard/dashboard-chart', [
			'args' => $data['args'],
			'remaining_amount' => $remaining_amount,
			'typePackage' => $typePackage,
			'limit_package' => $limitPackage,
			'action' => $action,
		]);
	}
}
