<?php

namespace App\Includes;

use App\Includes\FeatureManager\CookieOptFeatureManager;
use App\Services\CookieOptDashboardService;

class CookieOptBaseInc
{
	protected $action;
	protected $param;
	protected $servicer;
	protected $user_package;

	protected function view($nameview, $data = [])
	{
		if (is_admin()) {
			$user_package = CookieOptFeatureManager::userPackage();
			$user_type = $user_package->packageType();
			$option_ID = get_option('cookie_opt_id', '');
			if ($user_type == 'LOCK' || empty($option_ID)) {
				require_once COOKIE_OPT_PATH . 'templates/module/notice.php';
			} else if( $user_type == 'FREE' || $user_type == 'BASIC') {
				$dashboard_service = new CookieOptDashboardService();
				$data_chart = $dashboard_service->dataStatistical();
				$view = $data_chart['sum_statistics'];
				$data['plan'] = $user_type;
				$data['limit_package'] = $user_package->getNumberLimitPackage();
				$data['remaining_amount'] = $user_package->checkCurrentLimit()
					? 0
					: $data['limit_package'] - $view;
					require_once COOKIE_OPT_PATH . 'templates/module/notice_up_plan.php';
				if ($data['remaining_amount'] == 0) {
					require_once COOKIE_OPT_PATH . 'templates/module/notice-limit.php';
				}
			}
		}

		if (get_transient('msg-cookie-opt') !== false) {
			$this->Message();
		}

		require_once COOKIE_OPT_PATH . "templates/$nameview.php";
		if ($nameview != 'module/notice-limit') {
			if (get_transient('validate-err') !== false) {
				delete_transient('validate-err');
			}

			if (get_transient('msg-cookie-opt') !== false) {
				delete_transient('msg-cookie-opt');
			}
		}
	}

	protected function Message()
	{
		$msg = get_transient('msg-cookie-opt');
		ob_start();
		?>
		<div class="wrap">
			<div class="alert is-dismissible cookie-opt-notice-ok" id="custom-alert">
				<h2><strong><?php echo esc_html__(
					'Notification:',
					'cookie-opt'
				); ?></strong><?php echo esc_html($msg); ?></h2>
				<button type="button" class="close" id="close-alert" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
		</div>
		<?php echo ob_get_clean(); //phpcs:ignore WordPress.Security
	}

	public function messageError($key, $key_error = 'validate-err')
	{
		if (get_transient($key_error) !== false) {
			$errors = get_transient($key_error);
			$msg = $errors->get_error_messages($key);
			if (count($msg) > 0) {
				ob_start()
				?>
					<div style="color: red;">
						<?php echo esc_html($msg[0]) ?>
					</div>
				<?php
				$htmlString = ob_get_clean();

				echo wp_kses($htmlString, COOKIE_OPT_ALLOW_HTML_TAG);
			}
		}
	}

	public static function messageErrorHashData(
		$key,
		$keyparent,
		$key_error = 'validate-err'
	) {
		if (get_transient($key_error) !== false) {
			$errors = get_transient($key_error);
			$arrayError = $errors->get_all_error_data($key);
			if (in_array($keyparent, $arrayError)) {
				$msg = $errors->get_error_messages($key);
				if (count($msg) > 0) {
					$string = esc_html($msg[0]);
					ob_start();
					?>
						<div>
							<p style="color: red;"><?php echo esc_html($string) ?></p>
						</div>
					<?php
					$htmlString = ob_get_clean();
					echo wp_kses($htmlString, COOKIE_OPT_ALLOW_HTML_TAG);
				}
			}
		}
	}

	/**
	 * Prop Checked Helper
	 * @param mixed $param_check
	 * @param mixed $value_check value want to check
	 * @return void
	 */
	public function propChecked($param_check, $value_check)
	{
		if ($param_check == $value_check)
			echo esc_attr('checked');
		echo esc_attr('');
	}

	/**
	 * Prop Selected Helper
	 * @param mixed $param_check
	 * @param mixed $value_check value want to check
	 * @return void
	 */
	public function propSelected($param_check, $value_check = true)
	{
		if ($param_check == $value_check)
			echo esc_attr('selected');
		echo esc_attr('');
	}

	/**
	 * Prop Disabled Helper
	 * @param mixed $param_check
	 * @param mixed $value_check value want to check
	 * @return void
	 */
	public function propDisabled($param_check, $value_check = true)
	{
		if ($param_check == $value_check)
			echo esc_attr('disabled');
		echo esc_attr('');
	}

	/**
	 * Prop Class helper
	 * @param mixed $param_check
	 * @param mixed $value_check value want to check
	 * @param mixed $class class to prop
	 * @return void
	 */
	public function propClass($param_check, $value_check = true, $class = '')
	{
		if ($param_check == $value_check)
			echo esc_attr($class);
		echo esc_attr('');
	}

}
