<?php

namespace App\Includes;
use App\Services\CookiePermissionService;

class CookieOptBannerPreview extends CookieOptBaseInc
{
    public $cookie_opt_permission_service;
    public function __construct()
    {
        add_action('cookie_plugin_cookie_banner_preview_library', [$this, 'register_scripts_and_styles',]);

        add_action('wp_ajax_preview_banner', [$this, 'preview_banner']);
        add_action('wp_ajax_nopriv_preview_banner', [$this, 'preview_banner']);

        $this->cookie_opt_permission_service = new CookiePermissionService();
    }

    public function register_scripts_and_styles($page)
    {
        //Js Custom Script
        wp_register_script_es6(
            'banner-preview',
            vite('resources/js/pages/banner_preview.js'),
            ['jquery'],
            VERSION,
            true
        );
		wp_register_script_es6(
            'cookie-scan',
            vite('resources/js/pages/cookie-scan.js'),
            ['jquery'],
            VERSION,
            true
        );

        wp_localize_script('banner-preview', 'dataPreview', [
        	'ajaxurl' => admin_url('admin-ajax.php'),
        ]);

        wp_enqueue_script('banner-preview');
    }

    public function preview_banner()
    {
        $data = $this->cookie_opt_permission_service->getDataBanner($_POST); //phpcs:ignore WordPress.Security

        ob_start();
        include COOKIE_OPT_PATH . '/templates/banner/banner_preview.php';
        $html = ob_get_clean();

        return wp_send_json([
            'status' => 200,
            'data' => wp_json_encode($html),
            'regulation' => $data['regulation']  //phpcs:ignore WordPress.Security
        ]);
    }
}