// custom-script.js

// Ensure convertopia is defined globally
window.convertopia = window.convertopia || [];

(function($) {
    $(document).on('change', convertopia_custom_ajax_object.search_form_selectors, function (e) {

        if (window.convertopia && Array.isArray(window.convertopia)) {
            for (var i = window.convertopia.length - 1; i >= 0; i--) {
                var eventObj = window.convertopia[i];

                if (eventObj && eventObj.event === 'autocomplete_typing' && eventObj.key_word) {
                    sessionStorage.setItem('convertopia_autocomplete_keyword', eventObj.key_word);
                    break;
                }
            }
        }
    });

    $(document).ready(function() {
        if (typeof convertopia_settings !== 'undefined') {
           var keyword = sessionStorage.getItem('convertopia_autocomplete_keyword');


            if (convertopia_settings.istrackUserData) {
                // Push merchant_identify event
                window.convertopia.push({
                    'event': 'merchant_identify',
                    'public_site_id': convertopia_settings.StoreID,
                    'session_id': convertopia_settings.session_id
                });

                // Push page_view event
                window.convertopia.push({
                    'event': 'page_view',
                    'page_type': convertopia_settings.page_type,
                    'user_id': convertopia_settings.user_id,
                    'key_word': keyword
                });
            }



            if (convertopia_settings.page_type == 'CART') {
                if (convertopia_settings.istrackUserData) {
                    window.convertopia.push({
                        'event': 'view_cart',
                        'line_items': convertopia_settings.lineItem, // array of products in cart with object {id:'', name:'', price:'', catgory:'', url:''}
                        'user_id': convertopia_settings.user_id,
                        'key_word': keyword
                    })
                }
            }

            if (convertopia_settings.page_type == 'CHECKOUT_BEGIN' || convertopia_settings.page_type == 'CHECKOUT_REVIEW') {
                if (convertopia_settings.istrackUserData) {
                    window.convertopia.push({
                        'event': 'checkout_start',
                        'line_items': convertopia_settings.line_items,
                        'user_id': convertopia_settings.user_id,
                        'key_word': keyword
                    });
                }
            }

            if (convertopia_settings.page_type == 'ORDER_CONFIRMATION' || convertopia_settings.order_total) {
                if (convertopia_settings.istrackUserData) {
                    window.convertopia.push({
                        'event': 'checkout_shipping',
                        'line_items': convertopia_settings.line_items,
                        'user_shipping_address': convertopia_settings.user_shipping_address,
                        'user_email_hashed': convertopia_settings.user_email_hashed,
                        'user_id': convertopia_settings.user_id,
                        'key_word': keyword
                    });
    
                    window.convertopia.push({
                        'event': 'checkout_payment',
                        'line_items': convertopia_settings.line_items, // array of products with object {id:'', name:'', price:'', catgory:'', url: ''}
                        'user_billing_address': convertopia_settings.user_billing_address, // object having {'first_name: '', last_name: '',address1': '', address1: '', cit
                        'user_email_hashed': convertopia_settings.user_email_hashed,
                        'user_id': convertopia_settings.user_id,
                        'key_word': keyword
                    });
                    
                    window.convertopia.push({
                        'event': 'order_confirmation',
                        'line_items': convertopia_settings.line_items,
                        'user_email_hashed': convertopia_settings.user_email_hashed,
                        'user_billing_address': convertopia_settings.user_billing_address,
                        'user_shipping_address': convertopia_settings.user_shipping_address,
                        'order_total': convertopia_settings.order_total,
                        'currency_code': convertopia_settings.currency_code,
                        'user_id': convertopia_settings.user_id,
                        'key_word': keyword
                    });
                }
            }

            if (convertopia_settings.page_type == 'ORDER_CONFIRMATION'){
                sessionStorage.removeItem('convertopia_autocomplete_keyword');
            }

        } else {
            console.error('convertopia_settings is not defined.');
        }
    });

    $(document).on('submit', convertopia_custom_ajax_object.form_selectors, function (e) {
        var $form = $(this);
        var productId = $form.find('input[name="product-id"]').val();

        // Only hook in once
        if ($form.data('convertopia-bound')) return;
        $form.data('convertopia-bound', true);

        // Observe DOM for success indicators
        var observer = new MutationObserver(function (mutations) {
            mutations.forEach(function (mutation) {
                if ($(mutation.target).is(':contains("Thank you")') || $(mutation.target).find('.wpcf7-mail-sent-ok, .nf-response-msg, .elementor-message-success, .gform_confirmation_message').length > 0) {
                    triggerConvertopiaTracking(productId);
                    observer.disconnect(); // Stop observing after success
                }
            });
        });

        // Watch for changes to the form's parent or message container
        observer.observe($form.closest('form, .form-wrapper, .form-container')[0] || $form[0], {
            childList: true,
            subtree: true
        });
    });

function triggerConvertopiaTracking(productId) {
    $.ajax({
        url: convertopia_custom_ajax_object.ajax_url,
        type: 'POST',
        data: {
            action: 'convertopia_track_inquiry_submit',
            product_id: productId,
            nonce: convertopia_custom_ajax_object.nonce
        },
        success: function (response) {
            if (typeof window.convertopia !== 'undefined' && typeof window.convertopia.push === 'function') {
                var keyword = sessionStorage.getItem('convertopia_autocomplete_keyword');
                window.convertopia.push({
                    event: 'inquiry_submit',
                    line_items: response.line_items || [],
                    user_id: response.user_id || null,
                    key_word: keyword
                });
                sessionStorage.removeItem('convertopia_autocomplete_keyword');
            }
        }
    });
}

    $(document).on('added_to_cart', function(event, fragments, cart_hash, $button) {
        // Send tracking data here, e.g., using AJAX to your server or analytics service
        var product = $button.attr('href');
        var productObject = product.split('=');
        var product_id = productObject[1];

        // Example: Sending data via AJAX to your server
        $.ajax({
            url: convertopia_custom_ajax_object.ajax_url,
            type: 'POST',
            data: {
                action: 'convertopia_track_add_to_cart',
                product_id: product_id,
                nonce: convertopia_custom_ajax_object.nonce
            },
            success: function(response) {
                var keyword = sessionStorage.getItem('convertopia_autocomplete_keyword');
                window.convertopia.push({
                    'event': 'add_to_cart',
                    'line_items': response.line_items, // You can modify this if you have multiple items
                    'user_id': response.user_id, // Modify as needed for user_id
                    'key_word': keyword
                })
            }
        });
    });


        // Check if the consent has already been given
        if (!sessionStorage.getItem('consentGiven')) {
            // Display the popup
            $('body').append(`
                <div id="ct-consent-popup" style="position: fixed; bottom: 0; left: 0; width: 100%; background:rgb(26, 26, 26); color: #fff; display: flex; align-items: center; justify-content: center; z-index: 10000; padding: 16px 10px; box-sizing: border-box;">
                    <span style="flex: 1; text-align: left; font-size: 15px;">
                        We use cookies to enhance your browsing experience, serve personalized content, and analyze site traffic. By clicking "Accept All", you consent to our use of cookies.
                    </span>
                    <button id="ct-consent-accept" style="background: #fff; color: #232323; border: none; border-radius: 3px; padding: 8px 18px; margin-left: 16px; cursor: pointer; font-weight: 600;">Accept</button>
                    <button id="ct-consent-decline" style="background: transparent; color: #fff; border: 1px solid #fff; border-radius: 3px; padding: 8px 18px; margin-left: 8px; cursor: pointer; font-weight: 600;">Decline</button>
                </div>
            `);
    
            // Handle the accept button
            $('#ct-consent-accept').on('click', function() {
                $.ajax({
                    type: 'post',
                    url: convertopia_custom_ajax_object.ajax_url,
                    data: {
                        action: 'convertopia_save_user_consent',
                        consent: true,
                        nonce: convertopia_custom_ajax_object.nonce,
                    },
                    success: function(response) {
                        if (response.success) {
                            sessionStorage.setItem('consentGiven', 'true');
                            $('#ct-consent-popup').remove();
                        }
                        location.reload();
                    }
                });
            });
    
            // Handle the decline button
            $('#ct-consent-decline').on('click', function() {
                sessionStorage.setItem('consentGiven', 'false');
                $('#ct-consent-popup').remove();
            });
        }

})(jQuery);