<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly
use ElementorPro\Plugin;
class Yeekit_EL_Conversational_Frontend
{
    public function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);
        add_filter("elementor/widget/render_content", array($this, "render_content"), 100, 2);
    }
    function render_content($content, $widget)
    {
        if ('form' === $widget->get_name()) {
            if (Plugin::elementor()->editor->is_edit_mode()) {
                return $content;
            }
            $form = $widget->get_settings_for_display();
            $actions = $form['submit_actions'];
            $check = false;
            foreach ($actions as $action) {
                if ($action === 'yeekit_conversational') {
                    $check = true;
                    break;
                }
            }
            if ($check) {
                $form_title     = $form["yeekit_conversational_title"];
                $form_message   = $form["yeekit_conversational_mesage"];
                $form_bnt       = $form["yeekit_conversational_start"];
                $completed      = __("completed","conversational-forms-for-elementor-forms");
                $press          = __("press","conversational-forms-for-elementor-forms");
                $form_backgound = $form["yeekit_conversational_backgound"];
                $form_color     = $form["yeekit_conversational_color"];
                $form_footer_bg    = $form["yeekit_conversational_footer_backgourd"];
                $form_footer_color     = $form["yeekit_conversational_footer_color"];
                $form_bnt_bg    = $form["yeekit_conversational_bnt_backgourd"];
                $form_bnt_color    = $form["yeekit_conversational_bnt_color"];
                $footer = '<div class="yeekit-conversational-form-footer" style="background: '.$form_footer_bg.'; color: '.$form_footer_color.';">
                    <div class="yeekit-conversational-form-footer-progress">
                        <div class="yeekit-conversational-form-footer-progress-status">
                            <div class="yeekit-conversational-form-footer-progress-status-percentage">
                                <span class="completed">0</span>% '.$completed.'
                            </div>
                        </div>
                        <div class="yeekit-conversational-form-footer-progress-bar">
                            <div class="yeekit-conversational-form-footer-progress-completed"></div>
                        </div>
                    </div>
                    <div class="yeekit-conversational-form-footer-controls">
    <button class="yeekit-nav-btn yeekit-nav-up" style="background: '.$form_bnt_bg.'; color: '.$form_bnt_color.';">↑</button>
    <button class="yeekit-nav-btn yeekit-nav-down" style="background: '.$form_bnt_bg.'; color: '.$form_bnt_color.';">↓</button>
  </div>
                </div>';
                $conatainer = '<div class="yeekit-conversational-form-loader-container" style="background: '.$form_backgound.'; color: '.$form_color.';">
                <div class="yeekit-conversational-form-loader-wrap">';
                $header = '
<div class="yeekit-conversational-form-header">
    <div class="yeekit-conversational-form--content">
        <div class="yeekit-head-title">'.$form_title.'</div>
        <div class="yeekit-head-description">
            <p>'.$form_message.'</p>
        </div>
    </div>
';
                $button = '<div class="yeekit-conversational-form-btn-container">
					<button class="yeekit-conversational-btn-start yeekit-conversational-btn" style="background: '.$form_bnt_bg.'; color: '.$form_bnt_color.';">'.$form_bnt.'</button>
					<div class="yeekit-conversational-form-btn-desc">
						'.$press.' <strong>Enter</strong>					</div>
				</div>
                </div>';
                $conatainer_end = '</div>'.$footer.'</div>';
                return $conatainer . $header . $button . $content . $conatainer_end;
            } else {
                return $content;
            }
        }
        return $content;
    }
    function enqueue_scripts()
    {
         $translation_array = array(
                'yeekit_make_text'   => __( 'to make a line break', 'conversational-forms-for-elementor-forms' ),
                'yeekit_make_email'  => __( 'Please enter a valid email address.', 'conversational-forms-for-elementor-forms' ),
                'yeekit_make_url'    => __( 'Please enter a valid URL.', 'conversational-forms-for-elementor-forms' ),
                'yeekit_make_number' => __( 'The value must be a number.', 'conversational-forms-for-elementor-forms' ),
                'yeekit_make_phone'  => __( 'Please enter a valid phone number.', 'conversational-forms-for-elementor-forms' ),
            );
        wp_enqueue_script(
            'yeekit-conversational',
            YEEKIT_EL_CON_PLUGIN_URL . 'assets/conversational.js',
            ['jquery'],
            "2.0.0",
            true
        );
        wp_localize_script( 'yeekit-conversational', 'yeekit_conversational_datas', $translation_array );
        wp_enqueue_style(
            'yeekit-conversational',
            YEEKIT_EL_CON_PLUGIN_URL . 'assets/conversational.css',
            [],
            "2.0.0"
        );
    }
}
new Yeekit_EL_Conversational_Frontend;
