<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly
use Elementor\Controls_Manager;
use Elementor\Modules\DynamicTags\Module as TagsModule;
use ElementorPro\Modules\Forms\Classes\Action_Base;
class Yeekit_EL_Conversational_Action extends Action_Base
{
    public function get_name()
    {
        return 'yeekit_conversational';
    }
    public function get_label()
    {
        return esc_html__('Conversational Forms', 'conversational-forms-for-elementor-forms');
    }
    public function register_settings_section($widget)
    {
        $widget->start_controls_section(
            'yeekit_section_conversational',
            [
                'label' => esc_html__('Conversational Form', 'conversational-forms-for-elementor-forms'),
                'condition' => [
                    'submit_actions' => $this->get_name(),
                ],
            ]
        );
        $widget->add_control(
            'yeekit_conversational_title',
            [
                'label' => esc_html__('Conversational Form Title', 'conversational-forms-for-elementor-forms'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_attr__("Conversational Form", 'conversational-forms-for-elementor-forms'),
                'ai' => [
                    'active' => false,
                ],
                'label_block' => true,
                'render_type' => 'none',
                'classes' => 'elementor-control-direction-ltr',
            ]
        );
        $widget->add_control(
            'yeekit_conversational_mesage',
            [
                'label' => esc_html__('Message', 'conversational-forms-for-elementor-forms'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $widget->add_control(
            'yeekit_conversational_start',
            [
                'label' => esc_html__('Button Text', 'conversational-forms-for-elementor-forms'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_attr__("Start", 'conversational-forms-for-elementor-forms'),
                'ai' => [
                    'active' => false,
                ],
                'label_block' => true,
                'render_type' => 'none',
                'classes' => 'elementor-control-direction-ltr',
            ]
        );
        $widget->add_control(
            'yeekit_conversational_backgound',
            [
                'label' => esc_html__('Background', 'conversational-forms-for-elementor-forms'),
                'type' => Controls_Manager::COLOR,
                'default' => "#FDC5F2"
            ]
        );
        $widget->add_control(
            'yeekit_conversational_color',
            [
                'label' => esc_html__('Color', 'conversational-forms-for-elementor-forms'),
                'type' => Controls_Manager::COLOR,
                'default' => "#444"
            ]
        );
        $widget->add_control(
            'yeekit_conversational_footer_backgourd',
            [
                'label' => esc_html__('Footer Background', 'conversational-forms-for-elementor-forms'),
                'type' => Controls_Manager::COLOR,
                'default' => "#444"
            ]
        );
        $widget->add_control(
            'yeekit_conversational_footer_color',
            [
                'label' => esc_html__('Footer Color', 'conversational-forms-for-elementor-forms'),
                'type' => Controls_Manager::COLOR,
                'default' => "#fff"
            ]
        );
        $widget->add_control(
            'yeekit_conversational_bnt_backgourd',
            [
                'label' => esc_html__('Button Background', 'conversational-forms-for-elementor-forms'),
                'type' => Controls_Manager::COLOR,
                'default' => "#448ccb"
            ]
        );
        $widget->add_control(
            'yeekit_conversational_bnt_color',
            [
                'label' => esc_html__('Button Color', 'conversational-forms-for-elementor-forms'),
                'type' => Controls_Manager::COLOR,
                'default' => "#fff"
            ]
        );
        $widget->end_controls_section();
    }
    public function on_export($element)
    {
        return $element;
    }
    public function run($record, $ajax_handler) {}
}
