(function ($) {
    "use strict";
    jQuery(document).ready(function ($) {
        let isProgrammaticScroll = false;
        // When Elementor form is submitted successfully
        $(document).on('submit_success', function (e, response) {
            const $form = $(e.target);
            const $container = $form.closest('.yeekit-conversational-form-loader-container');
            // Hide all headers, forms, and footers
            $container.find('.yeekit-conversational-form-loader-wrap, .yeekit-conversational-form-footer').css("display", "none");
            // Get the message from response.data.message
            const message = response.message;
            // Create a notification block in the center of the page
            const $message = $('<div class="yeekit-conversational-final-message">')
                .html('<div class="inner"><p>' + message + '</p></div>');
            // Add to container and display in the center
            $container.append($message.hide());
            $message.fadeIn(500);
            // Scroll to the top of the container
            setTimeout(() => {
                $container.animate({ scrollTop: 0 }, 400);
            }, 200);
        });
        // Helper: center an element inside the scrollable container
        function centerScroll($container, $el, duration) {
            if (!$container.length || !$el.length) return;
            const relTop = $el.position().top;
            const target = $container.scrollTop() + relTop - ($container.height() / 2) + ($el.outerHeight() / 2);
            isProgrammaticScroll = true;
            $container.scrollTop(target);
            // Reset flag on the next tick so user scroll is captured again
            setTimeout(() => { isProgrammaticScroll = false; }, 80);
        }
        function updateProgressBar($container) {
            const $fields = $container.find('.elementor-field-group');
            const total = $fields.length;
            if (!total) return;
            let completed = 0;
            $fields.each(function () {
                const $input = $(this).find('input, select, textarea');
                if ($input.length && $input.val()) {
                    completed++;
                }
            });
            const percent = Math.round((completed / total) * 100);
            $container.find('.wpforms-conversational-form-footer-progress-status-percentage .completed').text(percent);
            $container.find('.wpforms-conversational-form-footer-progress-completed').css('width', percent + '%');
        }
        let userScrollDebounce;
        $('.yeekit-conversational-form-loader-container').on('scroll', function (e) {
            if (isProgrammaticScroll) return;
            const $container = $(this);
            if (userScrollDebounce) clearTimeout(userScrollDebounce);
            userScrollDebounce = setTimeout(() => {
                // Only called when user finishes scrolling
                updateActiveField($container);
            }, 90);
        });
        // Update progress when scrolling
        $('.yeekit-conversational-form-loader-container').on('scroll', function (e) {
            if (isProgrammaticScroll) return;
            const $container = $(this);
            const $fields = $container.find('.elementor-field-group');
            const total = $fields.length;
            if (!total) return;
            const containerTop = $container.offset().top;
            const containerScroll = $container.scrollTop();
            const containerHeight = $container.height();
            const containerCenter = containerScroll + containerHeight / 2;
            let activeIndex = 0;
            let minDist = Infinity;
            $fields.each(function (index) {
                const $f = $(this);
                const top = $f.offset().top - containerTop + containerScroll;
                const center = top + ($f.outerHeight() / 2);
                const dist = Math.abs(center - containerCenter);
                if (dist < minDist) {
                    minDist = dist;
                    activeIndex = index + 1;
                }
            });
            const percent = Math.round((activeIndex / total) * 100);
            $container.find('.yeekit-conversational-form-footer-progress-status-percentage .completed').text(percent);
            $container.find('.yeekit-conversational-form-footer-progress-completed').css('width', percent + '%');
        });
        $(document).on('click', '.yeekit-conversational-btn-start', function (e) {
            e.preventDefault();
            const $container = $(this).closest('.yeekit-conversational-form-loader-container');
            $container.addClass('active');
            $container.css("overflow-y", "auto");
            $container.find(".yeekit-conversational-form-footer").css("display", "flex");
            $container.find(".yeekit-conversational-form-btn-container").hide();
            // Get the form and the first field
            const $form = $container.find('form').first();
            const $fields = $form.find('.elementor-field-group');
            if (!$fields.length) return;
            const $firstField = $fields.first();
            // Scroll the first field into the center of the container (using position instead of offset)
            setTimeout(() => {
                centerScroll($container, $firstField, 500);
                // After scrolling -> highlight the first field
                setTimeout(() => {
                    $fields.each(function (index) {
                        if (index === 0) {
                            $(this).css({
                                opacity: 1,
                                transform: 'translateY(0)',
                                fontWeight: '600'
                            });
                            // Automatically focus the input in the displayed field
                            const $input = $(this).find('input:not([type="hidden"]), select, textarea').first();
                            if ($input.length) {
                                setTimeout(() => {
                                    $input.trigger('focus');
                                }, 150);
                            }
                        } else {
                            $(this).css({
                                opacity: 0.25,
                                transform: 'translateY(10px)',
                                fontWeight: '400'
                            });
                        }
                    });
                }, 520);
            }, 50);
        });
        // When a field is clicked, scroll it to the center of the screen
        $(document).on('click', '.elementor-field-group', function (e) {
            const $field = $(this);
            if ($field.hasClass("elementor-field-type-submit")) {
                return;
            }
            const $container = $field.closest('.yeekit-conversational-form-loader-container');
            // Allow default interaction (open select, focus input, etc.)
            const isInteractive = $(e.target).is('input, select, textarea, button, option, [contenteditable], label');
            if (!isInteractive) {
                e.preventDefault();
            }
            // Scroll the field into the center of the container (do not prevent default if clicking on an interactive element)
            centerScroll($container, $field, 500);
            // After scrolling, highlight this field and dim the others
            const $form = $container.find('form').first();
            const $fields = $form.find('.elementor-field-group');
            $fields.each(function () {
                const $f = $(this);
                if ($f.hasClass('elementor-field-type-submit')) {
                    $f.css({ opacity: 1, transform: 'translateY(0)', fontWeight: '600' });
                    return;
                }
                if (this === $field[0]) {
                    $f.css({ opacity: 1, transform: 'translateY(0)', fontWeight: '600' });
                    const $input = $f.find('input:not([type="hidden"]), select, textarea').first();
                    if ($input.length) {
                        setTimeout(() => {
                            $input.trigger('focus');
                        }, 150);
                    }
                } else {
                    $f.css({ opacity: 0.25, transform: 'translateY(10px)', fontWeight: '400' });
                }
            });
        });
        $(document).on('keydown', function (e) {
            if (e.which === 13) { // Enter
                const $startBtn = $('.yeekit-conversational-btn-start');
                const $container = $startBtn.closest('.yeekit-conversational-form-loader-container');
                if ($startBtn.is(':visible') && !$container.hasClass('active')) {
                    e.preventDefault();
                    $startBtn.trigger('click');
                }
            }
        });
        // When focusing on a textarea -> show the "Shift + Enter to make a line break" hint
        $(document).on('focus', '.elementor-field-group textarea', function () {
            const $textarea = $(this);
            // If the hint does not exist, add it
            if ($textarea.next('.yeekit-shiftenter-hint').length === 0) {
                const $hint = $('<div class="yeekit-shiftenter-hint"><strong>Shift + Enter</strong> ' + yeekit_conversational_datas.yeekit_make_text + '</div>');
                $textarea.after($hint);
                $hint.fadeIn(200);
            }
        });
        // When blurring textarea -> hide the hint
        $(document).on('blur', '.elementor-field-group textarea', function () {
            const $hint = $(this).next('.yeekit-shiftenter-hint');
            if ($hint.length) {
                $hint.fadeOut(200, function () {
                    $(this).remove();
                });
            }
        });
        // When pressing Tab or Enter, show the next field
        // When pressing Tab or Enter, show the next field
        $(document).on('keydown', '.elementor-field-group :input', function (e) {
            const $input = $(this);
            const $field = $input.closest('.elementor-field-group');
            const $container = $input.closest('.yeekit-conversational-form-loader-container');
            // --- SHIFT + ENTER: add a new line ---
            if ($input.is('textarea') && e.key === 'Enter' && e.shiftKey) {
                e.preventDefault();
                const lineHeight = parseFloat($input.css('line-height')) || 20;
                const currentHeight = $input.height();
                $input.height(currentHeight + lineHeight);
                $input.val($input.val() + '\n');
                return;
            }
            // --- ENTER or TAB: move to the next field ---
            if (e.which === 9 || (e.key === 'Enter' && !e.shiftKey)) {
                e.preventDefault();
                const value = $input.val().trim();
                const isRequired = $input.prop('required') || $input.attr('aria-required') === 'true';
                const type = $input.attr('type') || $input.prop('type') || '';
                let errorMessage = '';
                // 1️⃣ Check required
                if (isRequired && !value) {
                    errorMessage = 'This field is required.';
                }
                // 2️⃣ If value exists, validate format based on type
                if (!errorMessage && value) {
                    switch (type) {
                        case 'email':
                            if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(value)) {
                                errorMessage = yeekit_conversational_datas.yeekit_make_email;
                            }
                            break;
                        case 'url':
                            try {
                                new URL(value);
                            } catch {
                                errorMessage = yeekit_conversational_datas.yeekit_make_url;
                            }
                            break;
                        case 'number':
                            if (isNaN(value)) {
                                errorMessage = yeekit_conversational_datas.yeekit_make_number;
                            }
                            break;
                        case 'tel':
                            if (!/^[0-9+\-\s()]{6,}$/.test(value)) {
                                errorMessage = yeekit_conversational_datas.yeekit_make_phone;
                            }
                            break;
                    }
                }
                // If there is an error -> display message, refocus, stop
                if (errorMessage) {
                    $field.addClass('yeekit-error');
                    if ($field.find('.yeekit-error-message').length === 0) {
                        $field.append('<div class="yeekit-error-message">' + errorMessage + '</div>');
                    } else {
                        $field.find('.yeekit-error-message').text(errorMessage);
                    }
                    const relTop = $field.position().top;
                    const target = $container.scrollTop() + relTop - ($container.height() / 2) + ($field.outerHeight() / 2);
                    $container.animate({ scrollTop: target }, 400);
                    setTimeout(() => {
                        $input.trigger('focus');
                    }, 150);
                    return; // Stop, do not move to next field
                } else {
                    $field.removeClass('yeekit-error');
                    $field.find('.yeekit-error-message').remove();
                }
                // 3️⃣ If valid, move to the next field (handle fields in the same row)
                const $currentField = $input.closest('.elementor-field-group');
                const $form = $input.closest('form');
                const $fields = $form.find('.elementor-field-group');
                const rows = getFieldRows($fields);
                // Find the row containing the current field
                let currentRowIndex = -1;
                rows.forEach((row, idx) => {
                    if (row.fields.some($f => $f[0] === $currentField[0])) {
                        currentRowIndex = idx;
                    }
                });
                let $nextField = null;
                if (currentRowIndex !== -1) {
                    const currentRow = rows[currentRowIndex];
                    const indexInRow = currentRow.fields.findIndex($f => $f[0] === $currentField[0]);
                    // If there is a next field in the same row, move to it
                    if (indexInRow < currentRow.fields.length - 1) {
                        $nextField = currentRow.fields[indexInRow + 1];
                    } else if (rows[currentRowIndex + 1]) {
                        // If at the end of the row, move to the first field of the next row
                        $nextField = rows[currentRowIndex + 1].fields[0];
                    }
                }
                if ($nextField && $nextField.length) {
                    const $currentRow = rows[currentRowIndex];
                    const indexInRow = $currentRow.fields.findIndex($f => $f[0] === $currentField[0]);
                    const nextIsSameRow = indexInRow < $currentRow.fields.length - 1;
                    if (!nextIsSameRow) {
                        // Only scroll when moving to a different row
                        const nextTarget = $nextField.position().top + $container.scrollTop()
                            - ($container.height() / 2) + ($nextField.outerHeight() / 2);
                        $container.animate({ scrollTop: nextTarget }, 600);
                    }
                    $currentField.css({ opacity: 0.3 });
                    $nextField.css({ opacity: 1 });
                    const $nextInput = $nextField.find('input:not([type="hidden"]), select, textarea').first();
                    if ($nextInput.length) {
                        setTimeout(() => {
                            $nextInput.trigger('focus');
                        }, 150);
                    }
                }
                if (e.key === 'Enter' && $nextField.hasClass('elementor-field-type-submit')) {
                    e.preventDefault();
                    const $form = $input.closest('form');
                    if ($form.length) {
                        $form.trigger('submit');
                    }
                    return;
                }
            }
        });
        // Group fields that are in the same row (by top position)
        function getFieldRows($fields) {
            const rows = [];
            $fields.each(function () {
                const $f = $(this);
                const top = Math.round($f.position().top);
                let group = rows.find(r => Math.abs(r.top - top) < 50);
                if (!group) {
                    group = { top, fields: [] };
                    rows.push(group);
                }
                group.fields.push($f);
            });
            return rows;
        }
        function updateActiveField($container) {
            const $form = $container.find('form').first();
            if (!$form.length) return;
            const $fields = $form.find('.elementor-field-group');
            if (!$fields.length) return;
            const rows = getFieldRows($fields);
            const containerTop = $container.offset().top;
            const containerScroll = $container.scrollTop();
            const containerCenter = containerScroll + ($container.height() / 2);
            let closestRow = null;
            let minDist = Infinity;
            rows.forEach(row => {
                const firstField = row.fields[0];
                const top = firstField.offset().top - containerTop + containerScroll;
                const center = top + (firstField.outerHeight() / 2);
                const dist = Math.abs(center - containerCenter);
                if (dist < minDist) {
                    minDist = dist;
                    closestRow = row;
                }
            });
            // Reset all fields to dimmed state
            $fields.each(function () {
                const $f = $(this);
                if ($f.hasClass('elementor-field-type-submit')) {
                    $f.css({ opacity: 1, transform: 'translateY(0)' });
                    return;
                }
                $f.css({ opacity: 0.25, transform: 'translateY(8px)' });
            });
            // Highlight the row closest to the center
            if (closestRow) {
                // Highlight all fields in the row
                closestRow.fields.forEach($f => {
                    $f.css({ opacity: 1, transform: 'translateY(0)' });
                });
                // When highlighting a row with radio/checkbox, add key hint labels (a), (b), (c)
                closestRow.fields.forEach($f => {
                    const $options = $f.find('input[type="radio"], input[type="checkbox"]');
                    console.log($options);
                    $options.each(function (idx) {
                        const labelChar = String.fromCharCode(97 + idx); // a,b,c,d,...
                        const $label = $(this).closest('.elementor-field-option');
                        if ($label.find('.yeekit-key-hint').length === 0) {
                            $label.append('<span class="yeekit-key-hint"><span class="yeekit-key-hint-text">Key </span>' + labelChar + '</span>');
                        }
                    });
                });
                // ✅ Only focus the first input of the row
                const $firstField = closestRow.fields[0];
                const $input = $firstField.find('input:not([type="hidden"]), select, textarea').first();
                if ($input.length) {
                    setTimeout(() => { $input.trigger('focus'); }, 150);
                }
            }
        }
        // When the active row contains a checkbox or radio button => select using a-z keys
        $(document).on('keydown', function (e) {
            const $activeContainer = $('.yeekit-conversational-form-loader-container.active');
            if (!$activeContainer.length) return;
            const key = e.key.toLowerCase();
            if (key < 'a' || key > 'z') return; // only accept a-z keys
            // Find the row that is currently highlighted
            const $form = $activeContainer.find('form').first();
            const $fields = $form.find('.elementor-field-group');
            const rows = getFieldRows($fields);
            // Determine the row closest to the center of the screen (the active row)
            const containerTop = $activeContainer.offset().top;
            const containerScroll = $activeContainer.scrollTop();
            const containerCenter = containerScroll + ($activeContainer.height() / 2);
            let closestRow = null;
            let minDist = Infinity;
            rows.forEach(row => {
                const firstField = row.fields[0];
                const top = firstField.offset().top - containerTop + containerScroll;
                const center = top + (firstField.outerHeight() / 2);
                const dist = Math.abs(center - containerCenter);
                if (dist < minDist) {
                    minDist = dist;
                    closestRow = row;
                }
            });
            if (!closestRow) return;
            // Check if the row contains any radio or checkbox input
            const $inputs = closestRow.fields.find($f =>
                $f.find('input[type="radio"], input[type="checkbox"]').length > 0
            )?.find('input[type="radio"], input[type="checkbox"]');
            if ($inputs && $inputs.length) {
                e.preventDefault();
                // Assign keys in order (a = first input, b = second, ...)
                const index = key.charCodeAt(0) - 97; // 'a' = 97
                if (index >= 0 && index < $inputs.length) {
                    const $target = $($inputs[index]);
                    if ($target.length) {
                        // Toggle if checkbox, select if radio
                        if ($target.attr('type') === 'checkbox') {
                            $target.prop('checked', !$target.prop('checked')).trigger('change');
                        } else {
                            $inputs.prop('checked', false);
                            $target.prop('checked', true).trigger('change');
                        }
                        $target.focus();
                    }
                }
            }
        });
        // Navigation buttons: scroll up/down one row at a time
        $(document).on('click', '.yeekit-nav-btn', function () {
            const isDown = $(this).hasClass('yeekit-nav-down');
            const $container = $('.yeekit-conversational-form-loader-container.active');
            if (!$container.length) return;

            const $form = $container.find('form').first();
            const $fields = $form.find('.elementor-field-group');
            const rows = getFieldRows($fields);

            const containerTop = $container.offset().top;
            const containerScroll = $container.scrollTop();
            const containerCenter = containerScroll + ($container.height() / 2);

            // Find current row (closest to center)
            let currentIndex = 0;
            let minDist = Infinity;
            rows.forEach((row, idx) => {
                const firstField = row.fields[0];
                const top = firstField.offset().top - containerTop + containerScroll;
                const center = top + (firstField.outerHeight() / 2);
                const dist = Math.abs(center - containerCenter);
                if (dist < minDist) {
                    minDist = dist;
                    currentIndex = idx;
                }
            });

            // Determine next/prev row index
            let targetIndex = isDown ? currentIndex + 1 : currentIndex - 1;
            if (targetIndex < 0) targetIndex = 0;
            if (targetIndex >= rows.length) targetIndex = rows.length - 1;

            // Scroll smoothly to that row
            const $targetField = rows[targetIndex].fields[0];
            const target = $targetField.position().top + $container.scrollTop()
                - ($container.height() / 2) + ($targetField.outerHeight() / 2);

            $container.stop().animate({ scrollTop: target }, 600, function () {
                updateActiveField($container, true);
            });
        });
    });
})(jQuery);