<?php
/**
 * Spintax utilities for ContentWeaver AI Lite
 *
 * @package ContentWeaverAILite
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Spin a string using simple {a|b|c} spintax.
 *
 * This implementation is deliberately small and local-only. It does not make any network requests.
 * It supports nested braces by repeatedly resolving the innermost groups first.
 *
 * @param string $text Input text containing spintax groups.
 * @return string Spun text.
 */
function contentweaver_ai_lite_spin_text( string $text ): string {
	$max_iterations = 1000; // safety guard to avoid pathological loops.
	$pattern        = '/\{([^{}]+)\}/';

	$iterations = 0;
	while ( preg_match( $pattern, $text, $matches ) === 1 ) {
		$iterations++;
		if ( $iterations > $max_iterations ) {
			break; // safety break.
		}

		$group   = $matches[0];
		$choices = explode( '|', $matches[1] );

		// Trim and filter empty choices for safety.
		$choices = array_values( array_filter( array_map( static function ( $c ): string {
			return is_string( $c ) ? trim( $c ) : '';
		}, $choices ), static function ( $c ): bool {
			return $c !== '';
		} ) );

		$replacement = '';
		if ( count( $choices ) > 0 ) {
			$index       = wp_rand( 0, count( $choices ) - 1 );
			$replacement = $choices[ $index ];
		}

		$text = str_replace( $group, $replacement, $text );
	}

	return $text;
}
