/* global ajaxurl, jQuery */
(function($){
  $(document).ready(function(){
    // Initialize sliders
    $("#variations-slider").slider({ min: 1, max: 10, value: 5, step: 1, slide: function(event, ui) { $("#variations-value").text(ui.value); $("#max_variations").val(ui.value); } });
    $("#variations-value").text($("#variations-slider").slider("value"));
    $("#max_variations").val($("#variations-slider").slider("value"));

    $("#spins-slider").slider({ min: 1, max: 10, value: 5, step: 1, slide: function(event, ui) { $("#spins-value").text(ui.value); $("#num_spins").val(ui.value); } });

    // Context menu for generating alternatives for selected text
    const contextMenu = $('<div id="spintax-context-menu"><button class="button button-small button-primary">Generate Alternatives</button></div>')
      .css({ 'position': 'fixed', 'z-index': '999999', 'display': 'none', 'background': '#fff', 'border': '1px solid #2271b1', 'padding': '5px', 'border-radius': '3px', 'box-shadow': '0 2px 5px rgba(0,0,0,0.3)', 'font-size': '13px', 'font-weight': '500' })
      .find('button').css('white-space', 'nowrap').end()
      .appendTo('body');

    let lastSelectionStart = 0;
    let lastSelectionEnd = 0;

    $('#spintax_input').on('mouseup', function(e) {
      const selectedText = window.getSelection().toString().trim();
      if (selectedText) {
        lastSelectionStart = this.selectionStart;
        lastSelectionEnd = this.selectionEnd;
        contextMenu.css({ 'left': e.pageX + 'px', 'top': e.pageY + 'px', 'display': 'block' });
        contextMenu.data('selectedText', selectedText);
        return false;
      } else {
        contextMenu.hide();
      }
    });
    $(document).on('mousedown', function(e) { if (!$(e.target).closest('#spintax-context-menu').length) { contextMenu.hide(); } });
    $(document).on('click', '#spintax-context-menu button', function(e) { e.preventDefault(); e.stopPropagation(); contextMenu.hide(); });

    // Trigger alternatives generation
    $(document).on('click', '#spintax-context-menu button', function(e) {
      e.preventDefault(); e.stopPropagation();
      const word = contextMenu.data('selectedText') || '';
      if (!word) { return; }
      $('.contentweaver-loading-overlay').fadeIn();
      $.ajax({
        url: ajaxurl,
        type: 'POST',
        dataType: 'json',
        data: { action: 'cw_lite_generate_word_alternatives', nonce: $('#spintax_nonce').val(), word: word, max_variations: $('#max_variations').val() },
        success: function(response) {
          if (response.success && response.data && response.data.spintax) {
            const textarea = document.getElementById('spintax_input');
            if (textarea) {
              const currentText = textarea.value;
              textarea.value = currentText.substring(0, lastSelectionStart) + response.data.spintax + currentText.substring(lastSelectionEnd);
            }
          } else {
            const msg = (response && response.data && response.data.message) || 'Failed to generate alternatives';
            window.alert(msg);
          }
        },
        error: function() { window.alert('Error generating alternatives'); },
        complete: function() { $('.contentweaver-loading-overlay').fadeOut(); contextMenu.hide(); }
      });
    });

    // Process spintax locally (multiple spins)
    $('#process-spintax').on('click', function() {
      const spintaxText = $('#spintax_input').val();
      if (!spintaxText) return;
      $('.contentweaver-loading-overlay').fadeIn();
      $.ajax({
        url: ajaxurl,
        type: 'POST',
        data: { action: 'cw_lite_process_basic_spintax', nonce: $('#spintax_nonce').val(), spintax: spintaxText, max_variations: $('#max_variations').val(), num_spins: $('#num_spins').val() },
        success: function(response) {
          if (response.success && response.data && Array.isArray(response.data.variations)) {
            $('#preview').val(response.data.variations.join("\n\n"));
            window.currentSpintaxVariations = response.data.variations;
          } else {
            $('#preview').val('Error: Invalid response format from server');
            window.currentSpintaxVariations = [];
          }
        },
        error: function() { $('#preview').val('Error processing spintax'); window.currentSpintaxVariations = []; },
        complete: function() { $('.contentweaver-loading-overlay').fadeOut(); }
      });
    });

    // Generate AI spintax for {*AI*} markers
    $('#generate-ai').on('click', function(e) {
      e.preventDefault();
      const $button = $(this);
      $button.prop('disabled', true);
      const spintaxText = $('#spintax_input').val();
      if (!spintaxText.trim()) { $button.prop('disabled', false); return; }
      $('.contentweaver-loading-overlay').fadeIn();
      $.ajax({
        url: ajaxurl,
        type: 'POST',
        dataType: 'json',
        data: { action: 'cw_lite_process_basic_spintax', nonce: $('#spintax_nonce').val(), spintax: spintaxText, max_variations: $('#max_variations').val(), generate_ai: 'true' },
        success: function(response) {
          if (response.success && response.data && Array.isArray(response.data.suggestions)) {
            let updatedText = spintaxText;
            let hasReplacements = false;
            response.data.suggestions.forEach(function(suggestion) {
              const alternatives = Array.isArray(suggestion.alternatives) ? suggestion.alternatives : [];
              if (alternatives.length > 0) {
                const newSpintax = '{' + [suggestion.original].concat(alternatives).join('|') + '}';
                const aiPattern = new RegExp('{([^}]*\\*AI\\*[^}]*)}');
                updatedText = updatedText.replace(aiPattern, newSpintax);
                hasReplacements = true;
              }
            });
            if (hasReplacements) {
              $('#spintax_input').val(updatedText);
              $('#preview').val('AI suggestions have been added to your spintax!');
            }
          }
        },
        complete: function() { $button.prop('disabled', false); $('.contentweaver-loading-overlay').fadeOut(); }
      });
    });

    // Apply selected suggestions – left as-is in case a suggestions UI appears
    $(document).on('click', '#apply-suggestions', function() {
      let text = $('#spintax_input').val();
      $('.suggestion-group').each(function() {
        const originalHeader = $(this).find('h4').text();
        const original = originalHeader.replace('Original: ', '');
        const selected = [];
        $(this).find('input[type="checkbox"]:checked').each(function() { selected.push($(this).val()); });
        if (selected.length > 0) {
          const pattern = new RegExp('{([^}]*\\*AI\\*[^}]*)}');
          const replacement = '{' + [original].concat(selected).join('|') + '}';
          text = text.replace(pattern, replacement);
        }
      });
      $('#spintax_input').val(text);
      $('#ai-suggestions-row').hide();
    });

    $('#cancel-suggestions').on('click', function(){ $('#ai-suggestions-row').hide(); });

    $('#copy-spintax').on('click', function() {
      var $btn = $(this);
      var variations = window.currentSpintaxVariations || [];
      var text = variations.length ? variations.join('\n\n') : $('#preview').val();
      if (!text || !text.trim()) { window.alert('Please generate variations first.'); return; }
      navigator.clipboard.writeText(text).then(function(){
        var original = $btn.text();
        $btn.text('Copied!');
        setTimeout(function(){ $btn.text(original); }, 1200);
      });
    });
  });
})(jQuery);
