(function($){
  // Debug flag controls rendering of CC0 debug UI and console logs
  var debugEnabled = false;
  function logDebug(){ if (debugEnabled && window.console && console.debug) { try { console.debug.apply(console, arguments); } catch(e) {} } }
  function logError(){ if (debugEnabled && window.console && console.error) { try { console.error.apply(console, arguments); } catch(e) {} } }
  // ----- Top-of-page notice helper -----
  function showTopNotice(msg, type){
    var $wrap = $('.wrap').first();
    if (!$wrap.length) { return; }
    var cls = (type === 'error') ? 'notice-error' : 'notice-success';
    var safeMsg = $('<div/>').text(msg).html();
    var html = '' +
      '<div class="notice ' + cls + ' is-dismissible cw-lite-top-notice">' +
      '  <p>' + safeMsg + '</p>' +
      '  <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>' +
      '</div>';
    $wrap.find('.cw-lite-top-notice').remove();
    $wrap.prepend(html);
    // Bind dismiss click for dynamically added notice
    $wrap.find('.cw-lite-top-notice .notice-dismiss').on('click', function(){
      $(this).closest('.cw-lite-top-notice').remove();
    });
    // Ensure the user sees it
    try { window.scrollTo({ top: 0, behavior: 'smooth' }); } catch(e) { window.scrollTo(0, 0); }
  }
  // ----- Featured Image Mode: Default Image Picker -----
  function updateDefaultImageControlsVisibility(){
    var isDefault = $('#cw-lite-fimg-default').is(':checked');
    var $box = $('#cw-lite-default-image-controls');
    if ($box.length){ $box.toggle(isDefault); }
  }

  function updateCc0DisclaimerVisibility(){
    var isCc0 = $('#cw-lite-fimg-cc0').is(':checked');
    var $disc = $('#cw-lite-cc0-disclaimer');
    if ($disc.length){ $disc.toggle(isCc0); }
  }

  $(document).on('change', '#cw-lite-fimg-none, #cw-lite-fimg-default, #cw-lite-fimg-siteicon, #cw-lite-fimg-cc0', function(){
    updateDefaultImageControlsVisibility();
    updateCc0DisclaimerVisibility();
  });

  var cwLiteMediaFrame = null;
  $(document).on('click', '#cw-lite-select-default-image', function(e){
    e.preventDefault();
    if (typeof wp === 'undefined' || !wp.media) {
      alert('Media library is not available.');
      return;
    }
    if (cwLiteMediaFrame) {
      try { cwLiteMediaFrame.close(); } catch(e) {}
    }
    cwLiteMediaFrame = wp.media({
      title: 'Select Default Featured Image',
      button: { text: 'Use this image' },
      multiple: false
    });
    cwLiteMediaFrame.on('select', function(){
      var attachment = cwLiteMediaFrame.state().get('selection').first().toJSON();
      var id = attachment && attachment.id ? attachment.id : 0;
      if (!id) { return; }
      var thumbUrl = (attachment.sizes && attachment.sizes.thumbnail) ? attachment.sizes.thumbnail.url : attachment.url;
      $('#cw_lite_default_image_id').val(String(id));
      $('#cw-lite-default-image-preview').html('<img src="' + $('<div/>').text(thumbUrl).html() + '" style="max-width:150px;height:auto;" />');
      $('#cw-lite-clear-default-image').prop('disabled', false);
    });
    cwLiteMediaFrame.open();
  });

  $(document).on('click', '#cw-lite-clear-default-image', function(e){
    e.preventDefault();
    $('#cw_lite_default_image_id').val('');
    $('#cw-lite-default-image-preview').empty();
    $(this).prop('disabled', true);
  });

  // Initialize visibility on ready
  $(function(){
    updateDefaultImageControlsVisibility();
    updateCc0DisclaimerVisibility();
  });

  function renderResults($container, payload) {
    if (!payload || typeof payload !== "object") {
      $container.html('<div class="notice notice-error"><p>Unexpected response.</p></div>');
      return;
    }
    var esc = function(str){ return $('<div/>').text(String(str)).html(); };
    var items = [
      { k: "Requested", v: payload.requested + " posts" },
      { k: "Voice", v: payload.voice },
      { k: "Imported", v: payload.imported },
      { k: "Parsed", v: payload.parsed },
      { k: "Duplicates", v: payload.duplicates },
      { k: "Fetched (full)", v: payload.fetched_full },
      { k: "Rewrote", v: payload.rewrites },
      { k: "Titles Set", v: payload.titles_set },
      { k: "Images Set", v: payload.images_set },
      { k: "Tags Assigned", v: payload.tags_assigned }
    ];
    if (typeof payload.cc0_searches !== 'undefined') {
      items.push({ k: "Public Domain Searches", v: payload.cc0_searches });
    }
    if (typeof payload.cc0_downloads !== 'undefined') {
      items.push({ k: "Public Domain Downloads", v: payload.cc0_downloads });
    }
    if (typeof payload.cc0_failures !== 'undefined') {
      items.push({ k: "Public Domain Failures", v: payload.cc0_failures });
    }
    var firstTitles = Array.isArray(payload.first_titles) ? payload.first_titles : [];
    var cc0Debug = (payload && typeof payload.cc0_debug === 'object' && payload.cc0_debug !== null) ? payload.cc0_debug : null;
    var cc0Attempts = (cc0Debug && Array.isArray(cc0Debug.attempts)) ? cc0Debug.attempts : [];
    var cc0ItemDebug = Array.isArray(payload.cc0_item_debug) ? payload.cc0_item_debug : [];

    var html = '';
    html += '<div class="cw-lite-results-card">';
    html += '  <h3>RSS Lite Results</h3>';
    html += '  <ul class="cw-lite-results-list">';
    items.forEach(function(it){
      html += '    <li><strong>' + esc(it.k) + ':</strong> ' + esc(it.v) + '</li>';
    });
    html += '  </ul>';
    if (firstTitles.length) {
      html += '  <div class="cw-lite-results-sub">';
      html += '    <strong>First titles:</strong>';
      html += '    <ul class="cw-lite-first-titles">';
      firstTitles.forEach(function(t){ html += '      <li>' + esc(t) + '</li>'; });
      html += '    </ul>';
      html += '  </div>';
    }
    if (debugEnabled && cc0ItemDebug.length) {
      html += '  <div class="cw-lite-results-sub">';
      html += '    <strong>Per-Item Public Domain Attempts:</strong>';
      html += '    <ul class="cw-lite-cc0-items">';
      cc0ItemDebug.forEach(function(row){
        if (!row || typeof row !== 'object') { return; }
        var title = row.title ? String(row.title) : '(untitled)';
        var used = row.used_candidate ? String(row.used_candidate) : '';
        var imgq = row.image_query ? String(row.image_query) : '';
        var sel  = row.selected_image ? String(row.selected_image) : '';
        var attempts = Array.isArray(row.attempts) ? row.attempts : [];
        html += '      <li>';
        html += '        <div><strong>Title:</strong> ' + esc(title) + '</div>';
        if (imgq) { html += '        <div><strong>ImageQuery:</strong> ' + esc(imgq) + '</div>'; }
        if (used) { html += '        <div><strong>Used Query:</strong> ' + esc(used) + '</div>'; }
        if (sel) { html += '        <div><strong>Selected Image:</strong> ' + esc(sel) + '</div>'; }
        if (attempts.length) {
          html += '        <ul class="cw-lite-cc0-item-attempts">';
          attempts.forEach(function(at, idx){
            if (!at || typeof at !== 'object') { return; }
            var u = at.url ? String(at.url) : '';
            var s = (typeof at.status !== 'undefined') ? String(at.status) : '0';
            var e = at.error ? String(at.error) : '';
            var h = u ? encodeURI(u) : '';
            var label = 'Attempt ' + String(idx + 1) + ': ';
            if (u) {
              html += '          <li>' + esc(label) + '<a href="' + h + '" target="_blank" rel="noopener noreferrer">' + esc(u) + '</a> (status ' + esc(s) + (e ? ', error: ' + esc(e) : '') + ')</li>';
            } else {
              html += '          <li>' + esc(label) + '(status ' + esc(s) + (e ? ', error: ' + esc(e) : '') + ')</li>';
            }
          });
          html += '        </ul>';
        }
        html += '      </li>';
      });
      html += '    </ul>';
      html += '  </div>';
    }
    if (debugEnabled && cc0Debug) {
      html += '  <div class="cw-lite-results-sub">';
      html += '    <strong>Public Domain Debug:</strong>';
      if (cc0Debug.url) {
        var lastUrl = String(cc0Debug.url);
        var href = encodeURI(lastUrl);
        var statusTxt = 'status ' + String(cc0Debug.status || 0);
        var errTxt = cc0Debug.error ? ('; error: ' + esc(cc0Debug.error)) : '';
        html += '    <div>Last URL: <a href="' + href + '" target="_blank" rel="noopener noreferrer">' + esc(lastUrl) + '</a> (' + esc(statusTxt) + errTxt + ')</div>';
      }
      if (cc0Attempts.length) {
        html += '    <ul class="cw-lite-cc0-attempts">';
        cc0Attempts.forEach(function(at, idx){
          if (!at || typeof at !== 'object') { return; }
          var u = at.url ? String(at.url) : '';
          var s = (typeof at.status !== 'undefined') ? String(at.status) : '0';
          var e = at.error ? String(at.error) : '';
          var h = u ? encodeURI(u) : '';
          var label = 'Attempt ' + String(idx + 1) + ': ';
          if (u) {
            html += '      <li>' + esc(label) + '<a href="' + h + '" target="_blank" rel="noopener noreferrer">' + esc(u) + '</a> (status ' + esc(s) + (e ? ', error: ' + esc(e) : '') + ')</li>';
          } else {
            html += '      <li>' + esc(label) + '(status ' + esc(s) + (e ? ', error: ' + esc(e) : '') + ')</li>';
          }
        });
        html += '    </ul>';
      }
      html += '  </div>';
    }
    if (payload.message) {
      html += '  <div class="cw-lite-results-msg">' + esc(payload.message) + '</div>';
    }
    html += '</div>';

    $container.html(html);
  }

  function showOverlay($overlay, text) {
    $overlay.find('.contentweaver-loading-message').text(text || '');
    $overlay.show();
  }
  function hideOverlay($overlay) { $overlay.hide(); }

  $(document).on('submit', '#cw-lite-run-form', function(e){
    e.preventDefault();
    var $form = $(this);
    var $btn = $form.find('button, input[type=submit]').first();
    var $overlay = $('.contentweaver-loading-overlay');
    if (!$overlay.length) {
      // Fallback: inject overlay if not present in markup
      $('body').append(
        '<div class="contentweaver-loading-overlay" style="display:none;" aria-hidden="true">\
           <div class="contentweaver-spinner" aria-label="spinner"></div>\
           <div class="contentweaver-loading-message"></div>\
         </div>'
      );
      $overlay = $('.contentweaver-loading-overlay');
    }
    var $results = $('#cw-lite-results');

    logDebug('CW Lite: Run Now intercepted, sending AJAX…');
    $btn.prop('disabled', true);
    showOverlay($overlay, (window.cwLiteRSS && cwLiteRSS.i18n && cwLiteRSS.i18n.running) ? cwLiteRSS.i18n.running : 'Running…');
    $results.empty();

    var data = {
      action: 'contentweaver_ai_lite_rss_run',
      _ajax_nonce: (window.cwLiteRSS ? cwLiteRSS.nonce : '')
    };

    $.post((window.cwLiteRSS ? cwLiteRSS.ajaxUrl : ajaxurl), data)
      .done(function(resp){
        logDebug('CW Lite: AJAX done', resp);
        if (resp && resp.success && resp.data) {
          renderResults($results, resp.data);
        } else {
          var msg = (resp && resp.data && resp.data.message) ? resp.data.message : ((window.cwLiteRSS && cwLiteRSS.i18n && cwLiteRSS.i18n.error) ? cwLiteRSS.i18n.error : 'Error');
          // Top-of-page admin notice (dismissible)
          showTopNotice(msg, 'error');
          // Clear bottom panel on error to avoid duplicate notices
          $results.empty();
        }
      })
      .fail(function(){
        logError('CW Lite: AJAX failed');
        var msg = (window.cwLiteRSS && cwLiteRSS.i18n && cwLiteRSS.i18n.error) ? cwLiteRSS.i18n.error : 'Error';
        // Top-of-page admin notice (dismissible)
        showTopNotice(msg, 'error');
        // Clear bottom panel on error to avoid duplicate notices
        $results.empty();
      })
      .always(function(){
        hideOverlay($overlay);
        $btn.prop('disabled', false);
      });
  });
})(jQuery);
