/* global ajaxurl, jQuery, wp */
(function($){
  $(document).ready(function(){
    var requestInProgress = false;

    function updateDefaultImageControlsVisibility(){
      var isDefault = $("#cw-lite-fimg-default").is(":checked");
      var $box = $("#cw-lite-default-image-controls");
      if ($box.length){ $box.toggle(isDefault); }
    }
    function updateCc0DisclaimerVisibility(){
      var isCc0 = $("#cw-lite-fimg-cc0").is(":checked");
      var $disc = $("#cw-lite-cc0-disclaimer");
      if ($disc.length){ $disc.toggle(isCc0); }
    }
    $(document).on("change", "#cw-lite-fimg-none, #cw-lite-fimg-default, #cw-lite-fimg-siteicon, #cw-lite-fimg-cc0", function(){
      updateDefaultImageControlsVisibility();
      updateCc0DisclaimerVisibility();
    });

    // Media picker for Default Image
    var cwLiteMediaFrame = null;
    $(document).on("click", "#cw-lite-select-default-image", function(e){
      e.preventDefault();
      if (typeof wp === "undefined" || !wp.media) { window.alert("Media library is not available."); return; }
      if (cwLiteMediaFrame) { try { cwLiteMediaFrame.close(); } catch(err) { /* noop */ } }
      cwLiteMediaFrame = wp.media({ title: "Select Default Featured Image", button: { text: "Use this image" }, multiple: false });
      cwLiteMediaFrame.on("select", function(){
        var attachment = cwLiteMediaFrame.state().get("selection").first().toJSON();
        var id = (attachment && attachment.id) ? attachment.id : 0;
        if (!id) { return; }
        var thumbUrl = (attachment.sizes && attachment.sizes.thumbnail) ? attachment.sizes.thumbnail.url : attachment.url;
        $("#cw_lite_default_image_id").val(String(id));
        $("#cw-lite-default-image-preview").html('<img src="' + $("<div/>").text(thumbUrl).html() + '" style="max-width:150px;height:auto;" />');
        $("#cw-lite-clear-default-image").prop("disabled", false);
      });
      cwLiteMediaFrame.open();
    });
    $(document).on("click", "#cw-lite-clear-default-image", function(e){
      e.preventDefault();
      $("#cw_lite_default_image_id").val("");
      $("#cw-lite-default-image-preview").empty();
      $(this).prop("disabled", true);
    });

    // Mutual exclusivity UX for URL/Text
    function updateUrlTextDisabling() {
      var urlVal = String($("#article_url").val() || "").trim();
      var txtVal = String($("#article_text").val() || "").trim();
      if (urlVal.length > 0) {
        $("#article_text").prop("disabled", true);
        $("#article_url").prop("disabled", false);
      } else if (txtVal.length > 0) {
        $("#article_url").prop("disabled", true);
        $("#article_text").prop("disabled", false);
      } else {
        $("#article_url, #article_text").prop("disabled", false);
      }
    }
    $("#article_url, #article_text").on("input change", function(){ updateUrlTextDisabling(); });

    // Initialize visibility
    updateDefaultImageControlsVisibility();
    updateCc0DisclaimerVisibility();
    updateUrlTextDisabling();

    // Submit handler: create draft post with image mode (AJAX)
    $("#manual-generation-form").on("submit", function(e) {
      e.preventDefault();
      if (requestInProgress) { return false; }
      var url = $("#article_url").val();
      var text = $("#article_text").val();
      if ((!url || !String(url).trim()) && (!text || !String(text).trim())) { window.alert("Provide a URL or paste article text."); return false; }

      requestInProgress = true;
      $("#generate-button").prop("disabled", true);
      $(".contentweaver-loading-message").html("Generating and creating draft... Please wait.");
      $(".contentweaver-loading-overlay").fadeIn();
      $("#cw-lite-results").empty();

      var data = {
        action: "cw_lite_manual_generate_post",
        nonce: $("#nonce").val(),
        article_url: url,
        article_text: text,
        voice_id: $("#voice").val(),
        featured_image_mode: $("input[name=\"featured_image_mode\"]:checked").val(),
        default_image_id: $("#cw_lite_default_image_id").val()
      };

      $.ajax({
        url: ajaxurl,
        type: "POST",
        dataType: "json",
        data: data,
        success: function(response) {
          if (response && response.success && response.data) {
            var msg = response.data.message || "Draft created.";
            var id = (response.data.post_id) ? parseInt(response.data.post_id, 10) : 0;
            var adminBase = (typeof ajaxurl === "string") ? ajaxurl.replace(/admin-ajax\.php.*/, "") : "/wp-admin/";
            var editUrl = id > 0 ? (adminBase + "post.php?post=" + String(id) + "&action=edit") : "";
            var linkHtml = editUrl ? '<p><a class="button button-primary" href="' + $("<div/>").text(editUrl).html() + '">Edit Draft</a></p>' : '';

            // Diagnostics panel (subset)
            var dbg = (response.data.debug && typeof response.data.debug === "object") ? response.data.debug : null;
            var esc = function(s){ return $("<div/>").text(String(s || "")).html(); };
            var diagHtml = '';
            if (dbg) {
              var fim = dbg.featured_image_mode || '';
              var sel = dbg.selected_image || '';
              var iq  = dbg.image_query || '';
              diagHtml += '<div class="cw-lite-results-card" style="margin-top:12px;">';
              diagHtml += '  <h3>Manual Generation Diagnostics</h3>';
              diagHtml += '  <ul class="cw-lite-results-list">';
              if (fim) { diagHtml += '    <li><strong>Featured Image Mode:</strong> ' + esc(fim) + '</li>'; }
              if (sel) { diagHtml += '    <li><strong>Selected Image:</strong> ' + esc(sel) + '</li>'; }
              if (iq)  { diagHtml += '    <li><strong>ImageQuery:</strong> ' + esc(iq) + '</li>'; }
              diagHtml += '  </ul>';
              diagHtml += '</div>';
            }

            $("#cw-lite-results").html('<div class="cw-lite-results-card"><h3>Manual Generation</h3><div class="cw-lite-results-sub">' + $("<div/>").text(msg).html() + '</div>' + linkHtml + '</div>' + (diagHtml || ''));
          } else {
            var emsg = (response && response.data && (response.data.message || response.data.error)) || (response && response.message) || "Unknown error";
            $("#cw-lite-results").html('<div class="notice notice-error"><p>' + $("<div/>").text(emsg).html() + '</p></div>');
          }
        },
        error: function() {
          $("#cw-lite-results").html('<div class="notice notice-error"><p>Request failed</p></div>');
        },
        complete: function() {
          $(".contentweaver-loading-overlay").fadeOut();
          requestInProgress = false;
          $("#generate-button").prop("disabled", false);
        }
      });
    });
  });
})(jQuery);
