<?php
/**
 * Uninstall ContentPulse Plugin
 *
 * @package ContentPulse
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Remove plugin options
delete_option( 'contentpulse_review_frequency' );
delete_option( 'contentpulse_email_notifications' );
delete_option( 'contentpulse_notification_email' );

// Remove scheduled events
wp_clear_scheduled_hook( 'contentpulse_daily_email' );

// Remove all post meta data created by the plugin
delete_post_meta_by_key( '_contentpulse_last_reviewed' );
delete_post_meta_by_key( '_contentpulse_next_review_date' );

// Optional: Remove any transients (if you add any in future)
// delete_transient( 'contentpulse_cache_key' );
