jQuery(function($) {
	$(document).ready(function(){
		const nonce = ContrmScriptData.nonce;
		$('#cur-send-manual').on('click', function() {
			var $button = $(this);
			var $status = $('#cur-manual-status');

			$button.prop('disabled', true).text(ContrmScriptData.sendingText);

			$.ajax({
				url: ajaxurl,
				type: 'POST',
				data: {
					action: 'contrm_send_manual_reminder',
					nonce: nonce
				},
				success: function(response) {
					if (response.success) {
						$status.html('<div class="notice notice-success inline"><p>' + ContrmScriptData.reminderText + '</p></div>');
					} else {
						$status.html('<div class="notice notice-error inline"><p>' + ContrmScriptData.errorText + '</p></div>');
					}
				},
				error: function() {
					$status.html('<div class="notice notice-error inline"><p>' + ContrmScriptData.errorText + '</p></div>');
				},
				complete: function() {
					$button.prop('disabled', false).text(ContrmScriptData.sendText);
				}
			});
		});
	});
});