<?php
/**
 * Uninstall routine for Content Bridge for Commerce
 *
 * @package content-bridge-for-commerce
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

/**
 * Clean up plugin data on uninstall.
 */
function vowcbfc_uninstall_cleanup() {
	$option_key        = 'vowcbfc_settings';
	$cache_keys_option = 'vowcbfc_cache_keys';

	// Delete plugin settings.
	delete_option( $option_key );

	// Delete transients created by this plugin (tracked list).
	$keys = get_option( $cache_keys_option, [] );
	if ( is_array( $keys ) ) {
		foreach ( $keys as $k => $v ) {
			// Stored as associative array; key is the transient name.
			if ( is_string( $k ) && $k !== '' ) {
				delete_transient( $k );
			} elseif ( is_string( $v ) && $v !== '' ) {
				// Backward compatibility if list was stored as plain array.
				delete_transient( $v );
			}
		}
	}

	delete_option( $cache_keys_option );
}

vowcbfc_uninstall_cleanup();
