/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/block.json":
/*!************************!*\
  !*** ./src/block.json ***!
  \************************/
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$schema":"https://schemas.wp.org/trunk/block.json","apiVersion":3,"name":"iansvo/content-area","version":"0.1.0","title":"Content Area","category":"theme","icon":"layout","description":"Adds a block content area to a site editor template.","keywords":["content","area","meta","template","fse"],"attributes":{"metaKey":{"type":"string","default":"extra_content_area"},"disallowedBlocks":{"type":"array","default":[],"items":{"type":"string"}},"blockFilter":{"type":"string","enum":["allow","disallow"],"default":"allow"}},"supports":{"html":false,"allowedBlocks":true,"lock":false,"contentRole":true},"usesContext":["postId","postType","queryId"],"textdomain":"content-area-block","editorScript":"file:./index.js","render":"file:./render.php"}');

/***/ }),

/***/ "./src/edit.js":
/*!*********************!*\
  !*** ./src/edit.js ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ContentAreaEdit)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/editor */ "@wordpress/editor");
/* harmony import */ var _wordpress_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _hooks__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./hooks */ "./src/hooks.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__);
/**
 * WordPress dependencies
 */










const blockFilterTypes = [{
  value: 'allow',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Allow', 'content-area-block')
}, {
  value: 'disallow',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disallow', 'content-area-block')
}];
function ReadOnlyContent({
  parentLayout,
  layoutClassNames,
  userCanEdit,
  postType,
  postId,
  tagName: TagName = 'div'
}) {
  const [,, content] = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_7__.useEntityProp)('postType', postType, 'content', postId);
  const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_4__.useBlockProps)({
    className: layoutClassNames
  });
  const blocks = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => {
    return content?.raw ? (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_3__.parse)(content.raw) : [];
  }, [content?.raw]);
  const blockPreviewProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_4__.__experimentalUseBlockPreview)({
    blocks,
    props: blockProps,
    layout: parentLayout
  });
  if (userCanEdit) {
    /*
     * Rendering the block preview using the raw content blocks allows for
     * block support styles to be generated and applied by the editor.
     *
     * The preview using the raw blocks can only be presented to users with
     * edit permissions for the post to prevent potential exposure of private
     * block content.
     */
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
      ...blockPreviewProps
    });
  }
  return content?.protected ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(TagName, {
    ...blockProps,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_4__.Warning, {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('This content is password protected.', 'content-area-block')
    })
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(TagName, {
    ...blockProps,
    dangerouslySetInnerHTML: {
      __html: content?.rendered
    }
  });
}
function EditableContent({
  layout,
  context = {},
  attributes = {}
}) {
  const {
    allowedBlocks = [],
    disallowedBlocks = [],
    blockFilter = 'allow'
  } = attributes;
  const {
    blocks,
    onChange,
    onInput
  } = (0,_hooks__WEBPACK_IMPORTED_MODULE_8__.useMetaBlockEditor)({
    attributes,
    context
  });
  const allowedBlocksList = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => {
    const blockTypes = (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_3__.getBlockTypes)();
    const filterMode = blockFilter === 'allow' && Array.isArray(allowedBlocks) ? 'allow' : 'disallow';
    let list = filterMode === 'allow' ? allowedBlocks : blockTypes.map(({
      name
    }) => name);
    list = blockFilter === 'disallow' ? list.filter(blockType => !disallowedBlocks.includes(blockType)) : list;

    // Always ensure paragraph is available
    if (list.length > 0 && !list.includes('core/paragraph')) {
      list = ['core/paragraph', ...list];
    }
    return list;
  }, [blockFilter, allowedBlocks, disallowedBlocks]);
  const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_4__.useBlockProps)();
  const innerBlocksProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_4__.useInnerBlocksProps)(blockProps, {
    value: blocks,
    onInput,
    onChange,
    allowedBlocks: allowedBlocksList.length > 0 ? allowedBlocksList : undefined,
    template: !blocks?.length ? [['core/paragraph']] : undefined
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
    ...innerBlocksProps
  });
}
function Content(props) {
  const {
    context: {
      queryId,
      postType,
      postId
    } = {}
  } = props;
  const isDescendentOfQueryLoop = Number.isFinite(queryId);
  const userCanEdit = (0,_hooks__WEBPACK_IMPORTED_MODULE_8__.useCanEditEntity)('postType', postType, postId);
  const isEditable = userCanEdit && !isDescendentOfQueryLoop;
  return isEditable ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(EditableContent, {
    ...props
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(ReadOnlyContent, {
    userCanEdit: userCanEdit,
    postType: postType,
    postId: postId
  });
}
function Placeholder({
  metaKey = ''
}) {
  const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_4__.useBlockProps)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
    ...blockProps,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
      children: metaKey ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(
      // Translators: %s is the metaKey attribute value.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Post Content from meta_key: %s', 'content-area-block'), metaKey) : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Set a meta key to pull blocks from.', 'content-area-block')
    })
  });
}
function RecursionError() {
  const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_4__.useBlockProps)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
    ...blockProps,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_4__.Warning, {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Block cannot be rendered inside itself.', 'content-area-block')
    })
  });
}
function ContentAreaEdit({
  context,
  attributes,
  setAttributes
}) {
  const {
    metaKey,
    allowedBlocks = [],
    disallowedBlocks = [],
    blockFilter = 'allow'
  } = attributes;
  const {
    layout = {}
  } = attributes;
  const {
    postId,
    postType,
    editingMode
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return {
      postId: select(_wordpress_editor__WEBPACK_IMPORTED_MODULE_2__.store).getCurrentPostId(),
      postType: select(_wordpress_editor__WEBPACK_IMPORTED_MODULE_2__.store).getCurrentPostType(),
      editingMode: select(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_4__.store).getBlockEditingMode()
    };
  });
  const [hasAlreadyRendered, RecursionProvider] = (0,_hooks__WEBPACK_IMPORTED_MODULE_8__.useNoRecursiveRenders)(postId);
  const isValidPostId = 'number' === typeof postId && postId;
  const handleMetaKeyChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(function handleMetaKeyChange(value) {
    setAttributes({
      metaKey: value
    });
  }, [setAttributes]);
  const handleAllowedBlocksChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(function handleAllowedBlocksChange(value) {
    setAttributes({
      allowedBlocks: value
    });
  }, [setAttributes]);
  const handleDisallowedBlocksChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(function handleDisallowedBlocksChange(value) {
    setAttributes({
      disallowedBlocks: value
    });
  }, [setAttributes]);
  const blockSuggestions = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => {
    const blockTypes = (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_3__.getBlockTypes)();
    return blockTypes.map(block => block.name);
  }, []);
  if (isValidPostId && postType && hasAlreadyRendered) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(RecursionError, {});
  }
  const showControls = editingMode === 'default';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(RecursionProvider, {
    children: [isValidPostId && postType ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(Content, {
      context: context,
      layout: layout,
      attributes: attributes,
      postId: postId,
      postType: postType
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(Placeholder, {
      metaKey: metaKey
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_4__.InspectorControls, {
      children: showControls ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Content Area Settings', 'content-area-block'),
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.TextControl, {
          __next40pxDefaultSize: true,
          __nextHasNoMarginBottom: true,
          value: metaKey,
          onChange: handleMetaKeyChange,
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Meta Key', 'content-area-block')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
          value: blockFilter,
          onChange: newValue => setAttributes({
            blockFilter: newValue
          }),
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Block Filter Type', 'content-area-block'),
          options: blockFilterTypes
        }), blockFilter === 'allow' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.FormTokenField, {
          __next40pxDefaultSize: true,
          __nextHasNoMarginBottom: true,
          value: allowedBlocks,
          onChange: handleAllowedBlocksChange,
          suggestions: blockSuggestions,
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Allowed Blocks', 'content-area-block')
        }), blockFilter === 'disallow' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.FormTokenField, {
          __next40pxDefaultSize: true,
          __nextHasNoMarginBottom: true,
          value: disallowedBlocks,
          onChange: handleDisallowedBlocksChange,
          suggestions: blockSuggestions,
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disallowed Blocks', 'content-area-block')
        })]
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        opened: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Notice, {
          isDismissible: false,
          status: "warning",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("h2", {
            style: {
              marginBlockStart: 0
            },
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Content Only Mode', 'content-area-block')
          }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Edit the template to change settings for this block.', 'content-area-block')]
        })
      })
    })]
  });
}

/***/ }),

/***/ "./src/filters.js":
/*!************************!*\
  !*** ./src/filters.js ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__);


//
function addCustomPostContentBlockTypes(blockTypes) {
  return [...blockTypes, 'iansvo/content-area'];
}
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__.addFilter)('editor.postContentBlockTypes', 'iansvo/content-area/post-content-block-types', addCustomPostContentBlockTypes);

/***/ }),

/***/ "./src/hooks.js":
/*!**********************!*\
  !*** ./src/hooks.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useCanEditEntity: () => (/* binding */ useCanEditEntity),
/* harmony export */   useMetaBlockEditor: () => (/* binding */ useMetaBlockEditor),
/* harmony export */   useNoRecursiveRenders: () => (/* binding */ useNoRecursiveRenders)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
/**
 * WordPress dependencies
 */






const RenderedRefsContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.createContext)({});

/**
 * Returns whether the current user can edit the given entity.
 *
 * @param {string} kind     Entity kind.
 * @param {string} name     Entity name.
 * @param {string} recordId Record's id.
 */
function useCanEditEntity(kind, name, recordId) {
  return (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__.store).canUser('update', {
    kind,
    name,
    id: recordId
  }), [kind, name, recordId]);
}

/**
 * Immutably adds an unique identifier to a set scoped for a given block type.
 *
 * @param {Object} renderedBlocks Rendered blocks grouped by block name
 * @param {string} blockName      Name of the block.
 * @param {*}      uniqueId       Any value that acts as a unique identifier for a block instance.
 *
 * @return {Object} The list of rendered blocks grouped by block name.
 */
function addToBlockType(renderedBlocks, blockName, uniqueId) {
  const result = {
    ...renderedBlocks,
    [blockName]: renderedBlocks[blockName] ? new Set(renderedBlocks[blockName]) : new Set()
  };
  result[blockName].add(uniqueId);
  return result;
}

/**
 * A React hook for keeping track of blocks previously rendered up in the block
 * tree. Blocks susceptible to recursion can use this hook in their `Edit`
 * function to prevent said recursion.
 *
 * @see https://github.com/iansvo/gutenberg/blob/a7e2895829c16ecd77a5ba22d84f1dee1cfb0977/packages/block-editor/src/components/use-no-recursive-renders/index.js
 *
 * @param {*}      uniqueId  Any value that acts as a unique identifier for a block instance.
 * @param {string} blockName Optional block name.
 *
 * @return {[boolean, Function]} A tuple of:
 *                               - a boolean describing whether the provided id
 *                                 has already been rendered;
 *                               - a React context provider to be used to wrap
 *                                 other elements.
 */
function useNoRecursiveRenders(uniqueId, blockName = '') {
  const previouslyRenderedBlocks = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useContext)(RenderedRefsContext);
  const {
    name
  } = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.useBlockEditContext)();
  blockName = blockName || name;
  const hasAlreadyRendered = Boolean(previouslyRenderedBlocks[blockName]?.has(uniqueId));
  const newRenderedBlocks = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => addToBlockType(previouslyRenderedBlocks, blockName, uniqueId), [previouslyRenderedBlocks, blockName, uniqueId]);
  const Provider = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useCallback)(({
    children
  }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(RenderedRefsContext.Provider, {
    value: newRenderedBlocks,
    children: children
  }), [newRenderedBlocks]);
  return [hasAlreadyRendered, Provider];
}
const EMPTY_ARRAY = [];
function useMetaBlockEditor({
  attributes,
  context
}) {
  const {
    postType,
    postId: contextPostId
  } = context;
  const providerId = (0,_wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__.useEntityId)('postType', postType);
  const postId = contextPostId !== null && contextPostId !== void 0 ? contextPostId : providerId;
  const {
    metaKey
  } = attributes;
  const BLOCKS_KEY = `${metaKey}_blocks`;
  const editedRecord = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const {
      getEditedEntityRecord
    } = select('core');
    return getEditedEntityRecord('postType', postType, postId);
  }, [postType, postId]);
  const {
    meta
  } = editedRecord;
  const content = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => meta?.[metaKey] || '', [meta, metaKey]);
  const [localBlocks, setLocalBlocks] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(() => editedRecord?.[BLOCKS_KEY]);
  const blocks = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
    // If we have local blocks from a recent edit, use those
    if (localBlocks) {
      return localBlocks;
    }
    // Otherwise use stored blocks
    if (editedRecord?.[BLOCKS_KEY]) {
      return editedRecord[BLOCKS_KEY];
    }
    if (content) {
      return (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__.parse)(content);
    }
    return EMPTY_ARRAY;
  }, [localBlocks, editedRecord, BLOCKS_KEY, content]);
  const {
    editEntityRecord,
    __unstableCreateUndoLevel
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__.store);

  // Clear local blocks when content is successfully saved
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (editedRecord?.[BLOCKS_KEY] && localBlocks) {
      setLocalBlocks(null);
    }
  }, [editedRecord, BLOCKS_KEY, localBlocks]);
  const onChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useCallback)(newBlocks => {
    const noChange = blocks === newBlocks;
    if (noChange) {
      return __unstableCreateUndoLevel('postType', postType, postId);
    }
    const serializedContent = (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__.__unstableSerializeAndClean)(newBlocks);

    // Set local blocks immediately for UI responsiveness
    setLocalBlocks(newBlocks);
    const edits = {
      [BLOCKS_KEY]: newBlocks,
      meta: {
        ...meta,
        [metaKey]: serializedContent
      }
    };
    editEntityRecord('postType', postType, postId, edits, {
      isCached: false
    });
  }, [BLOCKS_KEY, blocks, editEntityRecord, meta, metaKey, postId, postType, __unstableCreateUndoLevel]);
  const onInput = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useCallback)(newBlocks => {
    // Set local blocks immediately for UI responsiveness
    setLocalBlocks(newBlocks);
    const serializedContent = (0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__.__unstableSerializeAndClean)(newBlocks);
    const edits = {
      [BLOCKS_KEY]: newBlocks,
      meta: {
        ...meta,
        [metaKey]: serializedContent
      }
    };
    editEntityRecord('postType', postType, postId, edits, {
      isCached: true
    });
  }, [BLOCKS_KEY, editEntityRecord, meta, metaKey, postId, postType]);
  return {
    blocks,
    onChange,
    onInput
  };
}

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ ((module) => {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/core-data":
/*!**********************************!*\
  !*** external ["wp","coreData"] ***!
  \**********************************/
/***/ ((module) => {

module.exports = window["wp"]["coreData"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/editor":
/*!********************************!*\
  !*** external ["wp","editor"] ***!
  \********************************/
/***/ ((module) => {

module.exports = window["wp"]["editor"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/hooks":
/*!*******************************!*\
  !*** external ["wp","hooks"] ***!
  \*******************************/
/***/ ((module) => {

module.exports = window["wp"]["hooks"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "react/jsx-runtime":
/*!**********************************!*\
  !*** external "ReactJSXRuntime" ***!
  \**********************************/
/***/ ((module) => {

module.exports = window["ReactJSXRuntime"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!**********************!*\
  !*** ./src/index.js ***!
  \**********************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./edit */ "./src/edit.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./block.json */ "./src/block.json");
/* harmony import */ var _filters__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./filters */ "./src/filters.js");




(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_2__.name, {
  edit: _edit__WEBPACK_IMPORTED_MODULE_1__["default"],
  save: () => null
});
})();

/******/ })()
;
//# sourceMappingURL=index.js.map